/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.session.impl;

import com.taobao.arthas.core.distribution.SharingResultDistributor;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionImpl
implements Session {
    private static final AtomicInteger lockSequence = new AtomicInteger();
    private static final int LOCK_TX_EMPTY = -1;
    private final AtomicInteger lock = new AtomicInteger(-1);
    private Map<String, Object> data = new ConcurrentHashMap<String, Object>();

    public SessionImpl() {
        long now = System.currentTimeMillis();
        this.data.put("createTime", now);
        this.setLastAccessTime(now);
    }

    @Override
    public Session put(String key, Object obj) {
        if (obj == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, obj);
        }
        return this;
    }

    @Override
    public <T> T get(String key) {
        return (T)this.data.get(key);
    }

    @Override
    public <T> T remove(String key) {
        return (T)this.data.remove(key);
    }

    @Override
    public boolean tryLock() {
        return this.lock.compareAndSet(-1, lockSequence.getAndIncrement());
    }

    @Override
    public void unLock() {
        int currentLockTx = this.lock.get();
        if (!this.lock.compareAndSet(currentLockTx, -1)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean isLocked() {
        return this.lock.get() != -1;
    }

    @Override
    public int getLock() {
        return this.lock.get();
    }

    @Override
    public String getSessionId() {
        return (String)this.data.get("id");
    }

    @Override
    public long getPid() {
        return (Long)this.data.get("pid");
    }

    @Override
    public List<CommandResolver> getCommandResolvers() {
        InternalCommandManager commandManager = (InternalCommandManager)this.data.get("arthas-command-manager");
        return commandManager.getResolvers();
    }

    @Override
    public Instrumentation getInstrumentation() {
        return (Instrumentation)this.data.get("instrumentation");
    }

    @Override
    public void setLastAccessTime(long time) {
        this.put("lastAccessedTime", time);
    }

    @Override
    public long getLastAccessTime() {
        return (Long)this.data.get("lastAccessedTime");
    }

    @Override
    public long getCreateTime() {
        return (Long)this.data.get("createTime");
    }

    @Override
    public void setResultDistributor(SharingResultDistributor resultDistributor) {
        if (resultDistributor == null) {
            this.data.remove("resultDistributor");
        } else {
            this.data.put("resultDistributor", resultDistributor);
        }
    }

    @Override
    public SharingResultDistributor getResultDistributor() {
        return (SharingResultDistributor)this.data.get("resultDistributor");
    }

    @Override
    public void setForegroundJob(Job job) {
        if (job == null) {
            this.data.remove("foregroundJob");
        } else {
            this.data.put("foregroundJob", job);
        }
    }

    @Override
    public Job getForegroundJob() {
        return (Job)this.data.get("foregroundJob");
    }

    @Override
    public boolean isTty() {
        return this.get("tty") != null;
    }

    @Override
    public String getUserId() {
        return (String)this.data.get("userId");
    }

    @Override
    public void setUserId(String userId) {
        if (userId == null) {
            this.data.remove("userId");
        } else {
            this.data.put("userId", userId);
        }
    }
}

