/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function.monitor200;

import com.taobao.arthas.core.mcp.tool.function.AbstractArthasTool;
import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;

public class ProfilerTool
extends AbstractArthasTool {
    private static final String[] SUPPORTED_ACTIONS = new String[]{"start", "resume", "stop", "dump", "check", "status", "meminfo", "list", "version", "load", "execute", "dumpCollapsed", "dumpFlat", "dumpTraces", "getSamples", "actions"};

    @Tool(name="profiler", description="Async Profiler \u8bca\u65ad\u5de5\u5177: \u5bf9\u5e94 Arthas \u7684 profiler \u547d\u4ee4\uff0c\u7528\u4e8e\u91c7\u6837 CPU/alloc/lock \u7b49\u4e8b\u4ef6\u5e76\u8f93\u51fa flamegraph/jfr \u7b49\u683c\u5f0f\u3002\n\u5e38\u7528\u793a\u4f8b:\n- start: \u5f00\u59cb\u91c7\u6837\uff0c\u5982 action=start, event=cpu\n- stop: \u505c\u6b62\u5e76\u8f93\u51fa\u6587\u4ef6\uff0c\u5982 action=stop, format=flamegraph, file=/tmp/result.html\n- status/list/actions: \u67e5\u770b\u72b6\u6001/\u652f\u6301\u4e8b\u4ef6/\u652f\u6301\u52a8\u4f5c\n- execute: \u76f4\u63a5\u4f20\u9012 async-profiler agent \u517c\u5bb9\u53c2\u6570\uff0c\u5982 action=execute, actionArg=\"stop,file=/tmp/result.html\"")
    public String profiler(@ToolParam(description="\u52a8\u4f5c\uff08\u5fc5\u586b\uff09\uff0c\u53ef\u9009\u503c: start/resume/stop/dump/check/status/meminfo/list/version/load/execute/dumpCollapsed/dumpFlat/dumpTraces/getSamples/actions") String action, @ToolParam(description="\u52a8\u4f5c\u53c2\u6570\uff08\u53ef\u9009\uff09\u3002\u5f53 action=execute \u65f6\u5fc5\u586b\uff0c\u793a\u4f8b: \"stop,file=/tmp/result.html\"", required=false) String actionArg, @ToolParam(description="\u91c7\u6837\u4e8b\u4ef6 (--event)\uff0c\u5982 cpu/alloc/lock/wall\uff0c\u9ed8\u8ba4 cpu", required=false) String event, @ToolParam(description="\u91c7\u6837\u95f4\u9694 ns (--interval)\uff0c\u9ed8\u8ba4 10000000(10ms)", required=false) Long interval, @ToolParam(description="\u6700\u5927 Java \u6808\u6df1 (--jstackdepth)\uff0c\u9ed8\u8ba4 2048", required=false) Integer jstackdepth, @ToolParam(description="\u8f93\u51fa\u6587\u4ef6\u8def\u5f84 (--file)\u3002\u5982\u679c\u4ee5 .html/.jfr \u7ed3\u5c3e\u53ef\u63a8\u65ad format\uff1b\u4e5f\u53ef\u5305\u542b %t \u7b49\u5360\u4f4d\u7b26\uff08\u5982 /tmp/result-%t.html\uff09", required=false) String file, @ToolParam(description="\u8f93\u51fa\u683c\u5f0f (--format)\uff0c\u652f\u6301 flat[=N]|traces[=N]|collapsed|flamegraph|tree|jfr\uff08\u517c\u5bb9\u4f20\u5165 html\uff09", required=false) String format, @ToolParam(description="alloc \u4e8b\u4ef6\u91c7\u6837\u95f4\u9694\u5b57\u8282\u6570 (--alloc)\uff0c\u5982 1m/512k/1000 \u7b49", required=false) String alloc, @ToolParam(description="\u4ec5\u5bf9\u5b58\u6d3b\u5bf9\u8c61\u505a alloc \u7edf\u8ba1 (--live)", required=false) Boolean live, @ToolParam(description="lock \u4e8b\u4ef6\u9608\u503c ns (--lock)\uff0c\u5982 10ms/10000000 \u7b49", required=false) String lock, @ToolParam(description="\u4e0e profiler \u4e00\u8d77\u542f\u52a8 JFR (--jfrsync)\uff0c\u53ef\u4e3a\u9884\u7f6e profile \u540d\u79f0\u3001.jfc \u8def\u5f84\u6216 + \u4e8b\u4ef6\u5217\u8868", required=false) String jfrsync, @ToolParam(description="wall clock \u91c7\u6837\u95f4\u9694 ms (--wall)\uff0c\u63a8\u8350 200", required=false) Long wall, @ToolParam(description="\u6309\u7ebf\u7a0b\u533a\u5206\u91c7\u6837 (--threads)", required=false) Boolean threads, @ToolParam(description="\u6309\u8c03\u5ea6\u7b56\u7565\u5206\u7ec4\u7ebf\u7a0b (--sched)", required=false) Boolean sched, @ToolParam(description="C \u6808\u91c7\u6837\u65b9\u5f0f (--cstack)\uff0c\u53ef\u9009 fp|dwarf|lbr|no", required=false) String cstack, @ToolParam(description="\u4f7f\u7528\u7b80\u5355\u7c7b\u540d (-s)", required=false) Boolean simple, @ToolParam(description="\u6253\u5370\u65b9\u6cd5\u7b7e\u540d (-g)", required=false) Boolean sig, @ToolParam(description="\u6ce8\u89e3 Java \u65b9\u6cd5 (-a)", required=false) Boolean ann, @ToolParam(description="\u524d\u7f6e\u5e93\u540d (-l)", required=false) Boolean lib, @ToolParam(description="\u4ec5\u5305\u542b\u7528\u6237\u6001\u4e8b\u4ef6 (--all-user)", required=false) Boolean allUser, @ToolParam(description="\u89c4\u8303\u5316\u65b9\u6cd5\u540d\uff0c\u79fb\u9664 lambda \u7c7b\u7684\u6570\u5b57\u540e\u7f00 (--norm)", required=false) Boolean norm, @ToolParam(description="\u4ec5\u5305\u542b\u5339\u914d\u7684\u6808\u5e27\uff08\u53ef\u91cd\u590d\u591a\u6b21\uff09\uff0c\u7b49\u4ef7 --include 'java/*'\u3002\u4f20\u5165\u6570\u7ec4\u3002", required=false) String[] include, @ToolParam(description="\u6392\u9664\u5339\u914d\u7684\u6808\u5e27\uff08\u53ef\u91cd\u590d\u591a\u6b21\uff09\uff0c\u7b49\u4ef7 --exclude '*Unsafe.park*'\u3002\u4f20\u5165\u6570\u7ec4\u3002", required=false) String[] exclude, @ToolParam(description="\u5f53\u6307\u5b9a native \u51fd\u6570\u6267\u884c\u65f6\u81ea\u52a8\u5f00\u59cb\u91c7\u6837 (--begin)", required=false) String begin, @ToolParam(description="\u5f53\u6307\u5b9a native \u51fd\u6570\u6267\u884c\u65f6\u81ea\u52a8\u505c\u6b62\u91c7\u6837 (--end)", required=false) String end, @ToolParam(description="time-to-safepoint \u91c7\u6837\u522b\u540d\u5f00\u5173 (--ttsp)\uff0c\u7b49\u4ef7\u8bbe\u7f6e begin/end \u4e3a\u7279\u5b9a\u51fd\u6570", required=false) Boolean ttsp, @ToolParam(description="FlameGraph \u6807\u9898 (--title)", required=false) String title, @ToolParam(description="FlameGraph \u6700\u5c0f\u5e27\u5bbd\u767e\u5206\u6bd4 (--minwidth)", required=false) String minwidth, @ToolParam(description="\u751f\u6210\u53cd\u5411 FlameGraph/Call tree (--reverse)", required=false) Boolean reverse, @ToolParam(description="\u7edf\u8ba1\u603b\u91cf\u800c\u975e\u6837\u672c\u6570 (--total)", required=false) Boolean total, @ToolParam(description="JFR chunk \u5927\u5c0f (--chunksize)\uff0c\u9ed8\u8ba4 100MB \u6216\u5176\u5b83\u5355\u4f4d", required=false) String chunksize, @ToolParam(description="JFR chunk \u65f6\u95f4 (--chunktime)\uff0c\u9ed8\u8ba4 1h", required=false) String chunktime, @ToolParam(description="\u5faa\u73af\u91c7\u6837\u53c2\u6570 (--loop)\uff0c\u7528\u4e8e continuous profiling\uff0c\u5982 300s", required=false) String loop, @ToolParam(description="\u81ea\u52a8\u505c\u6b62\u65f6\u95f4 (--timeout)\uff0c\u7edd\u5bf9\u6216\u76f8\u5bf9\u65f6\u95f4\uff0c\u5982 300s", required=false) String timeout, @ToolParam(description="\u6301\u7eed\u91c7\u6837\u79d2\u6570 (--duration)\u3002\u6ce8\u610f\uff1a\u5230\u65f6\u81ea\u52a8 stop \u5728\u540e\u53f0\u6267\u884c\uff0cstop \u7684\u7ed3\u679c\u4e0d\u4f1a\u56de\u4f20\u5230\u5f53\u524d\u547d\u4ee4\u8f93\u51fa\u3002", required=false) Long duration, @ToolParam(description="\u542f\u7528\u7684\u7279\u6027\u96c6\u5408 (--features)", required=false) String features, @ToolParam(description="\u91c7\u6837\u4fe1\u53f7 (--signal)", required=false) String signal, @ToolParam(description="\u65f6\u95f4\u6233\u65f6\u949f\u6e90 (--clock)\uff0c\u53ef\u9009 monotonic \u6216 tsc", required=false) String clock, ToolContext toolContext) {
        String normalizedAction = ProfilerTool.normalizeAction(action);
        if ("execute".equals(normalizedAction) && (actionArg == null || actionArg.trim().isEmpty())) {
            throw new IllegalArgumentException("actionArg is required when action=execute");
        }
        StringBuilder cmd = this.buildCommand("profiler");
        cmd.append(" ").append(normalizedAction);
        if (actionArg != null && !actionArg.trim().isEmpty()) {
            this.addParameter(cmd, actionArg);
        }
        this.addOption(cmd, "--event", event);
        this.addOption(cmd, "--alloc", alloc);
        this.addFlag(cmd, "--live", live);
        this.addOption(cmd, "--lock", lock);
        this.addOption(cmd, "--jfrsync", jfrsync);
        this.addOption(cmd, "--file", file);
        this.addOption(cmd, "--format", format);
        this.addOption(cmd, "--interval", interval);
        this.addOption(cmd, "--jstackdepth", jstackdepth);
        this.addOption(cmd, "--wall", wall);
        this.addOption(cmd, "--features", features);
        this.addOption(cmd, "--signal", signal);
        this.addOption(cmd, "--clock", clock);
        this.addFlag(cmd, "--threads", threads);
        this.addFlag(cmd, "--sched", sched);
        this.addOption(cmd, "--cstack", cstack);
        this.addFlag(cmd, "-s", simple);
        this.addFlag(cmd, "-g", sig);
        this.addFlag(cmd, "-a", ann);
        this.addFlag(cmd, "-l", lib);
        this.addFlag(cmd, "--all-user", allUser);
        this.addFlag(cmd, "--norm", norm);
        this.addRepeatableOption(cmd, "--include", include);
        this.addRepeatableOption(cmd, "--exclude", exclude);
        this.addOption(cmd, "--begin", begin);
        this.addOption(cmd, "--end", end);
        this.addFlag(cmd, "--ttsp", ttsp);
        this.addOption(cmd, "--title", title);
        this.addOption(cmd, "--minwidth", minwidth);
        this.addFlag(cmd, "--reverse", reverse);
        this.addFlag(cmd, "--total", total);
        this.addOption(cmd, "--chunksize", chunksize);
        this.addOption(cmd, "--chunktime", chunktime);
        this.addOption(cmd, "--loop", loop);
        this.addOption(cmd, "--timeout", timeout);
        this.addOption(cmd, "--duration", duration);
        this.logger.info("Executing profiler command: {}", (Object)cmd);
        return this.executeSync(toolContext, cmd.toString());
    }

    private static String normalizeAction(String action) {
        if (action == null || action.trim().isEmpty()) {
            throw new IllegalArgumentException("action is required");
        }
        String input = action.trim();
        for (String supported : SUPPORTED_ACTIONS) {
            if (!supported.equalsIgnoreCase(input)) continue;
            return supported;
        }
        StringBuilder supportedList = new StringBuilder();
        for (int i = 0; i < SUPPORTED_ACTIONS.length; ++i) {
            if (i > 0) {
                supportedList.append(", ");
            }
            supportedList.append(SUPPORTED_ACTIONS[i]);
        }
        throw new IllegalArgumentException("Unsupported action: " + input + ". Supported actions: " + supportedList);
    }

    private void addOption(StringBuilder cmd, String option, String value) {
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        cmd.append(" ").append(option);
        this.addParameter(cmd, value);
    }

    private void addOption(StringBuilder cmd, String option, Long value) {
        if (value == null) {
            return;
        }
        cmd.append(" ").append(option).append(" ").append(value);
    }

    private void addOption(StringBuilder cmd, String option, Integer value) {
        if (value == null) {
            return;
        }
        cmd.append(" ").append(option).append(" ").append(value);
    }

    private void addRepeatableOption(StringBuilder cmd, String option, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        for (String value : values) {
            if (value == null || value.trim().isEmpty()) continue;
            cmd.append(" ").append(option);
            this.addParameter(cmd, value);
        }
    }
}

