/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function.jvm300;

import com.taobao.arthas.core.mcp.tool.function.AbstractArthasTool;
import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.tool.annotation.Tool;
import com.taobao.arthas.mcp.server.tool.annotation.ToolParam;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class HeapdumpTool
extends AbstractArthasTool {
    public static final String DEFAULT_DUMP_DIR = Paths.get("arthas-output", new String[0]).toAbsolutePath().toString().replace("\\", "/");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");

    @Tool(name="heapdump", description="Heapdump \u8bca\u65ad\u5de5\u5177: \u751f\u6210 JVM heap dump\uff0c\u652f\u6301 --live \u9009\u9879\u3002\u5bf9\u5e94 Arthas \u7684 heapdump \u547d\u4ee4\u3002")
    public String heapdump(@ToolParam(description="\u662f\u5426\u53ea dump \u5b58\u6d3b\u5bf9\u8c61 (--live)", required=false) Boolean live, @ToolParam(description="\u6307\u5b9a\u8f93\u51fa\u6587\u4ef6\u8def\u5f84\uff0c\u9ed8\u8ba4\u4e3a\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\u4e0b\u7684arthas-output\u6587\u4ef6\u5939\u4e2d\u7684\u65f6\u95f4\u6233\u547d\u540d\u7684.hprof\u6587\u4ef6", required=false) String filePath, ToolContext toolContext) throws IOException {
        String finalFilePath;
        if (filePath != null && !filePath.trim().isEmpty()) {
            finalFilePath = filePath.trim().replace("\\", "/");
        } else {
            Path defaultDir = Paths.get(DEFAULT_DUMP_DIR, new String[0]);
            if (!Files.exists(defaultDir, new LinkOption[0])) {
                Files.createDirectories(defaultDir, new FileAttribute[0]);
            }
            String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMATTER);
            String defaultFileName = String.format("heapdump_%s.hprof", timestamp);
            finalFilePath = Paths.get(DEFAULT_DUMP_DIR, defaultFileName).toString().replace("\\", "/");
        }
        StringBuilder cmd = this.buildCommand("heapdump");
        this.addFlag(cmd, "--live", live);
        cmd.append(" ").append(finalFilePath);
        return this.executeSync(toolContext, cmd.toString());
    }
}

