/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListenerAdapter;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.model.TimeFragmentVO;
import com.taobao.arthas.core.command.model.TimeTunnelModel;
import com.taobao.arthas.core.command.monitor200.TimeFragment;
import com.taobao.arthas.core.command.monitor200.TimeTunnelCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import java.time.LocalDateTime;
import java.util.Collections;

public class TimeTunnelAdviceListener
extends AdviceListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TimeTunnelAdviceListener.class);
    private static final int ARGS_STACK_SIZE = 512;
    private final ThreadLocal<Object[]> argsRef = ThreadLocal.withInitial(() -> {
        Object[] store = new Object[513];
        store[0] = new int[1];
        return store;
    });
    private TimeTunnelCommand command;
    private CommandProcess process;
    private volatile boolean isFirst = true;
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();

    public TimeTunnelAdviceListener(TimeTunnelCommand command, CommandProcess process, boolean verbose) {
        this.command = command;
        this.process = process;
        super.setVerbose(verbose);
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.pushArgs(args);
        this.threadLocalWatch.start();
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        args = this.popArgs();
        this.afterFinishing(Advice.newForAfterReturning(loader, clazz, method, target, args, returnObject));
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        args = this.popArgs();
        this.afterFinishing(Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable));
    }

    private void pushArgs(Object[] args) {
        int cap;
        Object[] store = this.argsRef.get();
        int[] posHolder = (int[])store[0];
        int pos = posHolder[0];
        pos = pos < (cap = store.length - 1) ? ++pos : 1;
        store[pos] = args;
        posHolder[0] = pos;
    }

    private Object[] popArgs() {
        Object[] store = this.argsRef.get();
        int[] posHolder = (int[])store[0];
        int cap = store.length - 1;
        int pos = posHolder[0];
        if (pos > 0) {
            Object[] args = (Object[])store[pos];
            store[pos] = null;
            posHolder[0] = pos - 1;
            return args;
        }
        pos = cap;
        Object[] args = (Object[])store[pos];
        store[pos] = null;
        posHolder[0] = pos - 1;
        return args;
    }

    private void afterFinishing(Advice advice) {
        double cost = this.threadLocalWatch.costInMillis();
        TimeFragment timeTunnel = new TimeFragment(advice, LocalDateTime.now(), cost);
        boolean match = false;
        try {
            match = this.isConditionMet(this.command.getConditionExpress(), advice, cost);
            if (this.isVerbose()) {
                this.process.write("Condition express: " + this.command.getConditionExpress() + " , result: " + match + "\n");
            }
        }
        catch (ExpressException e) {
            logger.warn("tt failed.", (Throwable)e);
            this.process.end(-1, "tt failed, condition is: " + this.command.getConditionExpress() + ", " + e.getMessage() + ", visit " + LogUtil.loggingFile() + " for more details.");
        }
        if (!match) {
            return;
        }
        int index = this.command.putTimeTunnel(timeTunnel);
        TimeFragmentVO timeFragmentVO = TimeTunnelCommand.createTimeFragmentVO(index, timeTunnel, this.command.getExpand());
        TimeTunnelModel timeTunnelModel = new TimeTunnelModel().setTimeFragmentList(Collections.singletonList(timeFragmentVO)).setFirst(this.isFirst);
        this.process.appendResult(timeTunnelModel);
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.process.times().incrementAndGet();
        if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
            this.abortProcess(this.process, this.command.getNumberOfLimit());
        }
    }
}

