/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http.api;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.taobao.arthas.common.PidUtils;
import com.taobao.arthas.core.command.model.CommandRequestModel;
import com.taobao.arthas.core.command.model.InputStatus;
import com.taobao.arthas.core.command.model.InputStatusModel;
import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.WelcomeModel;
import com.taobao.arthas.core.distribution.ResultConsumer;
import com.taobao.arthas.core.distribution.ResultDistributor;
import com.taobao.arthas.core.distribution.SharingResultDistributor;
import com.taobao.arthas.core.distribution.impl.PackingResultDistributorImpl;
import com.taobao.arthas.core.distribution.impl.ResultConsumerImpl;
import com.taobao.arthas.core.distribution.impl.SharingResultDistributorImpl;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.CliTokens;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.history.HistoryManager;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.session.SessionManager;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobController;
import com.taobao.arthas.core.shell.system.JobListener;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import com.taobao.arthas.core.shell.term.SignalHandler;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.impl.http.api.ApiAction;
import com.taobao.arthas.core.shell.term.impl.http.api.ApiException;
import com.taobao.arthas.core.shell.term.impl.http.api.ApiRequest;
import com.taobao.arthas.core.shell.term.impl.http.api.ApiResponse;
import com.taobao.arthas.core.shell.term.impl.http.api.ApiState;
import com.taobao.arthas.core.shell.term.impl.http.api.ObjectVOFilter;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSession;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSessionManager;
import com.taobao.arthas.core.util.ArthasBanner;
import com.taobao.arthas.core.util.DateUtils;
import com.taobao.arthas.core.util.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.termd.core.function.Function;
import java.util.List;
import java.util.TreeMap;

public class HttpApiHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiHandler.class);
    private static final ValueFilter[] JSON_FILTERS = new ValueFilter[]{new ObjectVOFilter()};
    private static final String ONETIME_SESSION_KEY = "oneTimeSession";
    public static final int DEFAULT_EXEC_TIMEOUT = 30000;
    private final SessionManager sessionManager;
    private final InternalCommandManager commandManager;
    private final JobController jobController;
    private final HistoryManager historyManager;

    public HttpApiHandler(HistoryManager historyManager, SessionManager sessionManager) {
        this.historyManager = historyManager;
        this.sessionManager = sessionManager;
        this.commandManager = this.sessionManager.getCommandManager();
        this.jobController = this.sessionManager.getJobController();
    }

    public HttpResponse handle(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        ApiResponse result;
        String requestBody = null;
        String requestId = null;
        try {
            HttpMethod method = request.method();
            if (HttpMethod.POST.equals((Object)method)) {
                requestBody = this.getBody(request);
                ApiRequest apiRequest = this.parseRequest(requestBody);
                requestId = apiRequest.getRequestId();
                result = this.processRequest(ctx, apiRequest);
            } else {
                result = this.createResponse(ApiState.REFUSED, "Unsupported http method: " + method.name());
            }
        }
        catch (Throwable e) {
            result = this.createResponse(ApiState.FAILED, "Process request error: " + e.getMessage());
            logger.error("arthas process http api request error: " + request.uri() + ", request body: " + requestBody, e);
        }
        if (result == null) {
            result = this.createResponse(ApiState.FAILED, "The request was not processed");
        }
        result.setRequestId(requestId);
        byte[] jsonBytes = JSON.toJSONBytes((Object)result, (Filter[])JSON_FILTERS);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])jsonBytes));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=utf-8");
        return response;
    }

    private ApiRequest parseRequest(String requestBody) throws ApiException {
        if (StringUtils.isBlank(requestBody)) {
            throw new ApiException("parse request failed: request body is empty");
        }
        try {
            return (ApiRequest)JSON.parseObject((String)requestBody, ApiRequest.class);
        }
        catch (Exception e) {
            throw new ApiException("parse request failed: " + e.getMessage(), e);
        }
    }

    private ApiResponse processRequest(ChannelHandlerContext ctx, ApiRequest apiRequest) {
        String actionStr = apiRequest.getAction();
        try {
            ApiResponse response;
            HttpSession httpSession;
            ApiAction action;
            if (StringUtils.isBlank(actionStr)) {
                throw new ApiException("'action' is required");
            }
            try {
                action = ApiAction.valueOf(actionStr.trim().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ApiException("unknown action: " + actionStr);
            }
            if (ApiAction.INIT_SESSION.equals((Object)action)) {
                return this.processInitSessionRequest(apiRequest);
            }
            Session session = null;
            boolean allowNullSession = ApiAction.EXEC.equals((Object)action);
            String sessionId = apiRequest.getSessionId();
            if (StringUtils.isBlank(sessionId)) {
                if (!allowNullSession) {
                    throw new ApiException("'sessionId' is required");
                }
            } else {
                session = this.sessionManager.getSession(sessionId);
                if (session == null) {
                    throw new ApiException("session not found: " + sessionId);
                }
                this.sessionManager.updateAccessTime(session);
            }
            if (session == null) {
                session = this.sessionManager.createSession();
                session.put(ONETIME_SESSION_KEY, new Object());
            }
            if ((httpSession = HttpSessionManager.getHttpSessionFromContext(ctx)) != null) {
                Object userId;
                Object subject = httpSession.getAttribute("subject");
                if (subject != null) {
                    session.put("subject", subject);
                }
                if ((userId = httpSession.getAttribute("userId")) != null && session.getUserId() == null) {
                    session.setUserId((String)userId);
                }
            }
            if (!StringUtils.isBlank(apiRequest.getUserId())) {
                session.setUserId(apiRequest.getUserId());
            }
            if ((response = this.dispatchRequest(action, apiRequest, session)) != null) {
                return response;
            }
        }
        catch (ApiException e) {
            logger.info("process http api request failed: {}", (Object)e.getMessage());
            return this.createResponse(ApiState.FAILED, e.getMessage());
        }
        catch (Throwable e) {
            logger.error("process http api request failed: " + e.getMessage(), e);
            return this.createResponse(ApiState.FAILED, "process http api request failed: " + e.getMessage());
        }
        return this.createResponse(ApiState.REFUSED, "Unsupported action: " + actionStr);
    }

    private ApiResponse dispatchRequest(ApiAction action, ApiRequest apiRequest, Session session) throws ApiException {
        switch (action) {
            case EXEC: {
                return this.processExecRequest(apiRequest, session);
            }
            case ASYNC_EXEC: {
                return this.processAsyncExecRequest(apiRequest, session);
            }
            case INTERRUPT_JOB: {
                return this.processInterruptJob(apiRequest, session);
            }
            case PULL_RESULTS: {
                return this.processPullResultsRequest(apiRequest, session);
            }
            case SESSION_INFO: {
                return this.processSessionInfoRequest(apiRequest, session);
            }
            case JOIN_SESSION: {
                return this.processJoinSessionRequest(apiRequest, session);
            }
            case CLOSE_SESSION: {
                return this.processCloseSessionRequest(apiRequest, session);
            }
        }
        return null;
    }

    private ApiResponse processInitSessionRequest(ApiRequest apiRequest) throws ApiException {
        ApiResponse response = new ApiResponse();
        Session session = this.sessionManager.createSession();
        if (session != null) {
            if (!StringUtils.isBlank(apiRequest.getUserId())) {
                session.setUserId(apiRequest.getUserId());
            }
        } else {
            throw new ApiException("create api session failed");
        }
        SharingResultDistributorImpl resultDistributor = new SharingResultDistributorImpl(session);
        ResultConsumerImpl resultConsumer = new ResultConsumerImpl();
        resultDistributor.addConsumer(resultConsumer);
        session.setResultDistributor(resultDistributor);
        resultDistributor.appendResult((ResultModel)new MessageModel("Welcome to arthas!"));
        WelcomeModel welcomeModel = new WelcomeModel();
        welcomeModel.setVersion(ArthasBanner.version());
        welcomeModel.setWiki(ArthasBanner.wiki());
        welcomeModel.setTutorials(ArthasBanner.tutorials());
        welcomeModel.setMainClass(PidUtils.mainClass());
        welcomeModel.setPid(PidUtils.currentPid());
        welcomeModel.setTime(DateUtils.getCurrentDateTime());
        resultDistributor.appendResult((ResultModel)welcomeModel);
        this.updateSessionInputStatus(session, InputStatus.ALLOW_INPUT);
        response.setSessionId(session.getSessionId()).setConsumerId(resultConsumer.getConsumerId()).setState(ApiState.SUCCEEDED);
        return response;
    }

    private void updateSessionInputStatus(Session session, InputStatus inputStatus) {
        SharingResultDistributor resultDistributor = session.getResultDistributor();
        if (resultDistributor != null) {
            resultDistributor.appendResult((ResultModel)new InputStatusModel(inputStatus));
        }
    }

    private ApiResponse processJoinSessionRequest(ApiRequest apiRequest, Session session) {
        ResultConsumerImpl resultConsumer = new ResultConsumerImpl();
        resultConsumer.appendResult((ResultModel)new InputStatusModel(InputStatus.DISABLED));
        SharingResultDistributor resultDistributor = session.getResultDistributor();
        if (resultDistributor != null) {
            resultDistributor.addConsumer(resultConsumer);
        }
        ApiResponse response = new ApiResponse();
        response.setSessionId(session.getSessionId()).setConsumerId(resultConsumer.getConsumerId()).setState(ApiState.SUCCEEDED);
        return response;
    }

    private ApiResponse processSessionInfoRequest(ApiRequest apiRequest, Session session) {
        ApiResponse response = new ApiResponse();
        TreeMap<String, Long> body = new TreeMap<String, Long>();
        body.put("pid", session.getPid());
        body.put("createTime", session.getCreateTime());
        body.put("lastAccessTime", session.getLastAccessTime());
        response.setState(ApiState.SUCCEEDED).setSessionId(session.getSessionId()).setBody(body);
        return response;
    }

    private ApiResponse processCloseSessionRequest(ApiRequest apiRequest, Session session) {
        this.sessionManager.removeSession(session.getSessionId());
        ApiResponse response = new ApiResponse();
        response.setState(ApiState.SUCCEEDED);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse processExecRequest(ApiRequest apiRequest, Session session) {
        boolean timeExpired;
        Integer timeout;
        Job job;
        PackingResultDistributorImpl packingResultDistributor;
        ApiResponse response;
        TreeMap<String, Object> body;
        boolean oneTimeAccess;
        block23: {
            int lock;
            String commandLine;
            block21: {
                oneTimeAccess = false;
                if (session.get(ONETIME_SESSION_KEY) != null) {
                    oneTimeAccess = true;
                }
                commandLine = apiRequest.getCommand();
                body = new TreeMap<String, Object>();
                body.put("command", commandLine);
                response = new ApiResponse();
                response.setSessionId(session.getSessionId()).setBody(body);
                if (!session.tryLock()) {
                    response.setState(ApiState.REFUSED).setMessage("Another command is executing.");
                    ApiResponse apiResponse = response;
                    return apiResponse;
                }
                lock = session.getLock();
                packingResultDistributor = null;
                job = null;
                Job foregroundJob = session.getForegroundJob();
                if (foregroundJob == null) break block21;
                response.setState(ApiState.REFUSED).setMessage("Another job is running.");
                logger.info("Another job is running, jobId: {}", (Object)foregroundJob.id());
                ApiResponse apiResponse = response;
                if (session.getLock() == lock) {
                    session.unLock();
                }
                return apiResponse;
            }
            try {
                packingResultDistributor = new PackingResultDistributorImpl(session);
                job = this.createJob(commandLine, session, (ResultDistributor)packingResultDistributor);
                session.setForegroundJob(job);
                this.updateSessionInputStatus(session, InputStatus.ALLOW_INTERRUPT);
                job.run();
                if (session.getLock() == lock) {
                    session.unLock();
                }
            }
            catch (Throwable e) {
                ApiResponse apiResponse;
                block22: {
                    try {
                        logger.error("Exec command failed:" + e.getMessage() + ", command:" + commandLine, e);
                        response.setState(ApiState.FAILED).setMessage("Exec command failed:" + e.getMessage());
                        apiResponse = response;
                        if (!oneTimeAccess) break block22;
                        this.sessionManager.removeSession(session.getSessionId());
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (session.getLock() == lock) {
                            session.unLock();
                        }
                    }
                }
                return apiResponse;
            }
            timeout = apiRequest.getExecTimeout();
            if (timeout != null && timeout > 0) break block23;
            timeout = 30000;
        }
        boolean bl = timeExpired = !this.waitForJob(job, timeout);
        if (timeExpired) {
            logger.warn("Job is exceeded time limit, force interrupt it, jobId: {}", (Object)job.id());
            job.interrupt();
            response.setState(ApiState.INTERRUPTED).setMessage("The job is exceeded time limit, force interrupt");
        } else {
            response.setState(ApiState.SUCCEEDED);
        }
        body.put("jobId", job.id());
        body.put("jobStatus", (Object)job.status());
        body.put("timeExpired", timeExpired);
        if (timeExpired) {
            body.put("timeout", timeout);
        }
        body.put("results", packingResultDistributor.getResults());
        response.setSessionId(session.getSessionId()).setBody(body);
        ApiResponse apiResponse = response;
        return apiResponse;
        finally {
            if (oneTimeAccess) {
                this.sessionManager.removeSession(session.getSessionId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse processAsyncExecRequest(ApiRequest apiRequest, Session session) {
        String commandLine = apiRequest.getCommand();
        TreeMap<String, Object> body = new TreeMap<String, Object>();
        body.put("command", commandLine);
        ApiResponse response = new ApiResponse();
        response.setSessionId(session.getSessionId()).setBody(body);
        if (!session.tryLock()) {
            response.setState(ApiState.REFUSED).setMessage("Another command is executing.");
            return response;
        }
        int lock = session.getLock();
        try {
            Job foregroundJob = session.getForegroundJob();
            if (foregroundJob != null) {
                response.setState(ApiState.REFUSED).setMessage("Another job is running.");
                logger.info("Another job is running, jobId: {}", (Object)foregroundJob.id());
                ApiResponse apiResponse = response;
                return apiResponse;
            }
            Job job = this.createJob(commandLine, session, (ResultDistributor)session.getResultDistributor());
            body.put("jobId", job.id());
            body.put("jobStatus", (Object)job.status());
            response.setState(ApiState.SCHEDULED);
            CommandRequestModel commandRequestModel = new CommandRequestModel(commandLine, response.getState().name());
            commandRequestModel.setJobId(job.id());
            SharingResultDistributor resultDistributor = session.getResultDistributor();
            if (resultDistributor != null) {
                resultDistributor.appendResult((ResultModel)commandRequestModel);
            }
            session.setForegroundJob(job);
            this.updateSessionInputStatus(session, InputStatus.ALLOW_INTERRUPT);
            job.run();
            ApiResponse apiResponse = response;
            return apiResponse;
        }
        catch (Throwable e) {
            logger.error("Async exec command failed:" + e.getMessage() + ", command:" + commandLine, e);
            response.setState(ApiState.FAILED).setMessage("Async exec command failed:" + e.getMessage());
            CommandRequestModel commandRequestModel = new CommandRequestModel(commandLine, response.getState().name(), response.getMessage());
            session.getResultDistributor().appendResult((ResultModel)commandRequestModel);
            ApiResponse apiResponse = response;
            return apiResponse;
        }
        finally {
            if (session.getLock() == lock) {
                session.unLock();
            }
        }
    }

    private ApiResponse processInterruptJob(ApiRequest apiRequest, Session session) {
        Job job = session.getForegroundJob();
        if (job == null) {
            return new ApiResponse().setState(ApiState.FAILED).setMessage("no foreground job is running");
        }
        job.interrupt();
        TreeMap<String, Object> body = new TreeMap<String, Object>();
        body.put("jobId", job.id());
        body.put("jobStatus", (Object)job.status());
        return new ApiResponse().setState(ApiState.SUCCEEDED).setBody(body);
    }

    private ApiResponse processPullResultsRequest(ApiRequest apiRequest, Session session) throws ApiException {
        String consumerId = apiRequest.getConsumerId();
        if (StringUtils.isBlank(consumerId)) {
            throw new ApiException("'consumerId' is required");
        }
        ResultConsumer consumer = null;
        SharingResultDistributor resultDistributor = session.getResultDistributor();
        if (resultDistributor != null) {
            consumer = resultDistributor.getConsumer(consumerId);
        }
        if (consumer == null) {
            throw new ApiException("consumer not found: " + consumerId);
        }
        List<ResultModel> results = consumer.pollResults();
        TreeMap<String, List<ResultModel>> body = new TreeMap<String, List<ResultModel>>();
        body.put("results", results);
        ApiResponse response = new ApiResponse();
        response.setState(ApiState.SUCCEEDED).setSessionId(session.getSessionId()).setConsumerId(consumerId).setBody(body);
        return response;
    }

    private boolean waitForJob(Job job, int timeout) {
        long startTime = System.currentTimeMillis();
        while (true) {
            switch (job.status()) {
                case STOPPED: 
                case TERMINATED: {
                    return true;
                }
            }
            if (System.currentTimeMillis() - startTime > (long)timeout) {
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized Job createJob(List<CliToken> args, Session session, ResultDistributor resultDistributor) {
        Job job = this.jobController.createJob(this.commandManager, args, session, new ApiJobHandler(session), new ApiTerm(session), resultDistributor);
        return job;
    }

    private Job createJob(String line, Session session, ResultDistributor resultDistributor) {
        this.historyManager.addHistory(line);
        return this.createJob(CliTokens.tokenize(line), session, resultDistributor);
    }

    private ApiResponse createResponse(ApiState apiState, String message) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setState(apiState);
        apiResponse.setMessage(message);
        return apiResponse;
    }

    private String getBody(FullHttpRequest request) {
        ByteBuf buf = request.content();
        return buf.toString(CharsetUtil.UTF_8);
    }

    private class ApiJobHandler
    implements JobListener {
        private Session session;

        public ApiJobHandler(Session session) {
            this.session = session;
        }

        @Override
        public void onForeground(Job job) {
            this.session.setForegroundJob(job);
        }

        @Override
        public void onBackground(Job job) {
            if (this.session.getForegroundJob() == job) {
                this.session.setForegroundJob(null);
                HttpApiHandler.this.updateSessionInputStatus(this.session, InputStatus.ALLOW_INPUT);
            }
        }

        @Override
        public void onTerminated(Job job) {
            if (this.session.getForegroundJob() == job) {
                this.session.setForegroundJob(null);
                HttpApiHandler.this.updateSessionInputStatus(this.session, InputStatus.ALLOW_INPUT);
            }
        }

        @Override
        public void onSuspend(Job job) {
            if (this.session.getForegroundJob() == job) {
                this.session.setForegroundJob(null);
                HttpApiHandler.this.updateSessionInputStatus(this.session, InputStatus.ALLOW_INPUT);
            }
        }
    }

    private static class ApiTerm
    implements Term {
        private Session session;

        public ApiTerm(Session session) {
            this.session = session;
        }

        @Override
        public Term resizehandler(Handler<Void> handler) {
            return this;
        }

        @Override
        public String type() {
            return "web";
        }

        @Override
        public int width() {
            return 1000;
        }

        @Override
        public int height() {
            return 200;
        }

        @Override
        public Term stdinHandler(Handler<String> handler) {
            return this;
        }

        @Override
        public Term stdoutHandler(Function<String, String> handler) {
            return this;
        }

        @Override
        public Term write(String data) {
            return this;
        }

        @Override
        public long lastAccessedTime() {
            return this.session.getLastAccessTime();
        }

        @Override
        public Term echo(String text) {
            return this;
        }

        @Override
        public Term setSession(Session session) {
            return this;
        }

        @Override
        public Term interruptHandler(SignalHandler handler) {
            return this;
        }

        @Override
        public Term suspendHandler(SignalHandler handler) {
            return this;
        }

        @Override
        public void readline(String prompt, Handler<String> lineHandler) {
        }

        @Override
        public void readline(String prompt, Handler<String> lineHandler, Handler<Completion> completionHandler) {
        }

        @Override
        public Term closeHandler(Handler<Void> handler) {
            return this;
        }

        @Override
        public void close() {
        }
    }
}

