/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.server;

import com.alibaba.arthas.deps.ch.qos.logback.classic.LoggerContext;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.arthas.tunnel.client.TunnelClient;
import com.alibaba.bytekit.asm.instrument.InstrumentConfig;
import com.alibaba.bytekit.asm.instrument.InstrumentParseResult;
import com.alibaba.bytekit.asm.instrument.InstrumentTransformer;
import com.alibaba.bytekit.asm.matcher.ClassMatcher;
import com.alibaba.bytekit.asm.matcher.SimpleClassMatcher;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.bytekit.utils.IOUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.PidUtils;
import com.taobao.arthas.common.SocketUtils;
import com.taobao.arthas.core.advisor.Enhancer;
import com.taobao.arthas.core.advisor.TransformerManager;
import com.taobao.arthas.core.command.BuiltinCommandPack;
import com.taobao.arthas.core.command.CommandExecutorImpl;
import com.taobao.arthas.core.command.view.ResultViewResolver;
import com.taobao.arthas.core.config.BinderUtils;
import com.taobao.arthas.core.config.Configure;
import com.taobao.arthas.core.config.FeatureCodec;
import com.taobao.arthas.core.env.ArthasEnvironment;
import com.taobao.arthas.core.env.MapPropertySource;
import com.taobao.arthas.core.env.PropertiesPropertySource;
import com.taobao.arthas.core.mcp.ArthasMcpBootstrap;
import com.taobao.arthas.core.security.SecurityAuthenticator;
import com.taobao.arthas.core.security.SecurityAuthenticatorImpl;
import com.taobao.arthas.core.server.instrument.ClassLoader_Instrument;
import com.taobao.arthas.core.shell.ShellServer;
import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.handlers.BindHandler;
import com.taobao.arthas.core.shell.history.HistoryManager;
import com.taobao.arthas.core.shell.history.impl.HistoryManagerImpl;
import com.taobao.arthas.core.shell.impl.ShellServerImpl;
import com.taobao.arthas.core.shell.session.SessionManager;
import com.taobao.arthas.core.shell.session.impl.SessionManagerImpl;
import com.taobao.arthas.core.shell.term.impl.HttpTermServer;
import com.taobao.arthas.core.shell.term.impl.http.api.HttpApiHandler;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSessionManager;
import com.taobao.arthas.core.shell.term.impl.httptelnet.HttpTelnetTermServer;
import com.taobao.arthas.core.util.ArthasBanner;
import com.taobao.arthas.core.util.FileUtils;
import com.taobao.arthas.core.util.IPUtils;
import com.taobao.arthas.core.util.InstrumentationUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.UserStatUtil;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.arthas.mcp.server.protocol.server.handler.McpHttpRequestHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.arthas.SpyAPI;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;

public class ArthasBootstrap {
    private static final String ARTHAS_SPY_JAR = "arthas-spy.jar";
    public static final String ARTHAS_HOME_PROPERTY = "arthas.home";
    private static String ARTHAS_HOME = null;
    public static final String CONFIG_NAME_PROPERTY = "arthas.config.name";
    public static final String CONFIG_LOCATION_PROPERTY = "arthas.config.location";
    public static final String CONFIG_OVERRIDE_ALL = "arthas.config.overrideAll";
    private static ArthasBootstrap arthasBootstrap;
    private ArthasEnvironment arthasEnvironment;
    private Configure configure;
    private AtomicBoolean isBindRef = new AtomicBoolean(false);
    private Instrumentation instrumentation;
    private InstrumentTransformer classLoaderInstrumentTransformer;
    private Thread shutdown;
    private ShellServer shellServer;
    private ScheduledExecutorService executorService;
    private SessionManager sessionManager;
    private TunnelClient tunnelClient;
    private File outputPath;
    private static LoggerContext loggerContext;
    private EventExecutorGroup workerGroup;
    private Timer timer = new Timer("arthas-timer", true);
    private TransformerManager transformerManager;
    private ResultViewResolver resultViewResolver;
    private HistoryManager historyManager;
    private HttpApiHandler httpApiHandler;
    private McpHttpRequestHandler mcpRequestHandler;
    private HttpSessionManager httpSessionManager;
    private SecurityAuthenticator securityAuthenticator;

    private ArthasBootstrap(Instrumentation instrumentation, Map<String, String> args) throws Throwable {
        this.instrumentation = instrumentation;
        this.initFastjson();
        this.initSpy();
        this.initArthasEnvironment(args);
        String outputPathStr = this.configure.getOutputPath();
        if (outputPathStr == null) {
            outputPathStr = "arthas-output";
        }
        this.outputPath = new File(outputPathStr);
        this.outputPath.mkdirs();
        loggerContext = LogUtil.initLogger(this.arthasEnvironment);
        this.enhanceClassLoader();
        this.initBeans();
        this.bind(this.configure);
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "arthas-command-execute");
                t.setDaemon(true);
                return t;
            }
        });
        this.shutdown = new Thread("as-shutdown-hooker"){

            @Override
            public void run() {
                ArthasBootstrap.this.destroy();
            }
        };
        this.transformerManager = new TransformerManager(instrumentation);
        Runtime.getRuntime().addShutdownHook(this.shutdown);
    }

    private void initFastjson() {
        JSON.config((JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreErrorGetter, JSONWriter.Feature.WriteNonStringKeyAsString});
    }

    private void initBeans() {
        this.resultViewResolver = new ResultViewResolver();
        this.historyManager = new HistoryManagerImpl();
    }

    private void initSpy() throws Throwable {
        ClassLoader parent = ClassLoader.getSystemClassLoader().getParent();
        Class<?> spyClass = null;
        if (parent != null) {
            try {
                spyClass = parent.loadClass("java.arthas.SpyAPI");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (spyClass == null) {
            CodeSource codeSource = ArthasBootstrap.class.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                File arthasCoreJarFile = new File(codeSource.getLocation().toURI().getSchemeSpecificPart());
                File spyJarFile = new File(arthasCoreJarFile.getParentFile(), ARTHAS_SPY_JAR);
                this.instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(spyJarFile));
            } else {
                throw new IllegalStateException("can not find arthas-spy.jar");
            }
        }
    }

    void enhanceClassLoader() throws IOException, UnmodifiableClassException {
        if (this.configure.getEnhanceLoaders() == null) {
            return;
        }
        HashSet<String> loaders = new HashSet<String>();
        for (String s : this.configure.getEnhanceLoaders().split(",")) {
            loaders.add(s.trim());
        }
        byte[] classBytes = IOUtils.getBytes((InputStream)ArthasBootstrap.class.getClassLoader().getResourceAsStream(ClassLoader_Instrument.class.getName().replace('.', '/') + ".class"));
        SimpleClassMatcher matcher = new SimpleClassMatcher(loaders);
        InstrumentConfig instrumentConfig = new InstrumentConfig(AsmUtils.toClassNode((byte[])classBytes), (ClassMatcher)matcher);
        InstrumentParseResult instrumentParseResult = new InstrumentParseResult();
        instrumentParseResult.addInstrumentConfig(instrumentConfig);
        this.classLoaderInstrumentTransformer = new InstrumentTransformer(instrumentParseResult);
        this.instrumentation.addTransformer((ClassFileTransformer)this.classLoaderInstrumentTransformer, true);
        if (loaders.size() == 1 && loaders.contains(ClassLoader.class.getName())) {
            this.instrumentation.retransformClasses(ClassLoader.class);
        } else {
            InstrumentationUtils.trigerRetransformClasses(this.instrumentation, loaders);
        }
    }

    private void initArthasEnvironment(Map<String, String> argsMap) throws IOException {
        HashMap<String, Object> copyMap;
        if (this.arthasEnvironment == null) {
            this.arthasEnvironment = new ArthasEnvironment();
        }
        if (argsMap != null) {
            copyMap = new HashMap<String, String>(argsMap);
            if (!copyMap.containsKey(ARTHAS_HOME_PROPERTY)) {
                copyMap.put(ARTHAS_HOME_PROPERTY, ArthasBootstrap.arthasHome());
            }
        } else {
            copyMap = new HashMap(1);
            copyMap.put(ARTHAS_HOME_PROPERTY, ArthasBootstrap.arthasHome());
        }
        MapPropertySource mapPropertySource = new MapPropertySource("args", (Map<String, Object>)copyMap);
        this.arthasEnvironment.addFirst(mapPropertySource);
        this.tryToLoadArthasProperties();
        this.configure = new Configure();
        BinderUtils.inject(this.arthasEnvironment, this.configure);
    }

    private static String arthasHome() {
        if (ARTHAS_HOME != null) {
            return ARTHAS_HOME;
        }
        CodeSource codeSource = ArthasBootstrap.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            try {
                ARTHAS_HOME = new File(codeSource.getLocation().toURI().getSchemeSpecificPart()).getParentFile().getAbsolutePath();
            }
            catch (Throwable e) {
                AnsiLog.error((String)"try to find arthas.home from CodeSource error", (Object[])new Object[]{e});
            }
        }
        if (ARTHAS_HOME == null) {
            ARTHAS_HOME = new File("").getAbsolutePath();
        }
        return ARTHAS_HOME;
    }

    static String reslove(ArthasEnvironment arthasEnvironment, String key, String defaultValue) {
        String value = arthasEnvironment.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return arthasEnvironment.resolvePlaceholders(value);
    }

    private void tryToLoadArthasProperties() throws IOException {
        this.arthasEnvironment.resolvePlaceholders(CONFIG_LOCATION_PROPERTY);
        String location = ArthasBootstrap.reslove(this.arthasEnvironment, CONFIG_LOCATION_PROPERTY, null);
        if (location == null) {
            location = ArthasBootstrap.arthasHome();
        }
        String configName = ArthasBootstrap.reslove(this.arthasEnvironment, CONFIG_NAME_PROPERTY, "arthas");
        if (location != null) {
            if (!location.endsWith(".properties")) {
                location = new File(location, configName + ".properties").getAbsolutePath();
            }
            if (new File(location).exists()) {
                Properties properties = FileUtils.readProperties(location);
                boolean overrideAll = false;
                overrideAll = this.arthasEnvironment.containsProperty(CONFIG_OVERRIDE_ALL) ? this.arthasEnvironment.getRequiredProperty(CONFIG_OVERRIDE_ALL, Boolean.TYPE) : Boolean.parseBoolean(properties.getProperty(CONFIG_OVERRIDE_ALL, "false"));
                PropertiesPropertySource propertySource = new PropertiesPropertySource(location, properties);
                if (overrideAll) {
                    this.arthasEnvironment.addFirst(propertySource);
                } else {
                    this.arthasEnvironment.addLast(propertySource);
                }
            }
        }
    }

    private void bind(Configure configure) throws Throwable {
        long start = System.currentTimeMillis();
        if (!this.isBindRef.compareAndSet(false, true)) {
            throw new IllegalStateException("already bind");
        }
        if (configure.getTelnetPort() != null && configure.getTelnetPort() == 0) {
            int newTelnetPort = SocketUtils.findAvailableTcpPort();
            configure.setTelnetPort(newTelnetPort);
            this.logger().info("generate random telnet port: " + newTelnetPort);
        }
        if (configure.getHttpPort() != null && configure.getHttpPort() == 0) {
            int newHttpPort = SocketUtils.findAvailableTcpPort();
            configure.setHttpPort(newHttpPort);
            this.logger().info("generate random http port: " + newHttpPort);
        }
        if (configure.getAppName() == null) {
            configure.setAppName(System.getProperty("project.name", System.getProperty("spring.application.name", null)));
        }
        try {
            if (configure.getTunnelServer() != null) {
                this.tunnelClient = new TunnelClient();
                this.tunnelClient.setAppName(configure.getAppName());
                this.tunnelClient.setId(configure.getAgentId());
                this.tunnelClient.setTunnelServerUrl(configure.getTunnelServer());
                this.tunnelClient.setVersion(ArthasBanner.version());
                ChannelFuture channelFuture = this.tunnelClient.start();
                channelFuture.await(10L, TimeUnit.SECONDS);
            }
        }
        catch (Throwable t) {
            this.logger().error("start tunnel client error", t);
        }
        try {
            String[] strings;
            ShellServerOptions options = new ShellServerOptions().setInstrumentation(this.instrumentation).setPid(PidUtils.currentLongPid()).setWelcomeMessage(ArthasBanner.welcome());
            if (configure.getSessionTimeout() != null) {
                options.setSessionTimeout(configure.getSessionTimeout() * 1000L);
            }
            this.httpSessionManager = new HttpSessionManager();
            if (IPUtils.isAllZeroIP(configure.getIp()) && StringUtils.isBlank(configure.getPassword())) {
                String errorMsg = "Listening on 0.0.0.0 is very dangerous! External users can connect to your machine! No password is currently configured. Therefore, a default password is generated, and clients need to use the password to connect!";
                AnsiLog.error((String)errorMsg);
                configure.setPassword(StringUtils.randomString(64));
                AnsiLog.error((String)("Generated arthas password: " + configure.getPassword()));
                this.logger().error(errorMsg);
                this.logger().info("Generated arthas password: " + configure.getPassword());
            }
            this.securityAuthenticator = new SecurityAuthenticatorImpl(configure.getUsername(), configure.getPassword());
            this.shellServer = new ShellServerImpl(options);
            ArrayList<String> disabledCommands = new ArrayList<String>();
            if (configure.getDisabledCommands() != null && (strings = StringUtils.tokenizeToStringArray(configure.getDisabledCommands(), ",")) != null) {
                disabledCommands.addAll(Arrays.asList(strings));
            }
            BuiltinCommandPack builtinCommands = new BuiltinCommandPack(disabledCommands);
            ArrayList<BuiltinCommandPack> resolvers = new ArrayList<BuiltinCommandPack>();
            resolvers.add(builtinCommands);
            this.workerGroup = new NioEventLoopGroup((ThreadFactory)new DefaultThreadFactory("arthas-TermServer", true));
            if (configure.getTelnetPort() != null && configure.getTelnetPort() > 0) {
                this.logger().info("try to bind telnet server, host: {}, port: {}.", (Object)configure.getIp(), (Object)configure.getTelnetPort());
                this.shellServer.registerTermServer(new HttpTelnetTermServer(configure.getIp(), configure.getTelnetPort(), options.getConnectionTimeout(), this.workerGroup, this.httpSessionManager));
            } else {
                this.logger().info("telnet port is {}, skip bind telnet server.", (Object)configure.getTelnetPort());
            }
            if (configure.getHttpPort() != null && configure.getHttpPort() > 0) {
                this.logger().info("try to bind http server, host: {}, port: {}.", (Object)configure.getIp(), (Object)configure.getHttpPort());
                this.shellServer.registerTermServer(new HttpTermServer(configure.getIp(), configure.getHttpPort(), options.getConnectionTimeout(), this.workerGroup, this.httpSessionManager));
            } else {
                if (configure.getTunnelServer() != null) {
                    this.shellServer.registerTermServer(new HttpTermServer(configure.getIp(), configure.getHttpPort(), options.getConnectionTimeout(), this.workerGroup, this.httpSessionManager));
                }
                this.logger().info("http port is {}, skip bind http server.", (Object)configure.getHttpPort());
            }
            for (CommandResolver commandResolver : resolvers) {
                this.shellServer.registerCommandResolver(commandResolver);
            }
            this.shellServer.listen(new BindHandler(this.isBindRef));
            if (!this.isBind()) {
                throw new IllegalStateException("Arthas failed to bind telnet or http port! Telnet port: " + String.valueOf(configure.getTelnetPort()) + ", http port: " + String.valueOf(configure.getHttpPort()));
            }
            this.sessionManager = new SessionManagerImpl(options, this.shellServer.getCommandManager(), this.shellServer.getJobController());
            this.httpApiHandler = new HttpApiHandler(this.historyManager, this.sessionManager);
            String mcpEndpoint = configure.getMcpEndpoint();
            String string = configure.getMcpProtocol();
            if (mcpEndpoint != null && !mcpEndpoint.trim().isEmpty()) {
                this.logger().info("try to start mcp server, endpoint: {}, protocol: {}.", (Object)mcpEndpoint, (Object)string);
                CommandExecutorImpl commandExecutor = new CommandExecutorImpl(this.sessionManager);
                ArthasMcpBootstrap arthasMcpBootstrap = new ArthasMcpBootstrap(commandExecutor, mcpEndpoint, string);
                this.mcpRequestHandler = arthasMcpBootstrap.start().getMcpRequestHandler();
            }
            this.logger().info("as-server listening on network={};telnet={};http={};timeout={};mcp={};mcpProtocol={};", new Object[]{configure.getIp(), configure.getTelnetPort(), configure.getHttpPort(), options.getConnectionTimeout(), configure.getMcpEndpoint(), configure.getMcpProtocol()});
            if (configure.getStatUrl() != null) {
                this.logger().info("arthas stat url: {}", (Object)configure.getStatUrl());
            }
            UserStatUtil.setStatUrl(configure.getStatUrl());
            UserStatUtil.setAgentId(configure.getAgentId());
            UserStatUtil.arthasStart();
            try {
                SpyAPI.init();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.logger().info("as-server started in {} ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Throwable e) {
            this.logger().error("Error during start as-server", e);
            this.destroy();
            throw e;
        }
    }

    private void shutdownWorkGroup() {
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully(200L, 200L, TimeUnit.MILLISECONDS);
            this.workerGroup = null;
        }
    }

    public boolean isBind() {
        return this.isBindRef.get();
    }

    public EnhancerAffect reset() throws UnmodifiableClassException {
        return Enhancer.reset(this.instrumentation, new WildcardMatcher("*"));
    }

    public void destroy() {
        if (this.shellServer != null) {
            this.shellServer.close();
            this.shellServer = null;
        }
        if (this.sessionManager != null) {
            this.sessionManager.close();
            this.sessionManager = null;
        }
        if (this.httpSessionManager != null) {
            this.httpSessionManager.stop();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.tunnelClient != null) {
            try {
                this.tunnelClient.stop();
            }
            catch (Throwable e) {
                this.logger().error("stop tunnel client error", e);
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        if (this.transformerManager != null) {
            this.transformerManager.destroy();
        }
        if (this.classLoaderInstrumentTransformer != null) {
            this.instrumentation.removeTransformer((ClassFileTransformer)this.classLoaderInstrumentTransformer);
        }
        this.cleanUpSpyReference();
        this.shutdownWorkGroup();
        UserStatUtil.destroy();
        if (this.shutdown != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdown);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.logger().info("as-server destroy completed.");
        if (loggerContext != null) {
            loggerContext.stop();
        }
    }

    public static synchronized ArthasBootstrap getInstance(Instrumentation instrumentation, String args) throws Throwable {
        if (arthasBootstrap != null) {
            return arthasBootstrap;
        }
        Map<String, String> argsMap = FeatureCodec.DEFAULT_COMMANDLINE_CODEC.toMap(args);
        HashMap<String, String> mapWithPrefix = new HashMap<String, String>(argsMap.size());
        for (Map.Entry<String, String> entry : argsMap.entrySet()) {
            mapWithPrefix.put("arthas." + entry.getKey(), entry.getValue());
        }
        return ArthasBootstrap.getInstance(instrumentation, mapWithPrefix);
    }

    public static synchronized ArthasBootstrap getInstance(Instrumentation instrumentation, Map<String, String> args) throws Throwable {
        if (arthasBootstrap == null) {
            arthasBootstrap = new ArthasBootstrap(instrumentation, args);
        }
        return arthasBootstrap;
    }

    public static ArthasBootstrap getInstance() {
        if (arthasBootstrap == null) {
            throw new IllegalStateException("ArthasBootstrap must be initialized before!");
        }
        return arthasBootstrap;
    }

    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    private void cleanUpSpyReference() {
        try {
            SpyAPI.setNopSpy();
            SpyAPI.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("com.taobao.arthas.agent334.AgentBootstrap");
            Method method = clazz.getDeclaredMethod("resetArthasClassLoader", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TunnelClient getTunnelClient() {
        return this.tunnelClient;
    }

    public ShellServer getShellServer() {
        return this.shellServer;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executorService;
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public TransformerManager getTransformerManager() {
        return this.transformerManager;
    }

    private Logger logger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public ResultViewResolver getResultViewResolver() {
        return this.resultViewResolver;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public HttpApiHandler getHttpApiHandler() {
        return this.httpApiHandler;
    }

    public McpHttpRequestHandler getMcpRequestHandler() {
        return this.mcpRequestHandler;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    public SecurityAuthenticator getSecurityAuthenticator() {
        return this.securityAuthenticator;
    }

    public Configure getConfigure() {
        return this.configure;
    }
}

