/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.command.model.ObjectVO;
import com.taobao.arthas.core.view.ObjectView;
import com.taobao.arthas.mcp.server.util.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpObjectVOFilter
implements ValueFilter {
    private static final Logger logger = LoggerFactory.getLogger(McpObjectVOFilter.class);
    private static final McpObjectVOFilter INSTANCE = new McpObjectVOFilter();
    private static volatile boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void register() {
        if (registered) return;
        Class<McpObjectVOFilter> clazz = McpObjectVOFilter.class;
        synchronized (McpObjectVOFilter.class) {
            if (registered) return;
            JsonParser.registerFilter((ValueFilter)INSTANCE);
            registered = true;
            logger.debug("McpObjectVOFilter registered to JsonParser");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public Object apply(Object object, String name, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ObjectVO) {
            return this.handleObjectVO((ObjectVO)value);
        }
        return value;
    }

    private Object handleObjectVO(ObjectVO objectVO) {
        try {
            Object innerObject = objectVO.getObject();
            Integer expand = objectVO.getExpand();
            if (innerObject == null) {
                return "null";
            }
            if (objectVO.needExpand()) {
                if (GlobalOptions.isUsingJson) {
                    return this.drawJsonView(innerObject);
                }
                return this.drawObjectView(objectVO);
            }
            return this.objectToString(innerObject);
        }
        catch (Exception e) {
            logger.warn("Failed to handle ObjectVO: {}", (Object)e.getMessage());
            return "{\"error\":\"ObjectVO serialization failed\"}";
        }
    }

    private String drawObjectView(ObjectVO objectVO) {
        try {
            ObjectView objectView = new ObjectView(objectVO);
            return objectView.draw();
        }
        catch (Exception e) {
            logger.debug("ObjectView serialization failed, using toString: {}", (Object)e.getMessage());
            return this.objectToString(objectVO.getObject());
        }
    }

    private String drawJsonView(Object object) {
        try {
            JSONWriter.Context context = JSONFactory.createWriteContext();
            context.setMaxLevel(4097);
            context.config(JSONWriter.Feature.IgnoreErrorGetter, true);
            context.config(JSONWriter.Feature.ReferenceDetection, true);
            context.config(JSONWriter.Feature.IgnoreNonFieldGetter, true);
            context.config(JSONWriter.Feature.WriteNonStringKeyAsString, true);
            return JSON.toJSONString((Object)object, (JSONWriter.Context)context);
        }
        catch (Exception e) {
            logger.debug("ObjectView-style serialization failed, using toString: {}", (Object)e.getMessage());
            return this.objectToString(object);
        }
    }

    private String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            return object.toString();
        }
        catch (Exception e) {
            return object.getClass().getSimpleName() + "@" + Integer.toHexString(object.hashCode());
        }
    }
}

