/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.mcp.tool.function;

import com.taobao.arthas.core.mcp.tool.function.StreamableToolUtils;
import com.taobao.arthas.mcp.server.protocol.server.McpNettyServerExchange;
import com.taobao.arthas.mcp.server.protocol.server.McpTransportContext;
import com.taobao.arthas.mcp.server.session.ArthasCommandContext;
import com.taobao.arthas.mcp.server.tool.ToolContext;
import com.taobao.arthas.mcp.server.util.JsonParser;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArthasTool {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_TIMEOUT_SECONDS = 30;

    protected String executeSync(ToolContext toolContext, String commandStr) {
        try {
            ToolExecutionContext execContext = new ToolExecutionContext(toolContext, false);
            Map result = execContext.getCommandContext().executeSync(commandStr, execContext.getAuthSubject(), execContext.getUserId());
            return JsonParser.toJson((Object)result);
        }
        catch (Exception e) {
            this.logger.error("Error executing sync command: {}", (Object)commandStr, (Object)e);
            return JsonParser.toJson(StreamableToolUtils.createErrorResponse("Error executing command: " + e.getMessage()));
        }
    }

    protected String executeStreamable(ToolContext toolContext, String commandStr, Integer expectedResultCount, Integer pollIntervalMs, Integer timeoutMs, String successMessage) {
        try {
            ToolExecutionContext execContext = new ToolExecutionContext(toolContext, true);
            this.logger.info("Starting streamable execution: {}", (Object)commandStr);
            if (execContext.getUserId() != null) {
                execContext.getCommandContext().setSessionUserId(execContext.getUserId());
            }
            Map asyncResult = execContext.getCommandContext().executeAsync(commandStr);
            this.logger.debug("Async execution started: {}", (Object)asyncResult);
            Map<String, Object> results = StreamableToolUtils.executeAndCollectResults(execContext.getExchange(), execContext.getCommandContext(), expectedResultCount, pollIntervalMs, timeoutMs, execContext.getProgressToken());
            if (results != null) {
                String message;
                String string = message = successMessage != null ? successMessage : "Command execution completed successfully";
                if (Boolean.TRUE.equals(results.get("timedOut"))) {
                    Integer count = (Integer)results.get("resultCount");
                    message = count != null && count > 0 ? "Command execution ended (Timed out). Captured " + count + " results." : "Command execution ended (Timed out). No results captured within the time limit.";
                }
                return JsonParser.toJson(StreamableToolUtils.createCompletedResponse(message, results));
            }
            return JsonParser.toJson(StreamableToolUtils.createErrorResponse("Command execution failed due to timeout or error limits exceeded"));
        }
        catch (Exception e) {
            this.logger.error("Error executing streamable command: {}", (Object)commandStr, (Object)e);
            return JsonParser.toJson(StreamableToolUtils.createErrorResponse("Error executing command: " + e.getMessage()));
        }
    }

    protected StringBuilder buildCommand(String baseCommand) {
        return new StringBuilder(baseCommand);
    }

    protected void addParameter(StringBuilder cmd, String flag, String value) {
        if (value != null && !value.trim().isEmpty()) {
            cmd.append(" ").append(flag).append(" ").append(value.trim());
        }
    }

    protected void addParameter(StringBuilder cmd, String value) {
        if (value != null && !value.trim().isEmpty()) {
            cmd.append(" '").append(value.trim().replace("'", "'\\''")).append("'");
        }
    }

    protected void addFlag(StringBuilder cmd, String flag, Boolean condition) {
        if (Boolean.TRUE.equals(condition)) {
            cmd.append(" ").append(flag);
        }
    }

    protected void addQuotedParameter(StringBuilder cmd, String value) {
        if (value != null && !value.trim().isEmpty()) {
            cmd.append(" '").append(value.trim()).append("'");
        }
    }

    protected int getDefaultValue(Integer value, int defaultValue) {
        return value != null && value > 0 ? value : defaultValue;
    }

    protected String getDefaultValue(String value, String defaultValue) {
        return value != null && !value.trim().isEmpty() ? value.trim() : defaultValue;
    }

    protected static class ToolExecutionContext {
        private final ArthasCommandContext commandContext;
        private final McpTransportContext mcpTransportContext;
        private final Object authSubject;
        private final String userId;
        private final McpNettyServerExchange exchange;
        private final String progressToken;
        private final boolean isStreamable;

        public ToolExecutionContext(ToolContext toolContext, boolean isStreamable) {
            this.commandContext = (ArthasCommandContext)toolContext.getContext().get("commandContext");
            this.isStreamable = isStreamable;
            this.exchange = (McpNettyServerExchange)toolContext.getContext().get("exchange");
            Object progressTokenObj = toolContext.getContext().get("progressToken");
            this.progressToken = progressTokenObj != null ? String.valueOf(progressTokenObj) : null;
            this.mcpTransportContext = (McpTransportContext)toolContext.getContext().get("mcpTransportContext");
            if (this.mcpTransportContext != null) {
                this.authSubject = this.mcpTransportContext.get("mcp.auth.subject");
                this.userId = (String)this.mcpTransportContext.get("mcp.user.id");
            } else {
                this.authSubject = null;
                this.userId = null;
            }
        }

        public ArthasCommandContext getCommandContext() {
            return this.commandContext;
        }

        public McpTransportContext getMcpTransportContext() {
            return this.mcpTransportContext;
        }

        public Object getAuthSubject() {
            return this.authSubject;
        }

        public String getUserId() {
            return this.userId;
        }

        public McpNettyServerExchange getExchange() {
            return this.exchange;
        }

        public String getProgressToken() {
            return this.progressToken;
        }

        public boolean isStreamable() {
            return this.isStreamable;
        }
    }
}

