/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.MethodNode;
import com.taobao.arthas.core.command.model.ThreadNode;
import com.taobao.arthas.core.command.model.ThrowNode;
import com.taobao.arthas.core.command.model.TraceModel;
import com.taobao.arthas.core.command.model.TraceNode;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.DateUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.view.Ansi;
import java.util.List;

public class TraceView
extends ResultView<TraceModel> {
    private static final String STEP_FIRST_CHAR = "`---";
    private static final String STEP_NORMAL_CHAR = "+---";
    private static final String STEP_HAS_BOARD = "|   ";
    private static final String STEP_EMPTY_BOARD = "    ";
    private static final String TIME_UNIT = "ms";
    private static final char PERCENTAGE = '%';
    private boolean isPrintCost = true;
    private MethodNode maxCostNode;

    @Override
    public void draw(CommandProcess process, TraceModel result) {
        process.write(this.drawTree(result.getRoot())).write("\n");
    }

    public String drawTree(TraceNode root) {
        this.maxCostNode = null;
        this.findMaxCostNode(root);
        final StringBuilder treeSB = new StringBuilder(2048);
        final Ansi highlighted = Ansi.ansi().fg(Ansi.Color.RED);
        this.recursive(0, true, "", root, new Callback(){
            final /* synthetic */ TraceView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void callback(int deep, boolean isLast, String prefix, TraceNode node) {
                treeSB.append(prefix).append(isLast ? TraceView.STEP_FIRST_CHAR : TraceView.STEP_NORMAL_CHAR);
                this.this$0.renderNode(treeSB, node, highlighted);
                if (!StringUtils.isBlank(node.getMark())) {
                    treeSB.append(" [").append(node.getMark()).append(node.marks() > 1 ? "," + node.marks() : "").append("]");
                }
                treeSB.append("\n");
            }
        });
        return treeSB.toString();
    }

    private void renderNode(StringBuilder sb, TraceNode node, Ansi highlighted) {
        MethodNode methodNode;
        if (this.isPrintCost && node instanceof MethodNode) {
            methodNode = (MethodNode)node;
            String costStr = this.renderCost(methodNode);
            if (node == this.maxCostNode) {
                sb.append(highlighted.a(costStr).reset().toString());
            } else {
                sb.append(costStr);
            }
        }
        if (node instanceof MethodNode) {
            methodNode = (MethodNode)node;
            sb.append(methodNode.getClassName()).append(":").append(methodNode.getMethodName()).append("()");
            if (methodNode.getLineNumber() != -1) {
                sb.append(" #").append(methodNode.getLineNumber());
            }
        } else if (node instanceof ThreadNode) {
            ThreadNode threadNode = (ThreadNode)node;
            sb.append(String.format("ts=%s;thread_name=%s;id=%d;is_daemon=%s;priority=%d;TCCL=%s", DateUtils.formatDateTime(threadNode.getTimestamp()), threadNode.getThreadName(), threadNode.getThreadId(), threadNode.isDaemon(), threadNode.getPriority(), threadNode.getClassloader()));
            if (threadNode.getTraceId() != null) {
                sb.append(";trace_id=").append(threadNode.getTraceId());
            }
            if (threadNode.getRpcId() != null) {
                sb.append(";rpc_id=").append(threadNode.getRpcId());
            }
        } else if (node instanceof ThrowNode) {
            ThrowNode throwNode = (ThrowNode)node;
            sb.append("throw:").append(throwNode.getException()).append(" #").append(throwNode.getLineNumber()).append(" [").append(throwNode.getMessage()).append("]");
        } else {
            throw new UnsupportedOperationException("unknown trace node: " + node.getClass());
        }
    }

    private String renderCost(MethodNode node) {
        StringBuilder sb = new StringBuilder();
        if (node.getTimes() <= 1L) {
            if (node.parent() instanceof ThreadNode) {
                sb.append('[').append(this.nanoToMillis(node.getCost())).append(TIME_UNIT).append("] ");
            } else {
                MethodNode parentNode = (MethodNode)node.parent();
                String percentage = String.format("%.2f", (double)node.getCost() * 100.0 / (double)parentNode.getTotalCost());
                sb.append('[').append(percentage).append('%').append(" ").append(this.nanoToMillis(node.getCost())).append(TIME_UNIT).append(" ").append("] ");
            }
        } else if (node.parent() instanceof ThreadNode) {
            sb.append("[min=").append(this.nanoToMillis(node.getMinCost())).append(TIME_UNIT).append(",max=").append(this.nanoToMillis(node.getMaxCost())).append(TIME_UNIT).append(",total=").append(this.nanoToMillis(node.getTotalCost())).append(TIME_UNIT).append(",count=").append(node.getTimes()).append("] ");
        } else {
            MethodNode parentNode = (MethodNode)node.parent();
            String percentage = String.format("%.2f", (double)node.getTotalCost() * 100.0 / (double)parentNode.getTotalCost());
            sb.append('[').append(percentage).append('%').append(" min=").append(this.nanoToMillis(node.getMinCost())).append(TIME_UNIT).append(",max=").append(this.nanoToMillis(node.getMaxCost())).append(TIME_UNIT).append(",total=").append(this.nanoToMillis(node.getTotalCost())).append(TIME_UNIT).append(",count=").append(node.getTimes()).append("] ");
        }
        return sb.toString();
    }

    private void recursive(int deep, boolean isLast, String prefix, TraceNode node, Callback callback) {
        callback.callback(deep, isLast, prefix, node);
        if (!this.isLeaf(node)) {
            List<TraceNode> children = node.getChildren();
            if (children == null) {
                return;
            }
            int size = children.size();
            for (int index = 0; index < size; ++index) {
                boolean isLastFlag = index == size - 1;
                String currentPrefix = isLast ? prefix + STEP_EMPTY_BOARD : prefix + STEP_HAS_BOARD;
                this.recursive(deep + 1, isLastFlag, currentPrefix, children.get(index), callback);
            }
        }
    }

    private void findMaxCostNode(TraceNode node) {
        List<TraceNode> children;
        if (node instanceof MethodNode && !this.isRoot(node) && !this.isRoot(node.parent())) {
            MethodNode aNode = (MethodNode)node;
            if (this.maxCostNode == null || this.maxCostNode.getTotalCost() < aNode.getTotalCost()) {
                this.maxCostNode = aNode;
            }
        }
        if (!this.isLeaf(node) && (children = node.getChildren()) != null) {
            for (TraceNode n : children) {
                this.findMaxCostNode(n);
            }
        }
    }

    private boolean isRoot(TraceNode node) {
        return node.parent() == null;
    }

    private boolean isLeaf(TraceNode node) {
        List<TraceNode> children = node.getChildren();
        return children == null || children.isEmpty();
    }

    double nanoToMillis(long nanoSeconds) {
        return (double)nanoSeconds / 1000000.0;
    }

    private static interface Callback {
        public void callback(int var1, boolean var2, String var3, TraceNode var4);
    }
}

