/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.taobao.arthas.core.command.model.DashboardModel;
import com.taobao.arthas.core.command.model.GcInfoVO;
import com.taobao.arthas.core.command.model.RuntimeInfoVO;
import com.taobao.arthas.core.command.model.ThreadVO;
import com.taobao.arthas.core.command.model.TomcatInfoVO;
import com.taobao.arthas.core.command.monitor200.DashboardInterruptHandler;
import com.taobao.arthas.core.command.monitor200.MemoryCommand;
import com.taobao.arthas.core.command.monitor200.ThreadSampler;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.NetUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.arthas.core.util.metrics.SumRateCounter;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;

@Name(value="dashboard")
@Summary(value="Overview of target jvm's thread, memory, gc, vm, tomcat info.")
@Description(value="\nEXAMPLES:\n  dashboard\n  dashboard -n 10\n  dashboard -i 2000\n\nWIKI:\n  https://arthas.aliyun.com/doc/dashboard")
public class DashboardCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(DashboardCommand.class);
    private SumRateCounter tomcatRequestCounter = new SumRateCounter();
    private SumRateCounter tomcatErrorCounter = new SumRateCounter();
    private SumRateCounter tomcatReceivedBytesCounter = new SumRateCounter();
    private SumRateCounter tomcatSentBytesCounter = new SumRateCounter();
    private int numOfExecutions = Integer.MAX_VALUE;
    private long interval = 5000L;
    private final AtomicLong count = new AtomicLong(0L);
    private volatile Timer timer;

    @Option(shortName="n", longName="number-of-execution")
    @Description(value="The number of times this command will be executed.")
    public void setNumOfExecutions(int numOfExecutions) {
        this.numOfExecutions = numOfExecutions;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="The interval (in ms) between two executions, default is 5000 ms.")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public void process(final CommandProcess process) {
        Session session = process.session();
        this.timer = new Timer("Timer-for-arthas-dashboard-" + session.getSessionId(), true);
        process.interruptHandler(new DashboardInterruptHandler(process, this.timer));
        Handler<Void> stopHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                DashboardCommand.this.stop();
            }
        };
        Handler<Void> restartHandler = new Handler<Void>(){
            final /* synthetic */ DashboardCommand this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void handle(Void event) {
                this.this$0.restart(process);
            }
        };
        process.suspendHandler(stopHandler);
        process.resumeHandler(restartHandler);
        process.endHandler(stopHandler);
        process.stdinHandler((Handler)new QExitHandler(process));
        this.timer.scheduleAtFixedRate((TimerTask)new DashboardTimerTask(process), 0L, this.getInterval());
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public synchronized void restart(CommandProcess process) {
        if (this.timer == null) {
            Session session = process.session();
            this.timer = new Timer("Timer-for-arthas-dashboard-" + session.getSessionId(), true);
            this.timer.scheduleAtFixedRate((TimerTask)new DashboardTimerTask(process), 0L, this.getInterval());
        }
    }

    public int getNumOfExecutions() {
        return this.numOfExecutions;
    }

    public long getInterval() {
        return this.interval;
    }

    private static void addRuntimeInfo(DashboardModel dashboardModel) {
        RuntimeInfoVO runtimeInfo = new RuntimeInfoVO();
        runtimeInfo.setOsName(System.getProperty("os.name"));
        runtimeInfo.setOsVersion(System.getProperty("os.version"));
        runtimeInfo.setJavaVersion(System.getProperty("java.version"));
        runtimeInfo.setJavaHome(System.getProperty("java.home"));
        runtimeInfo.setSystemLoadAverage(ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        runtimeInfo.setProcessors(Runtime.getRuntime().availableProcessors());
        runtimeInfo.setUptime(ManagementFactory.getRuntimeMXBean().getUptime() / 1000L);
        runtimeInfo.setTimestamp(System.currentTimeMillis());
        dashboardModel.setRuntimeInfo(runtimeInfo);
    }

    private static void addGcInfo(DashboardModel dashboardModel) {
        ArrayList<GcInfoVO> gcInfos = new ArrayList<GcInfoVO>();
        dashboardModel.setGcInfos(gcInfos);
        List<GarbageCollectorMXBean> garbageCollectorMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMXBean : garbageCollectorMxBeans) {
            String name = gcMXBean.getName();
            gcInfos.add(new GcInfoVO(StringUtils.beautifyName(name), gcMXBean.getCollectionCount(), gcMXBean.getCollectionTime()));
        }
    }

    private void addTomcatInfo(DashboardModel dashboardModel) {
        NetUtils.Response threadPoolResponse;
        if (!NetUtils.request("http://localhost:8006").isSuccess()) {
            return;
        }
        TomcatInfoVO tomcatInfoVO = new TomcatInfoVO();
        dashboardModel.setTomcatInfo(tomcatInfoVO);
        String threadPoolPath = "http://localhost:8006/connector/threadpool";
        String connectorStatPath = "http://localhost:8006/connector/stats";
        NetUtils.Response connectorStatResponse = NetUtils.request(connectorStatPath);
        if (connectorStatResponse.isSuccess()) {
            ArrayList<TomcatInfoVO.ConnectorStats> connectorStats = new ArrayList<TomcatInfoVO.ConnectorStats>();
            List tomcatConnectorStats = JSON.parseArray((String)connectorStatResponse.getContent(), JSONObject.class);
            for (JSONObject stat : tomcatConnectorStats) {
                String connectorName = stat.getString("name").replace("\"", "");
                long bytesReceived = stat.getLongValue("bytesReceived");
                long bytesSent = stat.getLongValue("bytesSent");
                long processingTime = stat.getLongValue("processingTime");
                long requestCount = stat.getLongValue("requestCount");
                long errorCount = stat.getLongValue("errorCount");
                this.tomcatRequestCounter.update(requestCount);
                this.tomcatErrorCounter.update(errorCount);
                this.tomcatReceivedBytesCounter.update(bytesReceived);
                this.tomcatSentBytesCounter.update(bytesSent);
                double qps = this.tomcatRequestCounter.rate();
                double rt = (double)processingTime / (double)requestCount;
                double errorRate = this.tomcatErrorCounter.rate();
                long receivedBytesRate = Double.valueOf(this.tomcatReceivedBytesCounter.rate()).longValue();
                long sentBytesRate = Double.valueOf(this.tomcatSentBytesCounter.rate()).longValue();
                TomcatInfoVO.ConnectorStats connectorStat = new TomcatInfoVO.ConnectorStats();
                connectorStat.setName(connectorName);
                connectorStat.setQps(qps);
                connectorStat.setRt(rt);
                connectorStat.setError(errorRate);
                connectorStat.setReceived(receivedBytesRate);
                connectorStat.setSent(sentBytesRate);
                connectorStats.add(connectorStat);
            }
            tomcatInfoVO.setConnectorStats(connectorStats);
        }
        if ((threadPoolResponse = NetUtils.request(threadPoolPath)).isSuccess()) {
            ArrayList<TomcatInfoVO.ThreadPool> threadPools = new ArrayList<TomcatInfoVO.ThreadPool>();
            List threadPoolInfos = JSON.parseArray((String)threadPoolResponse.getContent(), JSONObject.class);
            for (JSONObject info : threadPoolInfos) {
                String name = info.getString("name").replace("\"", "");
                long busy = info.getLongValue("threadBusy");
                long total = info.getLongValue("threadCount");
                threadPools.add(new TomcatInfoVO.ThreadPool(name, busy, total));
            }
            tomcatInfoVO.setThreadPools(threadPools);
        }
    }

    private class DashboardTimerTask
    extends TimerTask {
        private CommandProcess process;
        private ThreadSampler threadSampler;

        public DashboardTimerTask(CommandProcess process) {
            this.process = process;
            this.threadSampler = new ThreadSampler();
        }

        @Override
        public void run() {
            try {
                if (DashboardCommand.this.count.get() >= (long)DashboardCommand.this.getNumOfExecutions()) {
                    DashboardCommand.this.timer.cancel();
                    DashboardCommand.this.timer.purge();
                    this.process.end(0, "Process ends after " + DashboardCommand.this.getNumOfExecutions() + " time(s).");
                    return;
                }
                DashboardModel dashboardModel = new DashboardModel();
                List<ThreadVO> threads = ThreadUtil.getThreads();
                dashboardModel.setThreads(this.threadSampler.sample(threads));
                dashboardModel.setMemoryInfo(MemoryCommand.memoryInfo());
                DashboardCommand.addGcInfo(dashboardModel);
                DashboardCommand.addRuntimeInfo(dashboardModel);
                try {
                    DashboardCommand.this.addTomcatInfo(dashboardModel);
                }
                catch (Throwable e) {
                    logger.error("try to read tomcat info error", e);
                }
                this.process.appendResult(dashboardModel);
                DashboardCommand.this.count.getAndIncrement();
                this.process.times().incrementAndGet();
            }
            catch (Throwable e) {
                String msg = "process dashboard failed: " + e.getMessage();
                logger.error(msg, e);
                this.process.end(-1, msg);
            }
        }
    }
}

