/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.model;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.command.model.EnhancerAffectVO;
import com.taobao.arthas.core.command.model.EnhancerModel;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import java.io.File;
import java.util.ArrayList;

public class EnhancerModelFactory {
    public static EnhancerModel create(EnhancerAffect affect, boolean success) {
        return new EnhancerModel(EnhancerModelFactory.createEnhancerAffectVO(affect), success);
    }

    public static EnhancerModel create(EnhancerAffect affect, boolean success, String message) {
        return new EnhancerModel(EnhancerModelFactory.createEnhancerAffectVO(affect), success, message);
    }

    public static EnhancerAffectVO createEnhancerAffectVO(EnhancerAffect affect) {
        if (affect == null) {
            return new EnhancerAffectVO(-1L, 0, 0, -1L);
        }
        EnhancerAffectVO vo = new EnhancerAffectVO(affect.cost(), affect.mCnt(), affect.cCnt(), affect.getListenerId());
        vo.setThrowable(affect.getThrowable());
        vo.setOverLimitMsg(affect.getOverLimitMsg());
        if (GlobalOptions.isDump) {
            ArrayList<String> classDumpFiles = new ArrayList<String>();
            for (File classDumpFile : affect.getClassDumpFiles()) {
                classDumpFiles.add(classDumpFile.getAbsolutePath());
            }
            vo.setClassDumpFiles(classDumpFiles);
        }
        if (GlobalOptions.verbose) {
            ArrayList<String> methods = new ArrayList<String>();
            methods.addAll(affect.getMethods());
            vo.setMethods(methods);
        }
        return vo;
    }
}

