/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.view;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.command.model.ObjectVO;
import com.taobao.arthas.core.view.View;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectView
implements View {
    public static final int MAX_DEEP = 4;
    private static final Logger logger = LoggerFactory.getLogger(ObjectView.class);
    private static final int MAX_OBJECT_LENGTH = 0xA00000;
    private final Object object;
    private final int deep;
    private final int maxObjectLength;
    private static final String TAB = "    ";
    private static final Map<Byte, String> ASCII_MAP = new HashMap<Byte, String>();

    public ObjectView(ObjectVO objectVO) {
        this(0xA00000, objectVO);
    }

    public ObjectView(int maxObjectLength, ObjectVO objectVO) {
        this(objectVO.getObject(), objectVO.expandOrDefault(), maxObjectLength);
    }

    public ObjectView(Object object, int deep) {
        this(object, deep, 0xA00000);
    }

    public ObjectView(Object object, int deep, int maxObjectLength) {
        this.object = object;
        this.deep = deep > 4 ? 4 : deep;
        this.maxObjectLength = maxObjectLength;
    }

    @Override
    public String draw() {
        StringBuilder buf = new StringBuilder();
        try {
            if (GlobalOptions.isUsingJson) {
                return JSON.toJSONString((Object)this.object, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreErrorGetter});
            }
            this.renderObject(this.object, 0, this.deep, buf);
            return buf.toString();
        }
        catch (ObjectTooLargeException e) {
            buf.append(" Object size exceeds size limit: ").append(this.maxObjectLength).append(", try to specify -M size_limit in your command, check the help command for more.");
            return buf.toString();
        }
        catch (Throwable t) {
            logger.error("ObjectView draw error, object class: {}", this.object.getClass(), (Object)t);
            return "ERROR DATA!!! object class: " + this.object.getClass() + ", exception class: " + t.getClass() + ", exception message: " + t.getMessage();
        }
    }

    private void renderObject(Object obj, int deep, int expand, StringBuilder buf) throws ObjectTooLargeException {
        if (null == obj) {
            this.appendStringBuilder(buf, "null");
        } else {
            Class<?> clazz = obj.getClass();
            String className = clazz.getSimpleName();
            if (Integer.class.isInstance(obj) || Long.class.isInstance(obj) || Float.class.isInstance(obj) || Double.class.isInstance(obj) || Short.class.isInstance(obj) || Byte.class.isInstance(obj) || Boolean.class.isInstance(obj)) {
                this.appendStringBuilder(buf, String.format("@%s[%s]", className, obj));
            } else if (Character.class.isInstance(obj)) {
                Character c = (Character)obj;
                if (c.charValue() >= ' ' && c.charValue() <= '~') {
                    this.appendStringBuilder(buf, String.format("@%s[%s]", className, c));
                } else if (ASCII_MAP.containsKey((byte)c.charValue())) {
                    this.appendStringBuilder(buf, String.format("@%s[%s]", className, ASCII_MAP.get((byte)c.charValue())));
                } else {
                    this.appendStringBuilder(buf, String.format("@%s[%s]", className, c));
                }
            } else if (String.class.isInstance(obj)) {
                this.appendStringBuilder(buf, "@");
                this.appendStringBuilder(buf, className);
                this.appendStringBuilder(buf, "[");
                char[] c = ((String)obj).toCharArray();
                int n = c.length;
                block7: for (int i = 0; i < n; ++i) {
                    Character c2 = Character.valueOf(c[i]);
                    switch (c2.charValue()) {
                        case '\n': {
                            this.appendStringBuilder(buf, "\\n");
                            continue block7;
                        }
                        case '\r': {
                            this.appendStringBuilder(buf, "\\r");
                            continue block7;
                        }
                        default: {
                            this.appendStringBuilder(buf, c2.toString());
                        }
                    }
                }
                this.appendStringBuilder(buf, "]");
            } else if (Collection.class.isInstance(obj)) {
                Collection collection = (Collection)obj;
                if (!ObjectView.isExpand(deep, expand) || collection.isEmpty()) {
                    this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", className, collection.isEmpty(), collection.size()));
                } else {
                    this.appendStringBuilder(buf, String.format("@%s[", className));
                    for (Object e : collection) {
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep + 1; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.renderObject(e, deep + 1, expand, buf);
                        this.appendStringBuilder(buf, ",");
                    }
                    this.appendStringBuilder(buf, "\n");
                    for (int i = 0; i < deep; ++i) {
                        this.appendStringBuilder(buf, TAB);
                    }
                    this.appendStringBuilder(buf, "]");
                }
            } else if (Map.class.isInstance(obj)) {
                Map map = (Map)obj;
                if (!ObjectView.isExpand(deep, expand) || map.isEmpty()) {
                    this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", className, map.isEmpty(), map.size()));
                } else {
                    this.appendStringBuilder(buf, String.format("@%s[", className));
                    for (Map.Entry entry : map.entrySet()) {
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep + 1; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.renderObject(entry.getKey(), deep + 1, expand, buf);
                        this.appendStringBuilder(buf, ":");
                        this.renderObject(entry.getValue(), deep + 1, expand, buf);
                        this.appendStringBuilder(buf, ",");
                    }
                    this.appendStringBuilder(buf, "\n");
                    for (int i = 0; i < deep; ++i) {
                        this.appendStringBuilder(buf, TAB);
                    }
                    this.appendStringBuilder(buf, "]");
                }
            } else if (obj.getClass().isArray()) {
                String typeName = obj.getClass().getSimpleName();
                if (typeName.equals("int[]")) {
                    int[] arrays = (int[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (int e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(e, deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else if (typeName.equals("long[]")) {
                    long[] arrays = (long[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (long e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(e, deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else if (typeName.equals("short[]")) {
                    short[] arrays = (short[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (short e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(e, deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else if (typeName.equals("float[]")) {
                    float[] arrays = (float[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (float e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(Float.valueOf(e), deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else if (typeName.equals("double[]")) {
                    double[] arrays = (double[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (double e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(e, deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else if (typeName.equals("boolean[]")) {
                    boolean[] arrays = (boolean[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (boolean e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(e, deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else if (typeName.equals("char[]")) {
                    char[] arrays = (char[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (char e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(Character.valueOf(e), deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else if (typeName.equals("byte[]")) {
                    byte[] arrays = (byte[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (byte e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(e, deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                } else {
                    Object[] arrays = (Object[])obj;
                    if (!ObjectView.isExpand(deep, expand) || arrays.length == 0) {
                        this.appendStringBuilder(buf, String.format("@%s[isEmpty=%s;size=%d]", typeName, arrays.length == 0, arrays.length));
                    } else {
                        this.appendStringBuilder(buf, String.format("@%s[", className));
                        for (Object e : arrays) {
                            this.appendStringBuilder(buf, "\n");
                            for (int i = 0; i < deep + 1; ++i) {
                                this.appendStringBuilder(buf, TAB);
                            }
                            this.renderObject(e, deep + 1, expand, buf);
                            this.appendStringBuilder(buf, ",");
                        }
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, "]");
                    }
                }
            } else if (Throwable.class.isInstance(obj)) {
                if (!ObjectView.isExpand(deep, expand)) {
                    this.appendStringBuilder(buf, String.format("@%s[%s]", className, obj));
                } else {
                    Throwable throwable = (Throwable)obj;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    this.appendStringBuilder(buf, sw.toString());
                }
            } else if (Date.class.isInstance(obj)) {
                this.appendStringBuilder(buf, String.format("@%s[%s]", className, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS").format(obj)));
            } else if (this.object instanceof Enum) {
                this.appendStringBuilder(buf, String.format("@%s[%s]", className, obj));
            } else if (!ObjectView.isExpand(deep, expand)) {
                this.appendStringBuilder(buf, String.format("@%s[%s]", className, obj));
            } else {
                Class<?> objClass;
                ArrayList<Field> fields;
                this.appendStringBuilder(buf, String.format("@%s[", className));
                if (GlobalOptions.printParentFields) {
                    fields = new ArrayList<Field>();
                    for (objClass = obj.getClass(); objClass != null; objClass = objClass.getSuperclass()) {
                        fields.addAll(Arrays.asList(objClass.getDeclaredFields()));
                    }
                } else {
                    fields = new ArrayList<Field>(Arrays.asList(objClass.getDeclaredFields()));
                }
                for (Field field : fields) {
                    field.setAccessible(true);
                    try {
                        Object value = field.get(obj);
                        this.appendStringBuilder(buf, "\n");
                        for (int i = 0; i < deep + 1; ++i) {
                            this.appendStringBuilder(buf, TAB);
                        }
                        this.appendStringBuilder(buf, field.getName());
                        this.appendStringBuilder(buf, "=");
                        this.renderObject(value, deep + 1, expand, buf);
                        this.appendStringBuilder(buf, ",");
                    }
                    catch (ObjectTooLargeException t) {
                        buf.append("...");
                        break;
                    }
                    catch (Throwable throwable) {
                    }
                }
                this.appendStringBuilder(buf, "\n");
                for (int i = 0; i < deep; ++i) {
                    this.appendStringBuilder(buf, TAB);
                }
                this.appendStringBuilder(buf, "]");
            }
        }
    }

    private static boolean isExpand(int deep, int expand) {
        return deep < expand;
    }

    private void appendStringBuilder(StringBuilder buf, String data) throws ObjectTooLargeException {
        if (buf.length() + data.length() > this.maxObjectLength) {
            throw new ObjectTooLargeException("Object size exceeds size limit: " + this.maxObjectLength);
        }
        buf.append(data);
    }

    static {
        ASCII_MAP.put((byte)0, "NUL");
        ASCII_MAP.put((byte)1, "SOH");
        ASCII_MAP.put((byte)2, "STX");
        ASCII_MAP.put((byte)3, "ETX");
        ASCII_MAP.put((byte)4, "EOT");
        ASCII_MAP.put((byte)5, "ENQ");
        ASCII_MAP.put((byte)6, "ACK");
        ASCII_MAP.put((byte)7, "BEL");
        ASCII_MAP.put((byte)8, "BS");
        ASCII_MAP.put((byte)9, "HT");
        ASCII_MAP.put((byte)10, "LF");
        ASCII_MAP.put((byte)11, "VT");
        ASCII_MAP.put((byte)12, "FF");
        ASCII_MAP.put((byte)13, "CR");
        ASCII_MAP.put((byte)14, "SO");
        ASCII_MAP.put((byte)15, "SI");
        ASCII_MAP.put((byte)16, "DLE");
        ASCII_MAP.put((byte)17, "DC1");
        ASCII_MAP.put((byte)18, "DC2");
        ASCII_MAP.put((byte)19, "DC3");
        ASCII_MAP.put((byte)20, "DC4");
        ASCII_MAP.put((byte)21, "NAK");
        ASCII_MAP.put((byte)22, "SYN");
        ASCII_MAP.put((byte)23, "ETB");
        ASCII_MAP.put((byte)24, "CAN");
        ASCII_MAP.put((byte)25, "EM");
        ASCII_MAP.put((byte)26, "SUB");
        ASCII_MAP.put((byte)27, "ESC");
        ASCII_MAP.put((byte)28, "FS");
        ASCII_MAP.put((byte)29, "GS");
        ASCII_MAP.put((byte)30, "RS");
        ASCII_MAP.put((byte)31, "US");
        ASCII_MAP.put((byte)127, "DEL");
    }

    private static class ObjectTooLargeException
    extends Exception {
        public ObjectTooLargeException(String message) {
            super(message);
        }
    }
}

