/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.common.OSUtils;
import com.taobao.arthas.core.command.model.ProfilerModel;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import one.profiler.AsyncProfiler;
import one.profiler.Counter;

@Name(value="profiler")
@Summary(value="Async Profiler. https://github.com/jvm-profiling-tools/async-profiler")
@Description(value="\nEXAMPLES:\n  profiler start\n  profiler stop\n  profiler list                # list all supported events\n  profiler actions             # list all supported actions\n  profiler start --event alloc\n  profiler stop --format html   # output file format, support flat[=N]|traces[=N]|collapsed|flamegraph|tree|jfr\n  profiler stop --file /tmp/result.html\n  profiler stop --threads \n  profiler stop --include 'java/*' --include 'com/demo/*' --exclude '*Unsafe.park*'\n  profiler status\n  profiler resume              # Start or resume profiling without resetting collected data.\n  profiler getSamples          # Get the number of samples collected during the profiling session\n  profiler dumpFlat            # Dump flat profile, i.e. the histogram of the hottest methods\n  profiler dumpCollapsed       # Dump profile in 'collapsed stacktraces' format\n  profiler dumpTraces          # Dump collected stack traces\n  profiler execute 'stop,file=/tmp/result.html'   # Execute an agent-compatible profiling command\n\nWIKI:\n  https://arthas.aliyun.com/doc/profiler")
public class ProfilerCommand
extends AnnotatedCommand {
    private static final Logger logger;
    private String action;
    private String actionArg;
    private String event;
    private String alloc;
    private boolean live;
    private String lock;
    private String jfrsync;
    private String file;
    private String format;
    private Long interval;
    private Integer jstackdepth;
    private boolean threads;
    private boolean sched;
    private String cstack;
    private boolean simple;
    private boolean sig;
    private boolean ann;
    private boolean lib;
    private boolean alluser;
    private Long duration;
    private List<String> includes;
    private List<String> excludes;
    private String begin;
    private String end;
    private boolean ttsp;
    private String title;
    private String minwidth;
    private boolean reverse;
    private boolean total;
    private String chunksize;
    private String chunktime;
    private String loop;
    private String timeout;
    private static String libPath;
    private static AsyncProfiler profiler;

    @Argument(argName="action", index=0, required=true)
    @Description(value="Action to execute")
    public void setAction(String action) {
        this.action = action;
    }

    @Argument(argName="actionArg", index=1, required=false)
    @Description(value="Attribute name pattern.")
    public void setActionArg(String actionArg) {
        this.actionArg = actionArg;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="sampling interval in ns (default: 10'000'000, i.e. 10 ms)")
    @DefaultValue(value="10000000")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Option(shortName="j", longName="jstackdepth")
    @Description(value="maximum Java stack depth (default: 2048)")
    public void setJstackdepth(int jstackdepth) {
        this.jstackdepth = jstackdepth;
    }

    @Option(shortName="f", longName="file")
    @Description(value="dump output to <filename>, if ends with html or jfr, content format can be infered")
    public void setFile(String file) {
        this.file = file;
    }

    @Option(shortName="o", longName="format")
    @Description(value="dump output content format(flat[=N]|traces[=N]|collapsed|flamegraph|tree|jfr)")
    public void setFormat(String format) {
        if ("html".equals(format)) {
            format = "flamegraph";
        }
        this.format = format;
    }

    @Option(shortName="e", longName="event")
    @Description(value="which event to trace (cpu, alloc, lock, cache-misses etc.), default value is cpu")
    @DefaultValue(value="cpu")
    public void setEvent(String event) {
        this.event = event;
    }

    @Option(longName="alloc")
    @Description(value="allocation profiling interval in bytes")
    public void setAlloc(String alloc) {
        this.alloc = alloc;
    }

    @Option(longName="live", flag=true)
    @Description(value="build allocation profile from live objects only")
    public void setLive(boolean live) {
        this.live = live;
    }

    @Option(longName="lock")
    @Description(value="lock profiling threshold in nanoseconds")
    public void setLock(String lock) {
        this.lock = lock;
    }

    @Option(longName="jfrsync")
    @Description(value="start Java Flight Recording with the given config along with the profiler")
    public void setJfrsync(String jfrsync) {
        this.jfrsync = jfrsync;
    }

    @Option(shortName="t", longName="threads", flag=true)
    @Description(value="profile different threads separately")
    public void setThreads(boolean threads) {
        this.threads = threads;
    }

    @Option(longName="sched", flag=true)
    @Description(value="group threads by scheduling policy")
    public void setSched(boolean sched) {
        this.sched = sched;
    }

    @Option(longName="cstack")
    @Description(value="how to traverse C stack: fp|dwarf|lbr|no")
    public void setCstack(String cstack) {
        this.cstack = cstack;
    }

    @Option(shortName="s", flag=true)
    @Description(value="use simple class names instead of FQN")
    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    @Option(shortName="g", flag=true)
    @Description(value="print method signatures")
    public void setSig(boolean sig) {
        this.sig = sig;
    }

    @Option(shortName="a", flag=true)
    @Description(value="annotate Java methods")
    public void setAnn(boolean ann) {
        this.ann = ann;
    }

    @Option(shortName="l", flag=true)
    @Description(value="prepend library names")
    public void setLib(boolean lib) {
        this.lib = lib;
    }

    @Option(longName="all-user", flag=true)
    @Description(value="include only user-mode events")
    public void setAlluser(boolean alluser) {
        this.alluser = alluser;
    }

    @Option(shortName="d", longName="duration")
    @Description(value="run profiling for <duration> seconds")
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Option(shortName="I", longName="include")
    @Description(value="include stack traces containing PATTERN, for example: 'java/*'")
    public void setInclude(List<String> includes) {
        this.includes = includes;
    }

    @Option(shortName="X", longName="exclude")
    @Description(value="exclude stack traces containing PATTERN, for example: '*Unsafe.park*'")
    public void setExclude(List<String> excludes) {
        this.excludes = excludes;
    }

    @Option(longName="begin")
    @Description(value="automatically start profiling when the specified native function is executed")
    public void setBegin(String begin) {
        this.begin = begin;
    }

    @Option(longName="end")
    @Description(value="automatically stop profiling when the specified native function is executed")
    public void setEnd(String end) {
        this.end = end;
    }

    @Option(longName="ttsp", flag=true)
    @Description(value="time-to-safepoint profiling. An alias for --begin SafepointSynchronize::begin --end RuntimeService::record_safepoint_synchronized")
    public void setTtsp(boolean ttsp) {
        this.ttsp = ttsp;
    }

    @Option(longName="title")
    @Description(value="FlameGraph title")
    public void setTitle(String title) {
        this.title = title = title.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replace(",", "&#44;");
    }

    @Option(longName="minwidth")
    @Description(value="FlameGraph minimum frame width in percent")
    public void setMinwidth(String minwidth) {
        this.minwidth = minwidth;
    }

    @Option(longName="reverse", flag=true)
    @Description(value="generate stack-reversed FlameGraph / Call tree")
    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    @Option(longName="total", flag=true)
    @Description(value="count the total value (time, bytes, etc.) instead of samples")
    public void setTotal(boolean total) {
        this.total = total;
    }

    @Option(longName="chunksize")
    @Description(value="approximate size limits for a single JFR chunk in bytes (default: 100 MB) or other units")
    public void setChunksize(String chunksize) {
        this.chunksize = chunksize;
    }

    @Option(longName="chunktime")
    @Description(value="approximate time limits for a single JFR chunk in second (default: 1 hour) or other units")
    public void setChunktime(String chunktime) {
        this.chunktime = chunktime;
    }

    @Option(longName="loop")
    @Description(value="run profiler in a loop (continuous profiling)")
    public void setLoop(String loop) {
        this.loop = loop;
        if (this.action.equals("collect")) {
            this.action = "start";
        }
    }

    @Option(longName="timeout")
    @Description(value="automatically stop profiler at TIME (absolute or relative)")
    public void setTimeout(String timeout) {
        this.timeout = timeout;
        if (this.action.equals("collect")) {
            this.action = "start";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncProfiler profilerInstance() {
        block7: {
            block8: {
                if (profiler != null) {
                    return profiler;
                }
                if (ProfilerAction.load.toString().equals(this.action)) {
                    profiler = AsyncProfiler.getInstance(this.actionArg);
                }
                if (libPath == null) break block8;
                FileOutputStream tmpLibOutputStream = null;
                FileInputStream libInputStream = null;
                try {
                    File tmpLibFile = File.createTempFile("ArthasJniLibrary", null);
                    tmpLibOutputStream = new FileOutputStream(tmpLibFile);
                    libInputStream = new FileInputStream(libPath);
                    IOUtils.copy((InputStream)libInputStream, (OutputStream)tmpLibOutputStream);
                    libPath = tmpLibFile.getAbsolutePath();
                    logger.debug("copy {} to {}", (Object)libPath, (Object)tmpLibFile);
                }
                catch (Throwable e) {
                    try {
                        logger.error("try to copy lib error! libPath: {}", (Object)libPath, (Object)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(libInputStream);
                        IOUtils.close(tmpLibOutputStream);
                        throw throwable;
                    }
                    IOUtils.close(libInputStream);
                    IOUtils.close((OutputStream)tmpLibOutputStream);
                    break block7;
                }
                IOUtils.close((InputStream)libInputStream);
                IOUtils.close((OutputStream)tmpLibOutputStream);
                break block7;
            }
            if (OSUtils.isLinux() || OSUtils.isMac()) {
                throw new IllegalStateException("Can not find libasyncProfiler so, please check the arthas directory.");
            }
            throw new IllegalStateException("Current OS do not support AsyncProfiler, Only support Linux/Mac.");
        }
        profiler = AsyncProfiler.getInstance(libPath);
        return profiler;
    }

    private String executeArgs(ProfilerAction action) {
        StringBuilder sb = new StringBuilder();
        int COMMA = 44;
        sb.append((Object)action).append(',');
        if (this.event != null) {
            sb.append("event=").append(this.event).append(',');
        }
        if (this.alloc != null) {
            sb.append("alloc=").append(this.alloc).append(',');
        }
        if (this.live) {
            sb.append("live").append(',');
        }
        if (this.lock != null) {
            sb.append("lock=").append(this.lock).append(',');
        }
        if (this.jfrsync != null) {
            this.format = "jfr";
            sb.append("jfrsync=").append(this.jfrsync).append(',');
        }
        if (this.file != null) {
            sb.append("file=").append(this.file).append(',');
        }
        if (this.format != null) {
            sb.append(this.format).append(',');
        }
        if (this.interval != null) {
            sb.append("interval=").append(this.interval).append(',');
        }
        if (this.jstackdepth != null) {
            sb.append("jstackdepth=").append(this.jstackdepth).append(',');
        }
        if (this.threads) {
            sb.append("threads").append(',');
        }
        if (this.sched) {
            sb.append("sched").append(',');
        }
        if (this.cstack != null) {
            sb.append("cstack=").append(this.cstack).append(',');
        }
        if (this.simple) {
            sb.append("simple").append(',');
        }
        if (this.sig) {
            sb.append("sig").append(',');
        }
        if (this.ann) {
            sb.append("ann").append(',');
        }
        if (this.lib) {
            sb.append("lib").append(',');
        }
        if (this.alluser) {
            sb.append("alluser").append(',');
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                sb.append("include=").append(include).append(',');
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                sb.append("exclude=").append(exclude).append(',');
            }
        }
        if (this.ttsp) {
            this.begin = "SafepointSynchronize::begin";
            this.end = "RuntimeService::record_safepoint_synchronized";
        }
        if (this.begin != null) {
            sb.append("begin=").append(this.begin).append(',');
        }
        if (this.end != null) {
            sb.append("end=").append(this.end).append(',');
        }
        if (this.title != null) {
            sb.append("title=").append(this.title).append(',');
        }
        if (this.minwidth != null) {
            sb.append("minwidth=").append(this.minwidth).append(',');
        }
        if (this.reverse) {
            sb.append("reverse").append(',');
        }
        if (this.total) {
            sb.append("total").append(',');
        }
        if (this.chunksize != null) {
            sb.append("chunksize=").append(this.chunksize).append(',');
        }
        if (this.chunktime != null) {
            sb.append("chunktime=").append(this.chunktime).append(',');
        }
        if (this.loop != null) {
            sb.append("loop=").append(this.loop).append(',');
        }
        if (this.timeout != null) {
            sb.append("timeout=").append(this.timeout).append(',');
        }
        return sb.toString();
    }

    private static String execute(AsyncProfiler asyncProfiler, String arg) throws IllegalArgumentException, IOException {
        String result = asyncProfiler.execute(arg);
        if (!result.endsWith("\n")) {
            result = result + "\n";
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(CommandProcess process) {
        try {
            ProfilerAction profilerAction = ProfilerAction.valueOf(this.action);
            if (ProfilerAction.actions.equals((Object)profilerAction)) {
                process.appendResult(new ProfilerModel(this.actions()));
                process.end();
                return;
            }
            final AsyncProfiler asyncProfiler = this.profilerInstance();
            if (ProfilerAction.execute.equals((Object)profilerAction)) {
                if (this.actionArg == null) {
                    process.end(1, "actionArg can not be empty.");
                    return;
                }
                String result = ProfilerCommand.execute(asyncProfiler, this.actionArg);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.collect.equals((Object)profilerAction)) {
                String executeArgs = this.executeArgs(ProfilerAction.collect);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                ProfilerModel profilerModel = this.createProfilerModel(result);
                if (this.duration != null) {
                    String outputFile = this.outputFile();
                    profilerModel.setOutputFile(outputFile);
                    profilerModel.setDuration(this.duration);
                    ArthasBootstrap.getInstance().getScheduledExecutorService().schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                logger.info("stopping profiler ...");
                                ProfilerModel model = ProfilerCommand.this.processStop(asyncProfiler, ProfilerAction.stop);
                                logger.info("profiler output file: " + model.getOutputFile());
                                logger.info("stop profiler successfully.");
                            }
                            catch (Throwable e) {
                                logger.error("stop profiler failure", e);
                            }
                        }
                    }, (long)this.duration, TimeUnit.SECONDS);
                }
                process.appendResult(profilerModel);
            } else if (ProfilerAction.start.equals((Object)profilerAction)) {
                String executeArgs = this.executeArgs(ProfilerAction.start);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.stop.equals((Object)profilerAction)) {
                ProfilerModel profilerModel = this.processStop(asyncProfiler, profilerAction);
                process.appendResult(profilerModel);
            } else if (ProfilerAction.dump.equals((Object)profilerAction)) {
                ProfilerModel profilerModel = this.processStop(asyncProfiler, profilerAction);
                process.appendResult(profilerModel);
            } else if (ProfilerAction.resume.equals((Object)profilerAction)) {
                String executeArgs = this.executeArgs(ProfilerAction.resume);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.check.equals((Object)profilerAction)) {
                String executeArgs = this.executeArgs(ProfilerAction.check);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.version.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute("version=full");
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.status.equals((Object)profilerAction) || ProfilerAction.meminfo.equals((Object)profilerAction) || ProfilerAction.list.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute(profilerAction.toString());
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.dumpCollapsed.equals((Object)profilerAction)) {
                if (this.actionArg == null) {
                    this.actionArg = "TOTAL";
                }
                this.actionArg = this.actionArg.toUpperCase();
                if (!"TOTAL".equals(this.actionArg) && !"SAMPLES".equals(this.actionArg)) {
                    process.end(1, "ERROR: dumpCollapsed argumment should be TOTAL or SAMPLES. ");
                    return;
                }
                String result = asyncProfiler.dumpCollapsed(Counter.valueOf(this.actionArg));
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.dumpFlat.equals((Object)profilerAction)) {
                int maxMethods = 0;
                if (this.actionArg != null) {
                    maxMethods = Integer.valueOf(this.actionArg);
                }
                String result = asyncProfiler.dumpFlat(maxMethods);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.dumpTraces.equals((Object)profilerAction)) {
                int maxTraces = 0;
                if (this.actionArg != null) {
                    maxTraces = Integer.valueOf(this.actionArg);
                }
                String result = asyncProfiler.dumpTraces(maxTraces);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.getSamples.equals((Object)profilerAction)) {
                String result = "" + asyncProfiler.getSamples() + "\n";
                this.appendExecuteResult(process, result);
            }
            process.end();
            return;
        }
        catch (Throwable e) {
            logger.error("AsyncProfiler error", e);
            process.end(1, "AsyncProfiler error: " + e.getMessage());
        }
    }

    private ProfilerModel processStop(AsyncProfiler asyncProfiler, ProfilerAction profilerAction) throws IOException {
        String outputFile = this.outputFile();
        String executeArgs = this.executeArgs(profilerAction);
        String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
        ProfilerModel profilerModel = this.createProfilerModel(result);
        profilerModel.setOutputFile(outputFile);
        return profilerModel;
    }

    private String outputFile() throws IOException {
        if (this.file == null) {
            String fileExt = this.outputFileExt();
            File outputPath = ArthasBootstrap.getInstance().getOutputPath();
            this.file = outputPath != null ? new File(outputPath, new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + fileExt).getAbsolutePath() : File.createTempFile("arthas-output", "." + fileExt).getAbsolutePath();
        }
        return this.file;
    }

    private String outputFileExt() {
        String fileExt = "";
        fileExt = this.format == null ? "html" : (this.format.startsWith("flat") || this.format.startsWith("traces") || this.format.equals("collapsed") ? "txt" : (this.format.equals("flamegraph") || this.format.equals("tree") ? "html" : (this.format.equals("jfr") ? "jfr" : "txt")));
        return fileExt;
    }

    private void appendExecuteResult(CommandProcess process, String result) {
        ProfilerModel profilerModel = this.createProfilerModel(result);
        process.appendResult(profilerModel);
    }

    private ProfilerModel createProfilerModel(String result) {
        ProfilerModel profilerModel = new ProfilerModel();
        profilerModel.setAction(this.action);
        profilerModel.setActionArg(this.actionArg);
        profilerModel.setExecuteResult(result);
        return profilerModel;
    }

    private List<String> events() {
        String[] lines;
        String execute;
        ArrayList<String> result = new ArrayList<String>();
        try {
            execute = this.profilerInstance().execute("list");
        }
        catch (Throwable e) {
            return result;
        }
        for (String line : lines = execute.split("\\r?\\n")) {
            if (!line.startsWith(" ")) continue;
            result.add(line.trim());
        }
        return result;
    }

    private Set<String> actions() {
        HashSet<String> values = new HashSet<String>();
        for (ProfilerAction action : ProfilerAction.values()) {
            values.add(action.toString());
        }
        return values;
    }

    @Override
    public void complete(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String token = tokens.get(tokens.size() - 1).value();
        if (tokens.size() >= 2) {
            CliToken cliToken_1 = tokens.get(tokens.size() - 1);
            CliToken cliToken_2 = tokens.get(tokens.size() - 2);
            if (cliToken_1.isBlank()) {
                String token_2 = cliToken_2.value();
                if (token_2.equals("-e") || token_2.equals("--event")) {
                    CompletionUtils.complete(completion, this.events());
                    return;
                }
                if (token_2.equals("-f") || token_2.equals("--format")) {
                    CompletionUtils.complete(completion, Arrays.asList("html", "jfr"));
                    return;
                }
            }
        }
        if (token.startsWith("-")) {
            super.complete(completion);
            return;
        }
        CompletionUtils.complete(completion, this.actions());
    }

    static {
        CodeSource codeSource;
        logger = LoggerFactory.getLogger(ProfilerCommand.class);
        profiler = null;
        String profilerSoPath = null;
        if (OSUtils.isMac()) {
            profilerSoPath = "async-profiler/libasyncProfiler-mac.so";
        }
        if (OSUtils.isLinux()) {
            if (OSUtils.isX86_64() && OSUtils.isMuslLibc()) {
                profilerSoPath = "async-profiler/libasyncProfiler-linux-musl-x64.so";
            } else if (OSUtils.isX86_64()) {
                profilerSoPath = "async-profiler/libasyncProfiler-linux-x64.so";
            } else if (OSUtils.isArm64() && OSUtils.isMuslLibc()) {
                profilerSoPath = "async-profiler/libasyncProfiler-linux-musl-arm64.so";
            } else if (OSUtils.isArm64()) {
                profilerSoPath = "async-profiler/libasyncProfiler-linux-arm64.so";
            }
        }
        if (profilerSoPath != null && (codeSource = ProfilerCommand.class.getProtectionDomain().getCodeSource()) != null) {
            try {
                File bootJarPath = new File(codeSource.getLocation().toURI().getSchemeSpecificPart());
                File soFile = new File(bootJarPath.getParentFile(), profilerSoPath);
                if (soFile.exists()) {
                    libPath = soFile.getAbsolutePath();
                }
            }
            catch (Throwable e) {
                logger.error("can not find libasyncProfiler so", e);
            }
        }
    }

    public static enum ProfilerAction {
        start,
        resume,
        stop,
        dump,
        check,
        status,
        meminfo,
        list,
        collect,
        version,
        load,
        execute,
        dumpCollapsed,
        dumpFlat,
        dumpTraces,
        getSamples,
        actions;

    }
}

