/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.security.BasicPrincipal;
import com.taobao.arthas.core.security.SecurityAuthenticator;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

@Name(value="auth")
@Summary(value="Authenticates the current session")
@Description(value="\nEXAMPLES:\n  auth\n  auth <password>\n  auth --username <username> <password>\n\nWIKI:\n  https://arthas.aliyun.com/3.x/doc/auth")
public class AuthCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(AuthCommand.class);
    private String username;
    private String password;
    private SecurityAuthenticator authenticator = ArthasBootstrap.getInstance().getSecurityAuthenticator();

    @Argument(argName="password", index=0, required=false)
    @Description(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    @Option(shortName="n", longName="username")
    @Description(value="username, default value 'arthas'")
    @DefaultValue(value="arthas")
    public void setUsername(String username) {
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        block11: {
            int status = 0;
            String message = "";
            try {
                Session session = process.session();
                if (this.username == null) {
                    status = 1;
                    message = "username can not be empty!";
                    return;
                }
                if (this.password == null) {
                    boolean authenticated = session.get("subject") != null;
                    boolean needLogin = this.authenticator.needLogin();
                    message = "Authentication result: " + authenticated + ", Need authentication: " + needLogin;
                    if (needLogin && !authenticated) {
                        status = 1;
                    }
                    return;
                }
                BasicPrincipal principal = new BasicPrincipal(this.username, this.password);
                try {
                    Subject subject = this.authenticator.login(principal);
                    if (subject != null) {
                        session.put("subject", subject);
                        message = "Authentication result: true, username: " + this.username;
                        break block11;
                    }
                    status = 1;
                    message = "Authentication result: false, username: " + this.username;
                }
                catch (LoginException e) {
                    logger.error("Authentication error, username: {}", (Object)this.username, (Object)e);
                }
            }
            finally {
                process.end(status, message);
            }
        }
    }

    @Override
    public void complete(Completion completion) {
        if (!CompletionUtils.completeFilePath(completion)) {
            super.complete(completion);
        }
    }
}

