/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.command.model.BlockingLockInfo;
import com.taobao.arthas.core.command.model.BusyThreadInfo;
import com.taobao.arthas.core.command.model.StackModel;
import com.taobao.arthas.core.command.model.ThreadNode;
import com.taobao.arthas.core.command.model.ThreadVO;
import com.taobao.arthas.core.view.Ansi;
import java.arthas.SpyAPI;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ThreadUtil {
    private static final BlockingLockInfo EMPTY_INFO = new BlockingLockInfo();
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static boolean detectedEagleEye = false;
    public static boolean foundEagleEye = false;
    private static int MAGIC_STACK_DEPTH = 0;

    public static ThreadGroup getRoot() {
        ThreadGroup parent;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        return group;
    }

    public static List<ThreadVO> getThreads() {
        ThreadGroup root = ThreadUtil.getRoot();
        Thread[] threads = new Thread[root.activeCount()];
        while (root.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        ArrayList<ThreadVO> list = new ArrayList<ThreadVO>(threads.length);
        for (Thread thread : threads) {
            if (thread == null) continue;
            ThreadVO threadVO = ThreadUtil.createThreadVO(thread);
            list.add(threadVO);
        }
        return list;
    }

    private static ThreadVO createThreadVO(Thread thread) {
        ThreadGroup group = thread.getThreadGroup();
        ThreadVO threadVO = new ThreadVO();
        threadVO.setId(thread.getId());
        threadVO.setName(thread.getName());
        threadVO.setGroup(group == null ? "" : group.getName());
        threadVO.setPriority(thread.getPriority());
        threadVO.setState(thread.getState());
        threadVO.setInterrupted(thread.isInterrupted());
        threadVO.setDaemon(thread.isDaemon());
        return threadVO;
    }

    public static List<Thread> getThreadList() {
        ArrayList<Thread> result = new ArrayList<Thread>();
        ThreadGroup root = ThreadUtil.getRoot();
        Thread[] threads = new Thread[root.activeCount()];
        while (root.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        for (Thread thread : threads) {
            if (thread == null) continue;
            result.add(thread);
        }
        return result;
    }

    public static BlockingLockInfo findMostBlockingLock() {
        ThreadInfo[] infos = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported());
        HashMap<Integer, Integer> blockCountPerLock = new HashMap<Integer, Integer>();
        HashMap<Integer, ThreadInfo> ownerThreadPerLock = new HashMap<Integer, ThreadInfo>();
        for (ThreadInfo info : infos) {
            if (info == null) continue;
            LockInfo lockInfo = info.getLockInfo();
            if (lockInfo != null) {
                if (blockCountPerLock.get(lockInfo.getIdentityHashCode()) == null) {
                    blockCountPerLock.put(lockInfo.getIdentityHashCode(), 0);
                }
                int blockedCount = (Integer)blockCountPerLock.get(lockInfo.getIdentityHashCode());
                blockCountPerLock.put(lockInfo.getIdentityHashCode(), blockedCount + 1);
            }
            for (MonitorInfo monitorInfo : info.getLockedMonitors()) {
                if (ownerThreadPerLock.get(monitorInfo.getIdentityHashCode()) != null) continue;
                ownerThreadPerLock.put(monitorInfo.getIdentityHashCode(), info);
            }
            for (LockInfo lockedSync : info.getLockedSynchronizers()) {
                if (ownerThreadPerLock.get(lockedSync.getIdentityHashCode()) != null) continue;
                ownerThreadPerLock.put(lockedSync.getIdentityHashCode(), info);
            }
        }
        int mostBlockingLock = 0;
        int maxBlockingCount = 0;
        for (Map.Entry entry : blockCountPerLock.entrySet()) {
            if ((Integer)entry.getValue() <= maxBlockingCount || ownerThreadPerLock.get(entry.getKey()) == null) continue;
            maxBlockingCount = (Integer)entry.getValue();
            mostBlockingLock = (Integer)entry.getKey();
        }
        if (mostBlockingLock == 0) {
            return EMPTY_INFO;
        }
        BlockingLockInfo blockingLockInfo = new BlockingLockInfo();
        blockingLockInfo.setThreadInfo((ThreadInfo)ownerThreadPerLock.get(mostBlockingLock));
        blockingLockInfo.setLockIdentityHashCode(mostBlockingLock);
        blockingLockInfo.setBlockingThreadCount((Integer)blockCountPerLock.get(mostBlockingLock));
        return blockingLockInfo;
    }

    public static String getFullStacktrace(ThreadInfo threadInfo) {
        return ThreadUtil.getFullStacktrace(threadInfo, -1.0, -1L, -1L, 0, 0);
    }

    public static String getFullStacktrace(BlockingLockInfo blockingLockInfo) {
        return ThreadUtil.getFullStacktrace(blockingLockInfo.getThreadInfo(), -1.0, -1L, -1L, blockingLockInfo.getLockIdentityHashCode(), blockingLockInfo.getBlockingThreadCount());
    }

    public static String getFullStacktrace(ThreadInfo threadInfo, double cpuUsage, long deltaTime, long time, int lockIdentityHashCode, int blockingThreadCount) {
        LockInfo[] locks;
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId());
        if (cpuUsage >= 0.0 && cpuUsage <= 100.0) {
            sb.append(" cpuUsage=").append(cpuUsage).append("%");
        }
        if (deltaTime >= 0L) {
            sb.append(" deltaTime=").append(deltaTime).append("ms");
        }
        if (time >= 0L) {
            sb.append(" time=").append(time).append("ms");
        }
        sb.append(" ").append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            sb.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        int i = 0;
        for (StackTraceElement ste : threadInfo.getStackTrace()) {
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo mi : threadInfo.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(mi);
                if (mi.getIdentityHashCode() == lockIdentityHashCode) {
                    Ansi highlighted = Ansi.ansi().fg(Ansi.Color.RED);
                    highlighted.a(" <---- but blocks ").a(blockingThreadCount).a(" other threads!");
                    sb.append(highlighted.reset().toString());
                }
                sb.append('\n');
            }
            ++i;
        }
        if (i < threadInfo.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = threadInfo.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- ").append(li);
                if (li.getIdentityHashCode() == lockIdentityHashCode) {
                    sb.append(" <---- but blocks ").append(blockingThreadCount);
                    sb.append(" other threads!");
                }
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString().replace("\t", "    ");
    }

    public static String getFullStacktrace(BusyThreadInfo threadInfo, int lockIdentityHashCode, int blockingThreadCount) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getName() + "\"");
        if (threadInfo.getId() > 0L) {
            sb.append(" Id=").append(threadInfo.getId());
        } else {
            sb.append(" [Internal]");
        }
        double cpuUsage = threadInfo.getCpu();
        if (cpuUsage >= 0.0 && cpuUsage <= 100.0) {
            sb.append(" cpuUsage=").append(cpuUsage).append("%");
        }
        if (threadInfo.getDeltaTime() >= 0L) {
            sb.append(" deltaTime=").append(threadInfo.getDeltaTime()).append("ms");
        }
        if (threadInfo.getTime() >= 0L) {
            sb.append(" time=").append(threadInfo.getTime()).append("ms");
        }
        if (threadInfo.getState() == null) {
            sb.append("\n\n");
            return sb.toString();
        }
        sb.append(" ").append((Object)threadInfo.getState());
        if (threadInfo.getLockName() != null) {
            sb.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < threadInfo.getStackTrace().length; ++i) {
            StackTraceElement ste = threadInfo.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo);
                if (lockInfo.getIdentityHashCode() == lockIdentityHashCode) {
                    Ansi highlighted = Ansi.ansi().fg(Ansi.Color.RED);
                    highlighted.a(" <---- but blocks ").a(blockingThreadCount).a(" other threads!");
                    sb.append(highlighted.reset().toString());
                }
                sb.append('\n');
            }
        }
        if (i < threadInfo.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = threadInfo.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo);
                if (lockInfo.getIdentityHashCode() == lockIdentityHashCode) {
                    sb.append(" <---- but blocks ").append(blockingThreadCount);
                    sb.append(" other threads!");
                }
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString().replace("\t", "    ");
    }

    private static int findTheSpyAPIDepth(StackTraceElement[] stackTraceElementArray) {
        if (MAGIC_STACK_DEPTH > 0) {
            return MAGIC_STACK_DEPTH;
        }
        if (MAGIC_STACK_DEPTH > stackTraceElementArray.length) {
            return 0;
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!SpyAPI.class.getName().equals(stackTraceElementArray[i].getClassName())) continue;
            MAGIC_STACK_DEPTH = i + 1;
            break;
        }
        return MAGIC_STACK_DEPTH;
    }

    public static StackModel getThreadStackModel(ClassLoader loader, Thread currentThread) {
        StackModel stackModel = new StackModel();
        stackModel.setThreadName(currentThread.getName());
        stackModel.setThreadId(Long.toString(currentThread.getId()));
        stackModel.setDaemon(currentThread.isDaemon());
        stackModel.setPriority(currentThread.getPriority());
        stackModel.setClassloader(ThreadUtil.getTCCL(currentThread));
        ThreadUtil.getEagleeyeTraceInfo(loader, currentThread, stackModel);
        StackTraceElement[] stackTraceElementArray = currentThread.getStackTrace();
        int magicStackDepth = ThreadUtil.findTheSpyAPIDepth(stackTraceElementArray);
        StackTraceElement[] actualStackFrames = new StackTraceElement[stackTraceElementArray.length - magicStackDepth];
        System.arraycopy(stackTraceElementArray, magicStackDepth, actualStackFrames, 0, actualStackFrames.length);
        stackModel.setStackTrace(actualStackFrames);
        return stackModel;
    }

    public static ThreadNode getThreadNode(ClassLoader loader, Thread currentThread) {
        ThreadNode threadNode = new ThreadNode();
        threadNode.setThreadId(currentThread.getId());
        threadNode.setThreadName(currentThread.getName());
        threadNode.setDaemon(currentThread.isDaemon());
        threadNode.setPriority(currentThread.getPriority());
        threadNode.setClassloader(ThreadUtil.getTCCL(currentThread));
        StackModel stackModel = new StackModel();
        ThreadUtil.getEagleeyeTraceInfo(loader, currentThread, stackModel);
        threadNode.setTraceId(stackModel.getTraceId());
        threadNode.setRpcId(stackModel.getRpcId());
        return threadNode;
    }

    public static String getThreadTitle(StackModel stackModel) {
        StringBuilder sb = new StringBuilder("thread_name=");
        sb.append(stackModel.getThreadName()).append(";id=").append(stackModel.getThreadId()).append(";is_daemon=").append(stackModel.isDaemon()).append(";priority=").append(stackModel.getPriority()).append(";TCCL=").append(stackModel.getClassloader());
        if (stackModel.getTraceId() != null) {
            sb.append(";trace_id=").append(stackModel.getTraceId());
        }
        if (stackModel.getRpcId() != null) {
            sb.append(";rpc_id=").append(stackModel.getRpcId());
        }
        return sb.toString();
    }

    private static String getTCCL(Thread currentThread) {
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (null == contextClassLoader) {
            return "null";
        }
        return contextClassLoader.getClass().getName() + "@" + Integer.toHexString(contextClassLoader.hashCode());
    }

    private static void getEagleeyeTraceInfo(ClassLoader loader, Thread currentThread, StackModel stackModel) {
        if (loader == null) {
            return;
        }
        Class<?> eagleEyeClass = null;
        if (!detectedEagleEye) {
            try {
                eagleEyeClass = loader.loadClass("com.taobao.eagleeye.EagleEye");
                foundEagleEye = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            detectedEagleEye = true;
        }
        if (!foundEagleEye) {
            return;
        }
        try {
            if (eagleEyeClass == null) {
                eagleEyeClass = loader.loadClass("com.taobao.eagleeye.EagleEye");
            }
            Method getTraceIdMethod = eagleEyeClass.getMethod("getTraceId", new Class[0]);
            String traceId = (String)getTraceIdMethod.invoke(null, new Object[0]);
            stackModel.setTraceId(traceId);
            Method getRpcIdMethod = eagleEyeClass.getMethod("getRpcId", new Class[0]);
            String rpcId = (String)getRpcIdMethod.invoke(null, new Object[0]);
            stackModel.setRpcId(rpcId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

