/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.httptelnet;

import com.taobao.arthas.core.shell.term.impl.http.BasicHttpAuthenticatorHandler;
import com.taobao.arthas.core.shell.term.impl.http.HttpRequestHandler;
import com.taobao.arthas.core.shell.term.impl.http.TtyWebSocketFrameHandler;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSessionManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import io.termd.core.function.Consumer;
import io.termd.core.function.Supplier;
import io.termd.core.telnet.TelnetHandler;
import io.termd.core.telnet.netty.TelnetChannelHandler;
import io.termd.core.tty.TtyConnection;
import java.util.concurrent.TimeUnit;

public class ProtocolDetectHandler
extends ChannelInboundHandlerAdapter {
    private ChannelGroup channelGroup;
    private Supplier<TelnetHandler> handlerFactory;
    private Consumer<TtyConnection> ttyConnectionFactory;
    private EventExecutorGroup workerGroup;
    private HttpSessionManager httpSessionManager;
    private ScheduledFuture<?> detectTelnetFuture;

    public ProtocolDetectHandler(ChannelGroup channelGroup, Supplier<TelnetHandler> handlerFactory, Consumer<TtyConnection> ttyConnectionFactory, EventExecutorGroup workerGroup, HttpSessionManager httpSessionManager) {
        this.channelGroup = channelGroup;
        this.handlerFactory = handlerFactory;
        this.ttyConnectionFactory = ttyConnectionFactory;
        this.workerGroup = workerGroup;
        this.httpSessionManager = httpSessionManager;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        this.detectTelnetFuture = ctx.channel().eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                ProtocolDetectHandler.this.channelGroup.add((Object)ctx.channel());
                TelnetChannelHandler handler = new TelnetChannelHandler(ProtocolDetectHandler.this.handlerFactory);
                ChannelPipeline pipeline = ctx.pipeline();
                pipeline.addLast(new ChannelHandler[]{handler});
                pipeline.remove((ChannelHandler)ProtocolDetectHandler.this);
                ctx.fireChannelActive();
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf in = (ByteBuf)msg;
        if (in.readableBytes() < 3) {
            return;
        }
        if (this.detectTelnetFuture != null && this.detectTelnetFuture.isCancellable()) {
            this.detectTelnetFuture.cancel(false);
        }
        byte[] bytes = new byte[3];
        in.getBytes(0, bytes);
        String httpHeader = new String(bytes);
        ChannelPipeline pipeline = ctx.pipeline();
        if (!"GET".equalsIgnoreCase(httpHeader)) {
            this.channelGroup.add((Object)ctx.channel());
            TelnetChannelHandler handler = new TelnetChannelHandler(this.handlerFactory);
            pipeline.addLast(new ChannelHandler[]{handler});
            ctx.fireChannelActive();
        } else {
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0xA00000)});
            pipeline.addLast(new ChannelHandler[]{new BasicHttpAuthenticatorHandler(this.httpSessionManager)});
            pipeline.addLast(this.workerGroup, "HttpRequestHandler", (ChannelHandler)new HttpRequestHandler("/ws"));
            pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws", null, false, 0xA00000, false, true)});
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, 60)});
            pipeline.addLast(new ChannelHandler[]{new TtyWebSocketFrameHandler(this.channelGroup, this.ttyConnectionFactory)});
            ctx.fireChannelActive();
        }
        pipeline.remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)in);
    }
}

