/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.alibaba.deps.org.objectweb.asm.Type;
import com.taobao.arthas.core.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ArthasMethod {
    private final Class<?> clazz;
    private final String methodName;
    private final String methodDesc;
    private Constructor<?> constructor;
    private Method method;

    private void initMethod() {
        if (this.constructor != null || this.method != null) {
            return;
        }
        try {
            ClassLoader loader = this.clazz.getClassLoader();
            Type asmType = Type.getMethodType((String)this.methodDesc);
            Class[] argsClasses = new Class[asmType.getArgumentTypes().length];
            for (int index = 0; index < argsClasses.length; ++index) {
                Class<Object> argumentClass;
                Type argumentAsmType = asmType.getArgumentTypes()[index];
                switch (argumentAsmType.getSort()) {
                    case 1: {
                        argumentClass = Boolean.TYPE;
                        break;
                    }
                    case 2: {
                        argumentClass = Character.TYPE;
                        break;
                    }
                    case 3: {
                        argumentClass = Byte.TYPE;
                        break;
                    }
                    case 4: {
                        argumentClass = Short.TYPE;
                        break;
                    }
                    case 5: {
                        argumentClass = Integer.TYPE;
                        break;
                    }
                    case 6: {
                        argumentClass = Float.TYPE;
                        break;
                    }
                    case 7: {
                        argumentClass = Long.TYPE;
                        break;
                    }
                    case 8: {
                        argumentClass = Double.TYPE;
                        break;
                    }
                    case 9: {
                        argumentClass = this.toClass(loader, argumentAsmType.getInternalName());
                        break;
                    }
                    case 0: {
                        argumentClass = Void.TYPE;
                        break;
                    }
                    default: {
                        argumentClass = this.toClass(loader, argumentAsmType.getClassName());
                    }
                }
                argsClasses[index] = argumentClass;
            }
            if ("<init>".equals(this.methodName)) {
                this.constructor = this.clazz.getDeclaredConstructor(argsClasses);
            } else {
                this.method = this.clazz.getDeclaredMethod(this.methodName, argsClasses);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> toClass(ClassLoader loader, String className) throws ClassNotFoundException {
        return Class.forName(StringUtils.normalizeClassName(className), true, this.toClassLoader(loader));
    }

    private ClassLoader toClassLoader(ClassLoader loader) {
        return null != loader ? loader : ArthasMethod.class.getClassLoader();
    }

    public String getName() {
        return this.methodName;
    }

    public String toString() {
        this.initMethod();
        if (this.constructor != null) {
            return this.constructor.toString();
        }
        if (this.method != null) {
            return this.method.toString();
        }
        return "ERROR_METHOD";
    }

    public boolean isAccessible() {
        this.initMethod();
        if (this.method != null) {
            return this.method.isAccessible();
        }
        if (this.constructor != null) {
            return this.constructor.isAccessible();
        }
        return false;
    }

    public void setAccessible(boolean accessFlag) {
        this.initMethod();
        if (this.constructor != null) {
            this.constructor.setAccessible(accessFlag);
        } else if (this.method != null) {
            this.method.setAccessible(accessFlag);
        }
    }

    public Object invoke(Object target, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        this.initMethod();
        if (this.method != null) {
            return this.method.invoke(target, args);
        }
        if (this.constructor != null) {
            return this.constructor.newInstance(args);
        }
        return null;
    }

    public ArthasMethod(Class<?> clazz, String methodName, String methodDesc) {
        this.clazz = clazz;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
    }
}

