/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.AdviceWeaver;
import com.taobao.arthas.core.advisor.Enhancer;
import com.taobao.arthas.core.advisor.InvokeTraceable;
import com.taobao.arthas.core.command.model.EnhancerModel;
import com.taobao.arthas.core.command.monitor200.AbstractTraceAdviceListener;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.view.Ansi;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Option;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.List;

public abstract class EnhancerCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(EnhancerCommand.class);
    protected static final List<String> EMPTY = Collections.emptyList();
    public static final String[] EXPRESS_EXAMPLES = new String[]{"params", "returnObj", "throwExp", "target", "clazz", "method", "{params,returnObj}", "params[0]"};
    private String excludeClassPattern;
    protected Matcher classNameMatcher;
    protected Matcher classNameExcludeMatcher;
    protected Matcher methodNameMatcher;
    protected long listenerId;
    protected boolean verbose;

    @Option(longName="exclude-class-pattern")
    @Description(value="exclude class name pattern, use either '.' or '/' as separator")
    public void setExcludeClassPattern(String excludeClassPattern) {
        this.excludeClassPattern = excludeClassPattern;
    }

    @Option(longName="listenerId")
    @Description(value="The special listenerId")
    public void setListenerId(long listenerId) {
        this.listenerId = listenerId;
    }

    @Option(shortName="v", longName="verbose", flag=true)
    @Description(value="Enables print verbose information, default value false.")
    public void setVerbosee(boolean verbose) {
        this.verbose = verbose;
    }

    protected abstract Matcher getClassNameMatcher();

    protected abstract Matcher getClassNameExcludeMatcher();

    protected abstract Matcher getMethodNameMatcher();

    protected abstract AdviceListener getAdviceListener(CommandProcess var1);

    AdviceListener getAdviceListenerWithId(CommandProcess process) {
        AdviceListener listener;
        if (this.listenerId != 0L && (listener = AdviceWeaver.listener(this.listenerId)) != null) {
            return listener;
        }
        return this.getAdviceListener(process);
    }

    @Override
    public void process(CommandProcess process) {
        process.interruptHandler(new CommandInterruptHandler(process));
        process.stdinHandler(new QExitHandler(process));
        this.enhance(process);
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!CompletionUtils.completeClassName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!CompletionUtils.completeMethodName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 3) {
            this.completeArgument3(completion);
            return;
        }
        super.complete(completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enhance(CommandProcess process) {
        Session session = process.session();
        if (!session.tryLock()) {
            String msg = "someone else is enhancing classes, pls. wait.";
            process.appendResult(new EnhancerModel(null, false, msg));
            process.end(-1, msg);
            return;
        }
        EnhancerAffect effect = null;
        int lock = session.getLock();
        try {
            Instrumentation inst = session.getInstrumentation();
            AdviceListener listener = this.getAdviceListenerWithId(process);
            if (listener == null) {
                logger.error("advice listener is null");
                String msg = "advice listener is null, check arthas log";
                process.appendResult(new EnhancerModel(effect, false, msg));
                process.end(-1, msg);
                return;
            }
            boolean skipJDKTrace = false;
            if (listener instanceof AbstractTraceAdviceListener) {
                skipJDKTrace = ((AbstractTraceAdviceListener)listener).getCommand().isSkipJDKTrace();
            }
            Enhancer enhancer = new Enhancer(listener, listener instanceof InvokeTraceable, skipJDKTrace, this.getClassNameMatcher(), this.getClassNameExcludeMatcher(), this.getMethodNameMatcher());
            process.register(listener, enhancer);
            effect = enhancer.enhance(inst);
            if (effect.getThrowable() != null) {
                String msg = "error happens when enhancing class: " + effect.getThrowable().getMessage();
                process.appendResult(new EnhancerModel(effect, false, msg));
                process.end(1, msg + ", check arthas log: " + LogUtil.loggingFile());
                return;
            }
            if (effect.cCnt() == 0 || effect.mCnt() == 0) {
                process.appendResult(new EnhancerModel(effect, false, "No class or method is affected"));
                String smCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("sm CLASS_NAME METHOD_NAME").reset().toString();
                String optionsCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("options unsafe true").reset().toString();
                String javaPackage = Ansi.ansi().fg(Ansi.Color.GREEN).a("java.*").reset().toString();
                String resetCommand = Ansi.ansi().fg(Ansi.Color.GREEN).a("reset CLASS_NAME").reset().toString();
                String logStr = Ansi.ansi().fg(Ansi.Color.GREEN).a(LogUtil.loggingFile()).reset().toString();
                String issueStr = Ansi.ansi().fg(Ansi.Color.GREEN).a("https://github.com/alibaba/arthas/issues/47").reset().toString();
                String msg = "No class or method is affected, try:\n1. Execute `" + smCommand + "` to make sure the method you are tracing actually exists (it might be in your parent class).\n2. Execute `" + optionsCommand + "`, if you want to enhance the classes under the `" + javaPackage + "` package.\n3. Execute `" + resetCommand + "` and try again, your method body might be too large.\n4. Match the constructor, use `<init>`, for example: `watch demo.MathGame <init>`\n5. Check arthas log: " + logStr + "\n6. Visit " + issueStr + " for more details.";
                process.end(-1, msg);
                return;
            }
            if (session.getLock() == lock && process.isForeground()) {
                process.echoTips("Press Q or Ctrl+C to abort.\n");
            }
            process.appendResult(new EnhancerModel(effect, true));
        }
        catch (Throwable e) {
            String msg = "error happens when enhancing class: " + e.getMessage();
            logger.error(msg, e);
            process.appendResult(new EnhancerModel(effect, false, msg));
            process.end(-1, msg);
        }
        finally {
            if (session.getLock() == lock) {
                process.session().unLock();
            }
        }
    }

    protected void completeArgument3(Completion completion) {
        super.complete(completion);
    }

    public String getExcludeClassPattern() {
        return this.excludeClassPattern;
    }
}

