/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.core.command.model.Base64Model;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Name(value="base64")
@Summary(value="Encode and decode using Base64 representation")
@Description(value="\nEXAMPLES:\n  base64 /tmp/test.txt\n  base64 --input /tmp/test.txt --output /tmp/result.txt\n  base64 -d /tmp/result.txt\n\nWIKI:\n  https://arthas.aliyun.com/doc/base64")
public class Base64Command
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(Base64Command.class);
    private String file;
    private Integer sizeLimit = 131072;
    private int maxSizeLimit = 0x800000;
    private boolean decode;
    private String input;
    private String output;

    @Argument(argName="file", index=0, required=false)
    @Description(value="file")
    public void setFiles(String file) {
        this.file = file;
    }

    @Option(shortName="d", longName="decode", flag=true)
    @Description(value="decodes input")
    public void setDecode(boolean decode) {
        this.decode = decode;
    }

    @Option(shortName="i", longName="input")
    @Description(value="input file")
    public void setInput(String input) {
        this.input = input;
    }

    @Option(shortName="o", longName="output")
    @Description(value="output file")
    public void setOutput(String output) {
        this.output = output;
    }

    @Option(shortName="M", longName="sizeLimit")
    @Description(value="Upper size limit in bytes for the result (128 * 1024 by default, the maximum value is 8 * 1024 * 1024)")
    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        FileInputStream input;
        block10: {
            File f;
            if (!this.verifyOptions(process)) {
                return;
            }
            if (this.file == null && this.input != null) {
                this.file = this.input;
            }
            if (!(f = new File(this.file)).exists()) {
                process.end(-1, this.file + ": No such file or directory");
                return;
            }
            if (f.isDirectory()) {
                process.end(-1, this.file + ": Is a directory");
                return;
            }
            if (f.length() > (long)this.sizeLimit.intValue()) {
                process.end(-1, this.file + ": Is too large, size: " + f.length());
                return;
            }
            input = null;
            try {
                input = new FileInputStream(f);
                byte[] bytes = IOUtils.getBytes((InputStream)input);
                ByteBuf convertResult = null;
                convertResult = this.decode ? Base64.decode((ByteBuf)Unpooled.wrappedBuffer((byte[])bytes)) : Base64.encode((ByteBuf)Unpooled.wrappedBuffer((byte[])bytes));
                if (this.output != null) {
                    int readableBytes = convertResult.readableBytes();
                    FileOutputStream out = new FileOutputStream(this.output);
                    convertResult.readBytes((OutputStream)out, readableBytes);
                    process.appendResult(new Base64Model(null));
                    break block10;
                }
                String base64Str = convertResult.toString(CharsetUtil.UTF_8);
                process.appendResult(new Base64Model(base64Str));
            }
            catch (IOException e) {
                try {
                    logger.error("read file error. name: " + this.file, (Throwable)e);
                    process.end(1, "read file error: " + e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
                IOUtils.close((InputStream)input);
                return;
            }
        }
        IOUtils.close((InputStream)input);
        process.end();
    }

    private boolean verifyOptions(CommandProcess process) {
        if (this.file == null && this.input == null) {
            process.end(-1);
            return false;
        }
        if (this.sizeLimit > this.maxSizeLimit) {
            process.end(-1, "sizeLimit cannot be large than: " + this.maxSizeLimit);
            return false;
        }
        int maxSizeLimitOfNonTty = 131072;
        if (!process.session().isTty() && this.sizeLimit > maxSizeLimitOfNonTty) {
            process.end(-1, "When executing in non-tty session, sizeLimit cannot be large than: " + maxSizeLimitOfNonTty);
            return false;
        }
        return true;
    }

    @Override
    public void complete(Completion completion) {
        if (!CompletionUtils.completeFilePath(completion)) {
            super.complete(completion);
        }
    }
}

