/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.common.Pair;
import com.taobao.arthas.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.api.OutputSinkFactory;
import org.benf.cfr.reader.api.SinkReturns;

public class Decompiler {
    public static String decompile(String classFilePath, String methodName) {
        return Decompiler.decompile(classFilePath, methodName, false);
    }

    public static String decompile(String classFilePath, String methodName, boolean hideUnicode) {
        return Decompiler.decompile(classFilePath, methodName, hideUnicode, true);
    }

    public static Pair<String, NavigableMap<Integer, Integer>> decompileWithMappings(String classFilePath, String methodName, boolean hideUnicode, boolean printLineNumber) {
        final StringBuilder sb = new StringBuilder(8192);
        final TreeMap<Integer, Integer> lineMapping = new TreeMap<Integer, Integer>();
        OutputSinkFactory mySink = new OutputSinkFactory(){

            @Override
            public List<OutputSinkFactory.SinkClass> getSupportedSinks(OutputSinkFactory.SinkType sinkType, Collection<OutputSinkFactory.SinkClass> collection) {
                return Arrays.asList(OutputSinkFactory.SinkClass.STRING, OutputSinkFactory.SinkClass.DECOMPILED, OutputSinkFactory.SinkClass.DECOMPILED_MULTIVER, OutputSinkFactory.SinkClass.EXCEPTION_MESSAGE, OutputSinkFactory.SinkClass.LINE_NUMBER_MAPPING);
            }

            @Override
            public <T> OutputSinkFactory.Sink<T> getSink(final OutputSinkFactory.SinkType sinkType, OutputSinkFactory.SinkClass sinkClass) {
                return new OutputSinkFactory.Sink<T>(){

                    @Override
                    public void write(T sinkable) {
                        if (sinkType == OutputSinkFactory.SinkType.PROGRESS) {
                            return;
                        }
                        if (sinkType == OutputSinkFactory.SinkType.LINENUMBER) {
                            SinkReturns.LineNumberMapping mapping = (SinkReturns.LineNumberMapping)sinkable;
                            NavigableMap<Integer, Integer> classFileMappings = mapping.getClassFileMappings();
                            NavigableMap<Integer, Integer> mappings = mapping.getMappings();
                            if (classFileMappings != null && mappings != null) {
                                for (Map.Entry entry : mappings.entrySet()) {
                                    Integer srcLineNumber = (Integer)classFileMappings.get(entry.getKey());
                                    lineMapping.put(entry.getValue(), srcLineNumber);
                                }
                            }
                            return;
                        }
                        sb.append(sinkable);
                    }
                };
            }
        };
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("showversion", "false");
        options.put("hideutf", String.valueOf(hideUnicode));
        options.put("trackbytecodeloc", "true");
        if (!StringUtils.isBlank(methodName)) {
            options.put("methodname", methodName);
        }
        CfrDriver driver = new CfrDriver.Builder().withOptions(options).withOutputSink(mySink).build();
        ArrayList<String> toAnalyse = new ArrayList<String>();
        toAnalyse.add(classFilePath);
        driver.analyse(toAnalyse);
        String resultCode = sb.toString();
        if (printLineNumber && !lineMapping.isEmpty()) {
            resultCode = Decompiler.addLineNumber(resultCode, lineMapping);
        }
        return Pair.make((Object)resultCode, lineMapping);
    }

    public static String decompile(String classFilePath, String methodName, boolean hideUnicode, boolean printLineNumber) {
        return (String)Decompiler.decompileWithMappings(classFilePath, methodName, hideUnicode, printLineNumber).getFirst();
    }

    private static String addLineNumber(String src, Map<Integer, Integer> lineMapping) {
        int maxLineNumber = 0;
        for (Integer value : lineMapping.values()) {
            if (value == null || value <= maxLineNumber) continue;
            maxLineNumber = value;
        }
        String formatStr = "/*%2d*/ ";
        String emptyStr = "       ";
        StringBuilder sb = new StringBuilder();
        String[] lines = src.split("\\R");
        if (maxLineNumber >= 100) {
            formatStr = "/*%3d*/ ";
            emptyStr = "        ";
        } else if (maxLineNumber >= 1000) {
            formatStr = "/*%4d*/ ";
            emptyStr = "         ";
        }
        for (int i = 0; i < lines.length; ++i) {
            Integer srcLineNumber = lineMapping.get(i + 1);
            if (srcLineNumber != null) {
                sb.append(String.format(formatStr, srcLineNumber));
            } else {
                sb.append(emptyStr);
            }
            sb.append(lines[i]).append("\n");
        }
        return sb.toString();
    }
}

