/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.command.model.BlockingLockInfo;
import com.taobao.arthas.core.command.model.BusyThreadInfo;
import com.taobao.arthas.core.command.model.ThreadModel;
import com.taobao.arthas.core.command.model.ThreadVO;
import com.taobao.arthas.core.command.monitor200.ThreadSampler;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.command.ExitStatus;
import com.taobao.arthas.core.util.ArrayUtils;
import com.taobao.arthas.core.util.CommandUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Name(value="thread")
@Summary(value="Display thread info, thread stack")
@Description(value="\nEXAMPLES:\n  thread\n  thread 51\n  thread -n -1\n  thread -n 5\n  thread -b\n  thread -i 2000\n  thread --state BLOCKED\n\nWIKI:\n  https://arthas.aliyun.com/doc/thread")
public class ThreadCommand
extends AnnotatedCommand {
    private static Set<String> states = null;
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private long id = -1L;
    private Integer topNBusy = null;
    private boolean findMostBlockingThread = false;
    private int sampleInterval = 200;
    private String state;
    private boolean lockedMonitors = false;
    private boolean lockedSynchronizers = false;
    private boolean all = false;

    @Argument(index=0, required=false, argName="id")
    @Description(value="Show thread stack")
    public void setId(long id) {
        this.id = id;
    }

    @Option(longName="all", flag=true)
    @Description(value="Display all thread results instead of the first page")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Option(shortName="n", longName="top-n-threads")
    @Description(value="The number of thread(s) to show, ordered by cpu utilization, -1 to show all.")
    public void setTopNBusy(Integer topNBusy) {
        this.topNBusy = topNBusy;
    }

    @Option(shortName="b", longName="include-blocking-thread", flag=true)
    @Description(value="Find the thread who is holding a lock that blocks the most number of threads.")
    public void setFindMostBlockingThread(boolean findMostBlockingThread) {
        this.findMostBlockingThread = findMostBlockingThread;
    }

    @Option(shortName="i", longName="sample-interval")
    @Description(value="Specify the sampling interval (in ms) when calculating cpu usage.")
    public void setSampleInterval(int sampleInterval) {
        this.sampleInterval = sampleInterval;
    }

    @Option(longName="state")
    @Description(value="Display the thead filter by the state. NEW, RUNNABLE, TIMED_WAITING, WAITING, BLOCKED, TERMINATED is optional.")
    public void setState(String state) {
        this.state = state;
    }

    @Option(longName="lockedMonitors", flag=true)
    @Description(value="Find the thread info with lockedMonitors flag, default value is false.")
    public void setLockedMonitors(boolean lockedMonitors) {
        this.lockedMonitors = lockedMonitors;
    }

    @Option(longName="lockedSynchronizers", flag=true)
    @Description(value="Find the thread info with lockedSynchronizers flag, default value is false.")
    public void setLockedSynchronizers(boolean lockedSynchronizers) {
        this.lockedSynchronizers = lockedSynchronizers;
    }

    @Override
    public void process(CommandProcess process) {
        ExitStatus exitStatus = this.id > 0L ? this.processThread(process) : (this.topNBusy != null ? this.processTopBusyThreads(process) : (this.findMostBlockingThread ? this.processBlockingThread(process) : this.processAllThreads(process)));
        CommandUtils.end(process, exitStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExitStatus processAllThreads(CommandProcess process) {
        List<ThreadVO> threads = ThreadUtil.getThreads();
        LinkedHashMap<Thread.State, Integer> stateCountMap = new LinkedHashMap<Thread.State, Integer>();
        for (Thread.State s : Thread.State.values()) {
            stateCountMap.put(s, 0);
        }
        for (ThreadVO thread : threads) {
            Thread.State threadState = thread.getState();
            Integer count = (Integer)stateCountMap.get((Object)threadState);
            stateCountMap.put(threadState, count + 1);
        }
        boolean includeInternalThreads = true;
        ArrayList<ThreadVO> resultThreads = new ArrayList();
        if (!StringUtils.isEmpty(this.state)) {
            this.state = this.state.toUpperCase();
            if (!states.contains(this.state)) return ExitStatus.failure(1, "Illegal argument, state should be one of " + states);
            includeInternalThreads = false;
            for (ThreadVO thread : threads) {
                if (thread.getState() == null || !this.state.equals(thread.getState().name())) continue;
                resultThreads.add(thread);
            }
        } else {
            resultThreads = threads;
        }
        ThreadSampler threadSampler = new ThreadSampler();
        threadSampler.setIncludeInternalThreads(includeInternalThreads);
        threadSampler.sample(resultThreads);
        threadSampler.pause(this.sampleInterval);
        List<ThreadVO> threadStats = threadSampler.sample(resultThreads);
        process.appendResult(new ThreadModel(threadStats, stateCountMap, this.all));
        return ExitStatus.success();
    }

    private ExitStatus processBlockingThread(CommandProcess process) {
        BlockingLockInfo blockingLockInfo = ThreadUtil.findMostBlockingLock();
        if (blockingLockInfo.getThreadInfo() == null) {
            return ExitStatus.failure(1, "No most blocking thread found!");
        }
        process.appendResult(new ThreadModel(blockingLockInfo));
        return ExitStatus.success();
    }

    private ExitStatus processTopBusyThreads(CommandProcess process) {
        ThreadSampler threadSampler = new ThreadSampler();
        threadSampler.sample(ThreadUtil.getThreads());
        threadSampler.pause(this.sampleInterval);
        List<ThreadVO> threadStats = threadSampler.sample(ThreadUtil.getThreads());
        int limit = Math.min(threadStats.size(), this.topNBusy);
        List<ThreadVO> topNThreads = threadStats.subList(0, limit);
        ArrayList<Long> tids = new ArrayList<Long>(topNThreads.size());
        for (ThreadVO thread : topNThreads) {
            if (thread.getId() <= 0L) continue;
            tids.add(thread.getId());
        }
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(ArrayUtils.toPrimitive(tids.toArray(new Long[0])), this.lockedMonitors, this.lockedSynchronizers);
        if (tids.size() > 0 && threadInfos == null) {
            return ExitStatus.failure(1, "get top busy threads failed");
        }
        ArrayList<BusyThreadInfo> busyThreadInfos = new ArrayList<BusyThreadInfo>(topNThreads.size());
        for (ThreadVO thread : topNThreads) {
            ThreadInfo threadInfo = this.findThreadInfoById(threadInfos, thread.getId());
            BusyThreadInfo busyThread = new BusyThreadInfo(thread, threadInfo);
            busyThreadInfos.add(busyThread);
        }
        process.appendResult(new ThreadModel(busyThreadInfos));
        return ExitStatus.success();
    }

    private ThreadInfo findThreadInfoById(ThreadInfo[] threadInfos, long id) {
        for (int i = 0; i < threadInfos.length; ++i) {
            ThreadInfo threadInfo = threadInfos[i];
            if (threadInfo.getThreadId() != id) continue;
            return threadInfo;
        }
        return null;
    }

    private ExitStatus processThread(CommandProcess process) {
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(new long[]{this.id}, this.lockedMonitors, this.lockedSynchronizers);
        if (threadInfos == null || threadInfos.length < 1 || threadInfos[0] == null) {
            return ExitStatus.failure(1, "thread do not exist! id: " + this.id);
        }
        process.appendResult(new ThreadModel(threadInfos[0]));
        return ExitStatus.success();
    }

    static {
        states = new HashSet<String>(Thread.State.values().length);
        for (Thread.State state : Thread.State.values()) {
            states.add(state.name());
        }
    }
}

