/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.OSUtils;
import com.taobao.arthas.core.command.model.ProfilerModel;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import one.profiler.AsyncProfiler;
import one.profiler.Counter;

@Name(value="profiler")
@Summary(value="Async Profiler. https://github.com/jvm-profiling-tools/async-profiler")
@Description(value="\nEXAMPLES:\n  profiler start\n  profiler stop\n  profiler list                # list all supported events\n  profiler actions             # list all supported actions\n  profiler start --event alloc\n  profiler stop --format svg   # output file format, support svg,html,jfr\n  profiler stop --file /tmp/result.html\n  profiler stop --threads \n  profiler start --include 'java/*' --include 'demo/*' --exclude '*Unsafe.park*'\n  profiler status\n  profiler resume              # Start or resume profiling without resetting collected data.\n  profiler getSamples          # Get the number of samples collected during the profiling session\n  profiler dumpFlat            # Dump flat profile, i.e. the histogram of the hottest methods\n  profiler dumpCollapsed       # Dump profile in 'collapsed stacktraces' format\n  profiler dumpTraces          # Dump collected stack traces\n  profiler execute 'start,framebuf=5000000'      # Execute an agent-compatible profiling command\n  profiler execute 'stop,file=/tmp/result.svg'   # Execute an agent-compatible profiling command\n\nWIKI:\n  https://arthas.aliyun.com/doc/profiler")
public class ProfilerCommand
extends AnnotatedCommand {
    private static final Logger logger;
    private String action;
    private String actionArg;
    private String event;
    private String file;
    private String format;
    private Long interval;
    private Long framebuf;
    private boolean threads;
    private boolean allkernel;
    private boolean alluser;
    private Long duration;
    private List<String> includes;
    private List<String> excludes;
    private static String libPath;
    private static AsyncProfiler profiler;

    @Argument(argName="action", index=0, required=true)
    @Description(value="Action to execute")
    public void setAction(String action) {
        this.action = action;
    }

    @Argument(argName="actionArg", index=1, required=false)
    @Description(value="Attribute name pattern.")
    public void setActionArg(String actionArg) {
        this.actionArg = actionArg;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="sampling interval in ns (default: 10'000'000, i.e. 10 ms)")
    @DefaultValue(value="10000000")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Option(shortName="b", longName="framebuf")
    @Description(value="size of the buffer for stack frames (default: 1'000'000)")
    @DefaultValue(value="1000000")
    public void setFramebuf(long framebuf) {
        this.framebuf = framebuf;
    }

    @Option(shortName="f", longName="file")
    @Description(value="dump output to <filename>")
    public void setFile(String file) {
        this.file = file;
    }

    @Option(longName="format")
    @Description(value="dump output file format(svg, html, jfr), default valut is svg")
    @DefaultValue(value="svg")
    public void setFormat(String format) {
        this.format = format;
    }

    @Option(shortName="e", longName="event")
    @Description(value="which event to trace (cpu, alloc, lock, cache-misses etc.), default value is cpu")
    @DefaultValue(value="cpu")
    public void setEvent(String event) {
        this.event = event;
    }

    @Option(longName="threads", flag=true)
    @Description(value="profile different threads separately")
    public void setThreads(boolean threads) {
        this.threads = threads;
    }

    @Option(longName="allkernel", flag=true)
    @Description(value="include only kernel-mode events")
    public void setAllkernel(boolean allkernel) {
        this.allkernel = allkernel;
    }

    @Option(longName="alluser", flag=true)
    @Description(value="include only user-mode events")
    public void setAlluser(boolean alluser) {
        this.alluser = alluser;
    }

    @Option(shortName="d", longName="duration")
    @Description(value="run profiling for <duration> seconds")
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Option(longName="include")
    @Description(value="include stack traces containing PATTERN, for example: 'java/*'")
    public void setInclude(List<String> includes) {
        this.includes = includes;
    }

    @Option(longName="exclude")
    @Description(value="exclude stack traces containing PATTERN, for example: '*Unsafe.park*'")
    public void setExclude(List<String> excludes) {
        this.excludes = excludes;
    }

    private AsyncProfiler profilerInstance() {
        if (profiler != null) {
            return profiler;
        }
        if (ProfilerAction.load.toString().equals(this.action)) {
            profiler = AsyncProfiler.getInstance((String)this.actionArg);
        }
        if (libPath == null) {
            if (OSUtils.isLinux() || OSUtils.isMac()) {
                throw new IllegalStateException("Can not find libasyncProfiler so, please check the arthas directory.");
            }
            throw new IllegalStateException("Current OS do not support AsyncProfiler, Only support Linux/Mac.");
        }
        profiler = AsyncProfiler.getInstance((String)libPath);
        return profiler;
    }

    private String executeArgs(ProfilerAction action) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)action).append(',');
        if (this.event != null) {
            sb.append("event=").append(this.event).append(',');
        }
        if (this.file != null) {
            sb.append("file=").append(this.file).append(',');
        }
        if (this.interval != null) {
            sb.append("interval=").append(this.interval).append(',');
        }
        if (this.framebuf != null) {
            sb.append("framebuf=").append(this.framebuf).append(',');
        }
        if (this.threads) {
            sb.append("threads").append(',');
        }
        if (this.allkernel) {
            sb.append("allkernel").append(',');
        }
        if (this.alluser) {
            sb.append("alluser").append(',');
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                sb.append("include=").append(include).append(',');
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                sb.append("exclude=").append(exclude).append(',');
            }
        }
        return sb.toString();
    }

    private static String execute(AsyncProfiler asyncProfiler, String arg) throws IllegalArgumentException, IOException {
        String result = asyncProfiler.execute(arg);
        if (!result.endsWith("\n")) {
            result = result + "\n";
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(CommandProcess process) {
        try {
            ProfilerAction profilerAction = ProfilerAction.valueOf(this.action);
            if (ProfilerAction.actions.equals((Object)profilerAction)) {
                process.appendResult(new ProfilerModel(this.actions()));
                process.end();
                return;
            }
            final AsyncProfiler asyncProfiler = this.profilerInstance();
            if (ProfilerAction.execute.equals((Object)profilerAction)) {
                if (this.actionArg == null) {
                    process.end(1, "actionArg can not be empty.");
                    return;
                }
                String result = ProfilerCommand.execute(asyncProfiler, this.actionArg);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.start.equals((Object)profilerAction)) {
                if (this.file == null && "jfr".equals(this.format)) {
                    this.file = this.outputFile();
                }
                String executeArgs = this.executeArgs(ProfilerAction.start);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                ProfilerModel profilerModel = this.createProfilerModel(result);
                if (this.duration != null) {
                    String outputFile = this.outputFile();
                    profilerModel.setOutputFile(outputFile);
                    profilerModel.setDuration(this.duration);
                    ArthasBootstrap.getInstance().getScheduledExecutorService().schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                logger.info("stopping profiler ...");
                                ProfilerModel model = ProfilerCommand.this.processStop(asyncProfiler);
                                logger.info("profiler output file: " + model.getOutputFile());
                                logger.info("stop profiler successfully.");
                            }
                            catch (Throwable e) {
                                logger.error("stop profiler failure", e);
                            }
                        }
                    }, (long)this.duration, TimeUnit.SECONDS);
                }
                process.appendResult(profilerModel);
            } else if (ProfilerAction.stop.equals((Object)profilerAction)) {
                ProfilerModel profilerModel = this.processStop(asyncProfiler);
                process.appendResult(profilerModel);
            } else if (ProfilerAction.resume.equals((Object)profilerAction)) {
                String executeArgs = this.executeArgs(ProfilerAction.resume);
                String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.list.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute("list");
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.version.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute("version");
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.status.equals((Object)profilerAction)) {
                String result = asyncProfiler.execute("status");
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.dumpCollapsed.equals((Object)profilerAction)) {
                if (this.actionArg == null) {
                    this.actionArg = "TOTAL";
                }
                this.actionArg = this.actionArg.toUpperCase();
                if (!"TOTAL".equals(this.actionArg) && !"SAMPLES".equals(this.actionArg)) {
                    process.end(1, "ERROR: dumpCollapsed argumment should be TOTAL or SAMPLES. ");
                    return;
                }
                String result = asyncProfiler.dumpCollapsed(Counter.valueOf((String)this.actionArg));
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.dumpFlat.equals((Object)profilerAction)) {
                int maxMethods = 0;
                if (this.actionArg != null) {
                    maxMethods = Integer.valueOf(this.actionArg);
                }
                String result = asyncProfiler.dumpFlat(maxMethods);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.dumpTraces.equals((Object)profilerAction)) {
                int maxTraces = 0;
                if (this.actionArg != null) {
                    maxTraces = Integer.valueOf(this.actionArg);
                }
                String result = asyncProfiler.dumpTraces(maxTraces);
                this.appendExecuteResult(process, result);
            } else if (ProfilerAction.getSamples.equals((Object)profilerAction)) {
                String result = "" + asyncProfiler.getSamples() + "\n";
                this.appendExecuteResult(process, result);
            }
            process.end();
            return;
        }
        catch (Throwable e) {
            logger.error("AsyncProfiler error", e);
            process.end(1, "AsyncProfiler error: " + e.getMessage());
        }
    }

    private ProfilerModel processStop(AsyncProfiler asyncProfiler) throws IOException {
        String outputFile = this.outputFile();
        String executeArgs = this.executeArgs(ProfilerAction.stop);
        String result = ProfilerCommand.execute(asyncProfiler, executeArgs);
        ProfilerModel profilerModel = this.createProfilerModel(result);
        profilerModel.setOutputFile(outputFile);
        return profilerModel;
    }

    private String outputFile() {
        if (this.file == null) {
            this.file = new File("arthas-output", new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + this.format).getAbsolutePath();
        }
        return this.file;
    }

    private void appendExecuteResult(CommandProcess process, String result) {
        ProfilerModel profilerModel = this.createProfilerModel(result);
        process.appendResult(profilerModel);
    }

    private ProfilerModel createProfilerModel(String result) {
        ProfilerModel profilerModel = new ProfilerModel();
        profilerModel.setAction(this.action);
        profilerModel.setActionArg(this.actionArg);
        profilerModel.setExecuteResult(result);
        return profilerModel;
    }

    private List<String> events() {
        String execute;
        ArrayList<String> result = new ArrayList<String>();
        try {
            execute = this.profilerInstance().execute("list");
        }
        catch (Throwable e) {
            return result;
        }
        String[] lines = execute.split("\\r?\\n");
        if (lines != null) {
            for (String line : lines) {
                if (!line.startsWith(" ")) continue;
                result.add(line.trim());
            }
        }
        return result;
    }

    private Set<String> actions() {
        HashSet<String> values = new HashSet<String>();
        for (ProfilerAction action : ProfilerAction.values()) {
            values.add(action.toString());
        }
        return values;
    }

    @Override
    public void complete(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String token = tokens.get(tokens.size() - 1).value();
        if (tokens.size() >= 2) {
            CliToken cliToken_1 = tokens.get(tokens.size() - 1);
            CliToken cliToken_2 = tokens.get(tokens.size() - 2);
            if (cliToken_1.isBlank()) {
                String token_2 = cliToken_2.value();
                if (token_2.equals("-e") || token_2.equals("--event")) {
                    CompletionUtils.complete(completion, this.events());
                    return;
                }
                if (token_2.equals("-f") || token_2.equals("--format")) {
                    CompletionUtils.complete(completion, Arrays.asList("svg", "html", "jfr"));
                    return;
                }
            }
        }
        if (token.startsWith("-")) {
            super.complete(completion);
            return;
        }
        CompletionUtils.complete(completion, this.actions());
    }

    static {
        CodeSource codeSource;
        logger = LoggerFactory.getLogger(ProfilerCommand.class);
        profiler = null;
        String profierSoPath = null;
        if (OSUtils.isMac()) {
            profierSoPath = "async-profiler/libasyncProfiler-mac-x64.so";
        }
        if (OSUtils.isLinux()) {
            profierSoPath = "async-profiler/libasyncProfiler-linux-x64.so";
            if (OSUtils.isArm32()) {
                profierSoPath = "async-profiler/libasyncProfiler-linux-arm.so";
            } else if (OSUtils.isArm64()) {
                profierSoPath = "async-profiler/libasyncProfiler-linux-aarch64.so";
            }
        }
        if (profierSoPath != null && (codeSource = ProfilerCommand.class.getProtectionDomain().getCodeSource()) != null) {
            try {
                File bootJarPath = new File(codeSource.getLocation().toURI().getSchemeSpecificPart());
                File soFile = new File(bootJarPath.getParentFile(), profierSoPath);
                if (soFile.exists()) {
                    libPath = soFile.getAbsolutePath();
                }
            }
            catch (Throwable e) {
                logger.error("can not find libasyncProfiler so", e);
            }
        }
    }

    public static enum ProfilerAction {
        execute,
        start,
        stop,
        resume,
        list,
        version,
        status,
        load,
        dumpCollapsed,
        dumpFlat,
        dumpTraces,
        getSamples,
        actions;

    }
}

