/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import com.taobao.arthas.core.command.model.ClassLoaderVO;
import com.taobao.arthas.core.command.model.RedefineModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassLoaderUtils;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Name(value="redefine")
@Summary(value="Redefine classes. @see Instrumentation#redefineClasses(ClassDefinition...)")
@Description(value="\nEXAMPLES:\n  redefine /tmp/Test.class\n  redefine -c 327a647b /tmp/Test.class /tmp/Test\\$Inner.class \n\nWIKI:\n  https://arthas.aliyun.com/doc/redefine")
public class RedefineCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(RedefineCommand.class);
    private static final int MAX_FILE_SIZE = 0xA00000;
    private String hashCode;
    private String classLoaderClass;
    private List<String> paths;

    @Option(shortName="c", longName="classloader")
    @Description(value="classLoader hashcode")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Option(longName="classLoaderClass")
    @Description(value="The class name of the special class's classLoader.")
    public void setClassLoaderClass(String classLoaderClass) {
        this.classLoaderClass = classLoaderClass;
    }

    @Argument(argName="classfilePaths", index=0)
    @Description(value=".class file paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        RedefineModel redefineModel = new RedefineModel();
        Instrumentation inst = process.session().getInstrumentation();
        for (String string : this.paths) {
            File file = new File(string);
            if (!file.exists()) {
                process.end(-1, "file does not exist, path:" + string);
                return;
            }
            if (!file.isFile()) {
                process.end(-1, "not a normal file, path:" + string);
                return;
            }
            if (file.length() < 0xA00000L) continue;
            process.end(-1, "file size: " + file.length() + " >= " + 0xA00000 + ", path: " + string);
            return;
        }
        HashMap<String, byte[]> bytesMap = new HashMap<String, byte[]>();
        for (String string : this.paths) {
            RandomAccessFile f = null;
            try {
                f = new RandomAccessFile(string, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                String clazzName = RedefineCommand.readClassName(bytes);
                bytesMap.put(clazzName, bytes);
            }
            catch (Exception e) {
                logger.warn("load class file failed: " + string, (Throwable)e);
                process.end(-1, "load class file failed: " + string + ", error: " + e);
                return;
            }
            finally {
                if (f == null) continue;
                try {
                    f.close();
                }
                catch (IOException clazzName) {}
            }
        }
        if (bytesMap.size() != this.paths.size()) {
            process.end(-1, "paths may contains same class name!");
            return;
        }
        ArrayList<ClassDefinition> arrayList = new ArrayList<ClassDefinition>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader;
            if (!bytesMap.containsKey(clazz.getName())) continue;
            if (this.hashCode == null && this.classLoaderClass != null) {
                List<ClassLoader> matchedClassLoaders = ClassLoaderUtils.getClassLoaderByClassName(inst, this.classLoaderClass);
                if (matchedClassLoaders.size() == 1) {
                    this.hashCode = Integer.toHexString(matchedClassLoaders.get(0).hashCode());
                } else {
                    if (matchedClassLoaders.size() > 1) {
                        List<ClassLoaderVO> classLoaderVOList = ClassUtils.createClassLoaderVOList(matchedClassLoaders);
                        RedefineModel classredefineModel = new RedefineModel().setClassLoaderClass(this.classLoaderClass).setMatchedClassLoaders(classLoaderVOList);
                        process.appendResult(classredefineModel);
                        process.end(-1, "Found more than one classloader by class name, please specify classloader with '-c <classloader hash>'");
                        return;
                    }
                    process.end(-1, "Can not find classloader by class name: " + this.classLoaderClass + ".");
                    return;
                }
            }
            if ((classLoader = clazz.getClassLoader()) != null && this.hashCode != null && !Integer.toHexString(classLoader.hashCode()).equals(this.hashCode)) continue;
            arrayList.add(new ClassDefinition(clazz, (byte[])bytesMap.get(clazz.getName())));
            redefineModel.addRedefineClass(clazz.getName());
            logger.info("Try redefine class name: {}, ClassLoader: {}", (Object)clazz.getName(), (Object)clazz.getClassLoader());
        }
        try {
            if (arrayList.isEmpty()) {
                process.end(-1, "These classes are not found in the JVM and may not be loaded: " + bytesMap.keySet());
                return;
            }
            inst.redefineClasses(arrayList.toArray(new ClassDefinition[0]));
            process.appendResult(redefineModel);
            process.end();
        }
        catch (Throwable throwable) {
            String message = "redefine error! " + throwable.toString();
            logger.error(message, throwable);
            process.end(-1, message);
        }
    }

    private static String readClassName(byte[] bytes) {
        return new ClassReader(bytes).getClassName().replace("/", ".");
    }

    @Override
    public void complete(Completion completion) {
        if (!CompletionUtils.completeFilePath(completion)) {
            super.complete(completion);
        }
    }
}

