/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.term.impl.Helper;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

@Name(value="keymap")
@Summary(value="Display all the available keymap for the specified connection.")
@Description(value="\nWIKI:\n  https://arthas.aliyun.com/doc/keymap")
public class KeymapCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(KeymapCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        if (!process.session().isTty()) {
            process.end(-1, "Command 'keymap' is only support tty session.");
            return;
        }
        InputStream inputrc = Helper.loadInputRcFile();
        try {
            String line;
            TableElement table = new TableElement(new int[]{1, 1, 2}).leftCellPadding(1).rightCellPadding(1);
            table.row(true, new Element[]{Element.label((String)"Shortcut").style(Decoration.bold.bold()), Element.label((String)"Description").style(Decoration.bold.bold()), Element.label((String)"Name").style(Decoration.bold.bold())});
            BufferedReader br = new BufferedReader(new InputStreamReader(inputrc));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || "".equals(line)) continue;
                String[] strings = line.split(":");
                if (strings != null && strings.length == 2) {
                    table.row(new String[]{strings[0], this.translate(strings[0]), strings[1]});
                    continue;
                }
                table.row(new String[]{line});
            }
            process.write(RenderUtil.render((Element)table, (int)process.width()));
        }
        catch (IOException e) {
            logger.error("read inputrc file error.", (Throwable)e);
        }
        finally {
            IOUtils.close((InputStream)inputrc);
            process.end();
        }
    }

    private String translate(String key) {
        char ch;
        if (key.length() == 6 && key.startsWith("\"\\C-") && key.endsWith("\"") && ((ch = key.charAt(4)) >= 'a' && ch <= 'z' || ch == '?')) {
            return "Ctrl + " + ch;
        }
        if (key.equals("\"\\e[D\"")) {
            return "Left arrow";
        }
        if (key.equals("\"\\e[C\"")) {
            return "Right arrow";
        }
        if (key.equals("\"\\e[B\"")) {
            return "Down arrow";
        }
        if (key.equals("\"\\e[A\"")) {
            return "Up arrow";
        }
        return key;
    }
}

