/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.ChangeResultVO;
import com.taobao.arthas.core.command.model.EnhancerAffectVO;
import com.taobao.arthas.core.command.model.ThreadVO;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Style;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.Overflow;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class ViewRenderUtil {
    public static final EnumMap<Thread.State, Color> colorMapping = new EnumMap(Thread.State.class);

    public static String renderKeyValueTable(Map<String, String> map, int width) {
        TableElement table = new TableElement(new int[]{1, 4}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"KEY").style(Decoration.bold.bold()), Element.label((String)"VALUE").style(Decoration.bold.bold())});
        for (Map.Entry<String, String> entry : map.entrySet()) {
            table.row(new String[]{entry.getKey(), entry.getValue()});
        }
        return RenderUtil.render((Element)table, (int)width);
    }

    public static TableElement renderChangeResult(ChangeResultVO result) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"NAME").style(Decoration.bold.bold()), Element.label((String)"BEFORE-VALUE").style(Decoration.bold.bold()), Element.label((String)"AFTER-VALUE").style(Decoration.bold.bold())});
        table.row(new String[]{result.getName(), StringUtils.objectToString(result.getBeforeValue()), StringUtils.objectToString(result.getAfterValue())});
        return table;
    }

    public static String renderEnhancerAffect(EnhancerAffectVO affectVO) {
        List<String> methods;
        StringBuilder infoSB = new StringBuilder();
        List<String> classDumpFiles = affectVO.getClassDumpFiles();
        if (classDumpFiles != null) {
            for (String classDumpFile : classDumpFiles) {
                infoSB.append("[dump: ").append(classDumpFile).append("]\n");
            }
        }
        if ((methods = affectVO.getMethods()) != null) {
            for (String method : methods) {
                infoSB.append("[Affect method: ").append(method).append("]\n");
            }
        }
        infoSB.append(String.format("Affect(class count: %d , method count: %d) cost in %s ms, listenerId: %d", affectVO.getClassCount(), affectVO.getMethodCount(), affectVO.getCost(), affectVO.getListenerId()));
        if (affectVO.getThrowable() != null) {
            infoSB.append("\nEnhance error! exception: " + affectVO.getThrowable());
        }
        infoSB.append("\n");
        return infoSB.toString();
    }

    public static String drawThreadInfo(List<ThreadVO> threads, int width, int height) {
        TableElement table = new TableElement(new int[]{1, 6, 3, 2, 2, 2, 2, 2, 2, 2}).overflow(Overflow.HIDDEN).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add(new String[]{"ID", "NAME", "GROUP", "PRIORITY", "STATE", "%CPU", "DELTA_TIME", "TIME", "INTERRUPTED", "DAEMON"}));
        for (ThreadVO thread : threads) {
            Color color = colorMapping.get((Object)thread.getState());
            String time = ViewRenderUtil.formatTimeMills(thread.getTime());
            String deltaTime = ViewRenderUtil.formatTimeMillsToSeconds(thread.getDeltaTime());
            double cpu = thread.getCpu();
            LabelElement daemonLabel = new LabelElement((Object)thread.isDaemon());
            if (!thread.isDaemon()) {
                daemonLabel.setStyle(Style.style((Color)Color.magenta));
            }
            LabelElement stateElement = thread.getState() != null ? new LabelElement((Object)thread.getState()).style(color.fg()) : new LabelElement("-");
            table.row(new Element[]{new LabelElement((Object)thread.getId()), new LabelElement(thread.getName()), new LabelElement(thread.getGroup() != null ? thread.getGroup() : "-"), new LabelElement((Object)thread.getPriority()), stateElement, new LabelElement((Object)cpu), new LabelElement(deltaTime), new LabelElement(time), new LabelElement((Object)thread.isInterrupted()), daemonLabel});
        }
        return RenderUtil.render((Element)table, (int)width, (int)height);
    }

    private static String formatTimeMills(long timeMills) {
        long seconds = timeMills / 1000L;
        long mills = timeMills % 1000L;
        long min = seconds / 60L;
        return String.format("%d:%d.%03d", min, seconds, mills);
    }

    private static String formatTimeMillsToSeconds(long timeMills) {
        long seconds = timeMills / 1000L;
        long mills = timeMills % 1000L;
        return String.format("%d.%03d", seconds, mills);
    }

    static {
        colorMapping.put(Thread.State.NEW, Color.cyan);
        colorMapping.put(Thread.State.RUNNABLE, Color.green);
        colorMapping.put(Thread.State.BLOCKED, Color.red);
        colorMapping.put(Thread.State.WAITING, Color.yellow);
        colorMapping.put(Thread.State.TIMED_WAITING, Color.magenta);
        colorMapping.put(Thread.State.TERMINATED, Color.blue);
    }
}

