/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.api.OutputSinkFactory;

public class Decompiler {
    public static String decompile(String classFilePath, String methodName) {
        return Decompiler.decompile(classFilePath, methodName, false);
    }

    public static String decompile(String classFilePath, String methodName, boolean hideUnicode) {
        final StringBuilder result = new StringBuilder(8192);
        OutputSinkFactory mySink = new OutputSinkFactory(){

            @Override
            public List<OutputSinkFactory.SinkClass> getSupportedSinks(OutputSinkFactory.SinkType sinkType, Collection<OutputSinkFactory.SinkClass> collection) {
                return Arrays.asList(OutputSinkFactory.SinkClass.STRING, OutputSinkFactory.SinkClass.DECOMPILED, OutputSinkFactory.SinkClass.DECOMPILED_MULTIVER, OutputSinkFactory.SinkClass.EXCEPTION_MESSAGE);
            }

            @Override
            public <T> OutputSinkFactory.Sink<T> getSink(final OutputSinkFactory.SinkType sinkType, OutputSinkFactory.SinkClass sinkClass) {
                return new OutputSinkFactory.Sink<T>(){

                    @Override
                    public void write(T sinkable) {
                        if (sinkType == OutputSinkFactory.SinkType.PROGRESS) {
                            return;
                        }
                        result.append(sinkable);
                    }
                };
            }
        };
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("showversion", "false");
        options.put("hideutf", String.valueOf(hideUnicode));
        if (!StringUtils.isBlank(methodName)) {
            options.put("methodname", methodName);
        }
        CfrDriver driver = new CfrDriver.Builder().withOptions(options).withOutputSink(mySink).build();
        ArrayList<String> toAnalyse = new ArrayList<String>();
        toAnalyse.add(classFilePath);
        driver.analyse(toAnalyse);
        return result.toString();
    }
}

