/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.command.model.ThreadVO;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ThreadSampler {
    private long sampleInterval = 100L;

    public List<ThreadVO> sample(Collection<Thread> originThreads) {
        ArrayList<Thread> threads = new ArrayList<Thread>(originThreads);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        HashMap<Long, Long> times1 = new HashMap<Long, Long>();
        for (Thread thread : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread.getId());
            times1.put(thread.getId(), cpu);
        }
        try {
            Thread.sleep(this.sampleInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        HashMap<Long, Long> times2 = new HashMap<Long, Long>(threads.size());
        for (Thread thread : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread.getId());
            times2.put(thread.getId(), cpu);
        }
        long l = 0L;
        HashMap<Object, Long> deltas = new HashMap<Object, Long>(threads.size());
        for (Object id : times2.keySet()) {
            long time1 = (Long)times2.get(id);
            long time2 = (Long)times1.get(id);
            if (time1 == -1L) {
                time1 = time2;
            } else if (time2 == -1L) {
                time2 = time1;
            }
            long delta = time2 - time1;
            deltas.put(id, delta);
            l += delta;
        }
        final HashMap<Thread, Long> cpus = new HashMap<Thread, Long>(threads.size());
        for (Thread thread : threads) {
            long cpu = l == 0L ? 0L : (long)Math.round((Long)deltas.get(thread.getId()) * 100L / l);
            cpus.put(thread, cpu);
        }
        Collections.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(Thread o1, Thread o2) {
                long l2;
                long l1 = (Long)cpus.get(o1);
                if (l1 < (l2 = ((Long)cpus.get(o2)).longValue())) {
                    return 1;
                }
                if (l1 > l2) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<ThreadVO> threadVOList = new ArrayList<ThreadVO>(threads.size());
        for (Thread thread : threads) {
            ThreadGroup group = thread.getThreadGroup();
            long seconds = (Long)times2.get(thread.getId()) / 1000000000L;
            long cpu = (Long)cpus.get(thread);
            ThreadVO threadVO = new ThreadVO();
            threadVO.setId(thread.getId());
            threadVO.setName(thread.getName());
            threadVO.setGroup(group == null ? "" : group.getName());
            threadVO.setPriority(thread.getPriority());
            threadVO.setState(thread.getState());
            threadVO.setCpu(cpu);
            threadVO.setTime(seconds);
            threadVO.setInterrupted(thread.isInterrupted());
            threadVO.setDaemon(thread.isDaemon());
            threadVOList.add(threadVO);
        }
        return threadVOList;
    }

    public long getSampleInterval() {
        return this.sampleInterval;
    }

    public void setSampleInterval(long sampleInterval) {
        this.sampleInterval = sampleInterval;
    }
}

