/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.env;

import com.taobao.arthas.core.env.ConfigurablePropertyResolver;
import com.taobao.arthas.core.env.Environment;
import com.taobao.arthas.core.env.MutablePropertySources;
import com.taobao.arthas.core.env.PropertiesPropertySource;
import com.taobao.arthas.core.env.PropertySource;
import com.taobao.arthas.core.env.PropertySourcesPropertyResolver;
import com.taobao.arthas.core.env.ReadOnlySystemAttributesMap;
import com.taobao.arthas.core.env.SystemEnvironmentPropertySource;
import java.security.AccessControlException;
import java.util.Map;

public class ArthasEnvironment
implements Environment {
    public static final String SYSTEM_ENVIRONMENT_PROPERTY_SOURCE_NAME = "systemEnvironment";
    public static final String SYSTEM_PROPERTIES_PROPERTY_SOURCE_NAME = "systemProperties";
    private final MutablePropertySources propertySources = new MutablePropertySources();
    private final ConfigurablePropertyResolver propertyResolver = new PropertySourcesPropertyResolver(this.propertySources);

    public ArthasEnvironment() {
        this.propertySources.addLast(new PropertiesPropertySource(SYSTEM_PROPERTIES_PROPERTY_SOURCE_NAME, this.getSystemProperties()));
        this.propertySources.addLast(new SystemEnvironmentPropertySource(SYSTEM_ENVIRONMENT_PROPERTY_SOURCE_NAME, this.getSystemEnvironment()));
    }

    public void addFirst(PropertySource<?> propertySource) {
        this.propertySources.addFirst(propertySource);
    }

    public void addLast(PropertySource<?> propertySource) {
        this.propertySources.addLast(propertySource);
    }

    public Map<String, Object> getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (AccessControlException ex) {
            return new ReadOnlySystemAttributesMap(){

                @Override
                protected String getSystemAttribute(String attributeName) {
                    try {
                        return System.getProperty(attributeName);
                    }
                    catch (AccessControlException ex) {
                        return null;
                    }
                }
            };
        }
    }

    public Map<String, Object> getSystemEnvironment() {
        try {
            return System.getenv();
        }
        catch (AccessControlException ex) {
            return new ReadOnlySystemAttributesMap(){

                @Override
                protected String getSystemAttribute(String attributeName) {
                    try {
                        return System.getenv(attributeName);
                    }
                    catch (AccessControlException ex) {
                        return null;
                    }
                }
            };
        }
    }

    @Override
    public boolean containsProperty(String key) {
        return this.propertyResolver.containsProperty(key);
    }

    @Override
    public String getProperty(String key) {
        return this.propertyResolver.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.propertyResolver.getProperty(key, defaultValue);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType) {
        return this.propertyResolver.getProperty(key, targetType);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return this.propertyResolver.getProperty(key, targetType, defaultValue);
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key);
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return this.propertyResolver.getRequiredProperty(key, targetType);
    }

    @Override
    public String resolvePlaceholders(String text) {
        return this.propertyResolver.resolvePlaceholders(text);
    }

    @Override
    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return this.propertyResolver.resolveRequiredPlaceholders(text);
    }
}

