/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.ThreadCpuInfo;
import com.taobao.arthas.core.command.model.ThreadModel;
import com.taobao.arthas.core.command.model.ThreadVO;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.command.view.ViewRenderUtil;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ThreadUtil;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.util.RenderUtil;
import java.util.List;
import java.util.Map;

public class ThreadView
extends ResultView<ThreadModel> {
    @Override
    public void draw(CommandProcess process, ThreadModel result) {
        if (result.getThreadInfo() != null) {
            String content = ThreadUtil.getFullStacktrace(result.getThreadInfo(), -1L);
            process.write(content);
        } else if (result.getBusyThreads() != null) {
            ThreadCpuInfo[] threadInfos;
            for (ThreadCpuInfo threadCpuInfo : threadInfos = result.getBusyThreads()) {
                String stacktrace = ThreadUtil.getFullStacktrace(threadCpuInfo.threadInfo(), threadCpuInfo.getCpuUsage());
                process.write(stacktrace).write("\n");
            }
        } else if (result.getBlockingLockInfo() != null) {
            String stacktrace = ThreadUtil.getFullStacktrace(result.getBlockingLockInfo());
            process.write(stacktrace);
        } else if (result.getThreadStateCount() != null) {
            Map<Thread.State, Integer> threadStateCount = result.getThreadStateCount();
            List<ThreadVO> threadStats = result.getThreadStats();
            int total = 0;
            for (Integer n : threadStateCount.values()) {
                total += n.intValue();
            }
            StringBuilder threadStat = new StringBuilder();
            threadStat.append("Threads Total: ").append(total);
            for (Thread.State s : Thread.State.values()) {
                Integer count = threadStateCount.get((Object)s);
                threadStat.append(", ").append(s.name()).append(": ").append(count);
            }
            String string = RenderUtil.render((Element)new LabelElement((Object)threadStat), (int)process.width());
            int height = Math.max(5, process.height() - 2);
            height = Math.min(height, threadStats.size() + 2);
            String content = ViewRenderUtil.drawThreadInfo(threadStats, process.width(), height);
            process.write(string + content);
        }
    }
}

