/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.command.model.MessageModel;
import com.taobao.arthas.core.command.model.SystemPropertyModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;

@Name(value="sysprop")
@Summary(value="Display, and change the system properties.")
@Description(value="\nEXAMPLES:\n  sysprop\n  sysprop file.encoding\n  sysprop production.mode true\n\nWIKI:\n  https://alibaba.github.io/arthas/sysprop")
public class SystemPropertyCommand
extends AnnotatedCommand {
    private String propertyName;
    private String propertyValue;

    @Argument(index=0, argName="property-name", required=false)
    @Description(value="property name")
    public void setOptionName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Argument(index=1, argName="property-value", required=false)
    @Description(value="property value")
    public void setOptionValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    @Override
    public void process(CommandProcess process) {
        try {
            if (StringUtils.isBlank(this.propertyName) && StringUtils.isBlank(this.propertyValue)) {
                process.appendResult(new SystemPropertyModel(System.getProperties()));
            } else if (StringUtils.isBlank(this.propertyValue)) {
                String value = System.getProperty(this.propertyName);
                if (value == null) {
                    process.end(1, "There is no property with the key " + this.propertyName);
                    return;
                }
                process.appendResult(new SystemPropertyModel(this.propertyName, value));
            } else {
                System.setProperty(this.propertyName, this.propertyValue);
                process.appendResult(new MessageModel("Successfully changed the system property."));
                process.appendResult(new SystemPropertyModel(this.propertyName, System.getProperty(this.propertyName)));
            }
            process.end();
        }
        catch (Throwable t) {
            process.end(-1, "Error during setting system property: " + t.getMessage());
        }
    }

    @Override
    public void complete(Completion completion) {
        CompletionUtils.complete(completion, System.getProperties().stringPropertyNames());
    }
}

