/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import com.taobao.arthas.core.view.Ansi;
import java.arthas.SpyAPI;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class ThreadUtil {
    private static final BlockingLockInfo EMPTY_INFO = new BlockingLockInfo();
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static int MAGIC_STACK_DEPTH = 0;

    public static ThreadGroup getRoot() {
        ThreadGroup parent;
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while ((parent = group.getParent()) != null) {
            group = parent;
        }
        return group;
    }

    public static Map<String, Thread> getThreads() {
        ThreadGroup root = ThreadUtil.getRoot();
        Thread[] threads = new Thread[root.activeCount()];
        while (root.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        TreeMap<String, Thread> map = new TreeMap<String, Thread>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (Thread thread : threads) {
            if (thread == null) continue;
            map.put(thread.getName() + "-" + thread.getId(), thread);
        }
        return map;
    }

    public static List<Thread> getThreadList() {
        ArrayList<Thread> result = new ArrayList<Thread>();
        ThreadGroup root = ThreadUtil.getRoot();
        Thread[] threads = new Thread[root.activeCount()];
        while (root.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        for (Thread thread : threads) {
            if (thread == null) continue;
            result.add(thread);
        }
        return result;
    }

    public static Map<Long, Long> getTopNThreads(int sampleInterval, int topN) {
        List<Thread> threads = ThreadUtil.getThreadList();
        HashMap<Long, Long> times1 = new HashMap<Long, Long>();
        for (Thread thread : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread.getId());
            times1.put(thread.getId(), cpu);
        }
        try {
            Thread.sleep(sampleInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        HashMap<Long, Long> times2 = new HashMap<Long, Long>(threads.size());
        for (Thread thread : threads) {
            long cpu = threadMXBean.getThreadCpuTime(thread.getId());
            times2.put(thread.getId(), cpu);
        }
        long l = 0L;
        HashMap<Object, Long> deltas = new HashMap<Object, Long>(threads.size());
        for (Object id : times2.keySet()) {
            long time1 = (Long)times2.get(id);
            long time2 = (Long)times1.get(id);
            if (time1 == -1L) {
                time1 = time2;
            } else if (time2 == -1L) {
                time2 = time1;
            }
            long delta = time2 - time1;
            deltas.put(id, delta);
            l += delta;
        }
        final HashMap<Thread, Long> cpus = new HashMap<Thread, Long>(threads.size());
        for (Thread thread : threads) {
            long cpu = l == 0L ? 0L : (long)Math.round((Long)deltas.get(thread.getId()) * 100L / l);
            cpus.put(thread, cpu);
        }
        Collections.sort(threads, new Comparator<Thread>(){

            @Override
            public int compare(Thread o1, Thread o2) {
                long l2;
                long l1 = (Long)cpus.get(o1);
                if (l1 < (l2 = ((Long)cpus.get(o2)).longValue())) {
                    return 1;
                }
                if (l1 > l2) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedHashMap<Long, Long> topNThreads = new LinkedHashMap<Long, Long>();
        List<Thread> topThreads = topN > 0 && topN <= threads.size() ? threads.subList(0, topN) : threads;
        for (Thread thread : topThreads) {
            topNThreads.put(thread.getId(), (Long)cpus.get(thread));
        }
        return topNThreads;
    }

    public static BlockingLockInfo findMostBlockingLock() {
        ThreadInfo[] infos = threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported());
        HashMap<Integer, Integer> blockCountPerLock = new HashMap<Integer, Integer>();
        HashMap<Integer, ThreadInfo> ownerThreadPerLock = new HashMap<Integer, ThreadInfo>();
        for (ThreadInfo info : infos) {
            if (info == null) continue;
            LockInfo lockInfo = info.getLockInfo();
            if (lockInfo != null) {
                if (blockCountPerLock.get(lockInfo.getIdentityHashCode()) == null) {
                    blockCountPerLock.put(lockInfo.getIdentityHashCode(), 0);
                }
                int blockedCount = (Integer)blockCountPerLock.get(lockInfo.getIdentityHashCode());
                blockCountPerLock.put(lockInfo.getIdentityHashCode(), blockedCount + 1);
            }
            for (MonitorInfo monitorInfo : info.getLockedMonitors()) {
                if (ownerThreadPerLock.get(monitorInfo.getIdentityHashCode()) != null) continue;
                ownerThreadPerLock.put(monitorInfo.getIdentityHashCode(), info);
            }
            for (LockInfo lockedSync : info.getLockedSynchronizers()) {
                if (ownerThreadPerLock.get(lockedSync.getIdentityHashCode()) != null) continue;
                ownerThreadPerLock.put(lockedSync.getIdentityHashCode(), info);
            }
        }
        int mostBlockingLock = 0;
        int maxBlockingCount = 0;
        for (Map.Entry entry : blockCountPerLock.entrySet()) {
            if ((Integer)entry.getValue() <= maxBlockingCount || ownerThreadPerLock.get(entry.getKey()) == null) continue;
            maxBlockingCount = (Integer)entry.getValue();
            mostBlockingLock = (Integer)entry.getKey();
        }
        if (mostBlockingLock == 0) {
            return EMPTY_INFO;
        }
        BlockingLockInfo blockingLockInfo = new BlockingLockInfo();
        blockingLockInfo.threadInfo = (ThreadInfo)ownerThreadPerLock.get(mostBlockingLock);
        blockingLockInfo.lockIdentityHashCode = mostBlockingLock;
        blockingLockInfo.blockingThreadCount = (Integer)blockCountPerLock.get(mostBlockingLock);
        return blockingLockInfo;
    }

    public static String getFullStacktrace(ThreadInfo threadInfo, long cpuUsage) {
        return ThreadUtil.getFullStacktrace(threadInfo, cpuUsage, 0, 0);
    }

    public static String getFullStacktrace(BlockingLockInfo blockingLockInfo) {
        return ThreadUtil.getFullStacktrace(blockingLockInfo.threadInfo, -1L, blockingLockInfo.lockIdentityHashCode, blockingLockInfo.blockingThreadCount);
    }

    public static String getFullStacktrace(ThreadInfo threadInfo, long cpuUsage, int lockIdentityHashCode, int blockingThreadCount) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId());
        if (cpuUsage >= 0L && cpuUsage <= 100L) {
            sb.append(" cpuUsage=").append(cpuUsage).append("%");
        }
        sb.append(" ").append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            sb.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < threadInfo.getStackTrace().length; ++i) {
            StackTraceElement ste = threadInfo.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo);
                if (lockInfo.getIdentityHashCode() == lockIdentityHashCode) {
                    Ansi highlighted = Ansi.ansi().fg(Ansi.Color.RED);
                    highlighted.a(" <---- but blocks ").a(blockingThreadCount).a(" other threads!");
                    sb.append(highlighted.reset().toString());
                }
                sb.append('\n');
            }
        }
        if (i < threadInfo.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = threadInfo.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo);
                if (lockInfo.getIdentityHashCode() == lockIdentityHashCode) {
                    sb.append(" <---- but blocks ").append(blockingThreadCount);
                    sb.append(" other threads!");
                }
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString().replace("\t", "    ");
    }

    private static int findTheSpyAPIDepth(StackTraceElement[] stackTraceElementArray) {
        if (MAGIC_STACK_DEPTH > 0) {
            return MAGIC_STACK_DEPTH;
        }
        if (MAGIC_STACK_DEPTH > stackTraceElementArray.length) {
            return 0;
        }
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!SpyAPI.class.getName().equals(stackTraceElementArray[i].getClassName())) continue;
            MAGIC_STACK_DEPTH = i + 1;
            break;
        }
        return MAGIC_STACK_DEPTH;
    }

    public static String getThreadStack(Thread currentThread) {
        int skip;
        StackTraceElement[] stackTraceElementArray = currentThread.getStackTrace();
        int magicStackDepth = ThreadUtil.findTheSpyAPIDepth(stackTraceElementArray);
        StackTraceElement locationStackTraceElement = stackTraceElementArray[magicStackDepth];
        String locationString = String.format("    @%s.%s()", locationStackTraceElement.getClassName(), locationStackTraceElement.getMethodName());
        StringBuilder builder = new StringBuilder();
        builder.append(ThreadUtil.getThreadTitle(currentThread)).append("\n").append(locationString).append("\n");
        for (int index = skip = magicStackDepth + 1; index < stackTraceElementArray.length; ++index) {
            StackTraceElement ste = stackTraceElementArray[index];
            builder.append("        at ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
        }
        return builder.toString();
    }

    public static String getThreadTitle(Thread currentThread) {
        StringBuilder sb = new StringBuilder("thread_name=");
        sb.append(currentThread.getName()).append(";id=").append(Long.toHexString(currentThread.getId())).append(";is_daemon=").append(currentThread.isDaemon()).append(";priority=").append(currentThread.getPriority()).append(";TCCL=").append(ThreadUtil.getTCCL(currentThread));
        ThreadUtil.getEagleeyeTraceInfo(currentThread, sb);
        return sb.toString();
    }

    private static String getTCCL(Thread currentThread) {
        if (null == currentThread.getContextClassLoader()) {
            return "null";
        }
        return currentThread.getContextClassLoader().getClass().getName() + "@" + Integer.toHexString(currentThread.getContextClassLoader().hashCode());
    }

    private static void getEagleeyeTraceInfo(Thread currentThread, StringBuilder sb) {
        try {
            Object[] tableEntries;
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Object threadLocalMap = threadLocalsField.get(currentThread);
            Field tableFiled = threadLocalMap.getClass().getDeclaredField("table");
            tableFiled.setAccessible(true);
            for (Object entry : tableEntries = (Object[])tableFiled.get(threadLocalMap)) {
                if (entry == null) continue;
                Field valueField = entry.getClass().getDeclaredField("value");
                valueField.setAccessible(true);
                Object threadLocalValue = valueField.get(entry);
                if (threadLocalValue == null || !"com.taobao.eagleeye.RpcContext_inner".equals(threadLocalValue.getClass().getName())) continue;
                Method getTraceIdMethod = threadLocalValue.getClass().getMethod("getTraceId", new Class[0]);
                getTraceIdMethod.setAccessible(true);
                String traceId = (String)getTraceIdMethod.invoke(threadLocalValue, new Object[0]);
                sb.append(";trace_id=").append(traceId);
                Method getRpcIdMethod = threadLocalValue.getClass().getMethod("getRpcId", new Class[0]);
                getTraceIdMethod.setAccessible(true);
                String rpcId = (String)getRpcIdMethod.invoke(threadLocalValue, new Object[0]);
                sb.append(";rpc_id=").append(rpcId);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class BlockingLockInfo {
        public ThreadInfo threadInfo = null;
        public int lockIdentityHashCode = 0;
        public int blockingThreadCount = 0;
    }
}

