/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.view.CatView;
import com.taobao.arthas.core.command.view.EchoView;
import com.taobao.arthas.core.command.view.HelpView;
import com.taobao.arthas.core.command.view.MessageView;
import com.taobao.arthas.core.command.view.OptionsView;
import com.taobao.arthas.core.command.view.PwdView;
import com.taobao.arthas.core.command.view.ResetView;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.command.view.SessionView;
import com.taobao.arthas.core.command.view.ShutdownView;
import com.taobao.arthas.core.command.view.StatusView;
import com.taobao.arthas.core.command.view.SystemEnvView;
import com.taobao.arthas.core.command.view.SystemPropertyView;
import com.taobao.arthas.core.command.view.VMOptionView;
import com.taobao.arthas.core.command.view.VersionView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResultViewResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResultViewResolver.class);
    private Map<Class, ResultView> resultViewMap = new ConcurrentHashMap<Class, ResultView>();

    public ResultViewResolver() {
        this.initResultViews();
    }

    private void initResultViews() {
        try {
            this.registerView(StatusView.class);
            this.registerView(VersionView.class);
            this.registerView(MessageView.class);
            this.registerView(HelpView.class);
            this.registerView(EchoView.class);
            this.registerView(CatView.class);
            this.registerView(OptionsView.class);
            this.registerView(SystemPropertyView.class);
            this.registerView(SystemEnvView.class);
            this.registerView(PwdView.class);
            this.registerView(VMOptionView.class);
            this.registerView(SessionView.class);
            this.registerView(ResetView.class);
            this.registerView(ShutdownView.class);
        }
        catch (Throwable e) {
            logger.error("register result view failed", e);
        }
    }

    public ResultView getResultView(ResultModel model) {
        return this.resultViewMap.get(model.getClass());
    }

    public ResultViewResolver registerView(Class modelClass, ResultView view) {
        this.resultViewMap.put(modelClass, view);
        return this;
    }

    public ResultViewResolver registerView(ResultView view) {
        Class modelClass = ResultViewResolver.getModelClass(view);
        if (modelClass == null) {
            throw new NullPointerException("model class is null");
        }
        return this.registerView(modelClass, view);
    }

    public void registerView(Class<? extends ResultView> viewClass) {
        ResultView view = null;
        try {
            view = viewClass.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("create view instance failure, viewClass:" + viewClass, e);
        }
        this.registerView(view);
    }

    public static <V extends ResultView> Class getModelClass(V view) {
        Class<?> viewClass = view.getClass();
        Method[] declaredMethods = viewClass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Class<?>[] parameterTypes;
            Method method = declaredMethods[i];
            if (!method.getName().equals("draw") || (parameterTypes = method.getParameterTypes()).length != 2 || parameterTypes[0] != CommandProcess.class || parameterTypes[1] == ResultModel.class || !ResultModel.class.isAssignableFrom(parameterTypes[1])) continue;
            return parameterTypes[1];
        }
        return null;
    }
}

