/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.advisor.Enhancer;
import com.taobao.arthas.core.command.model.ResetModel;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.affect.EnhancerAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;

@Name(value="reset")
@Summary(value="Reset all the enhanced classes")
@Description(value="\nEXAMPLES:\n  reset\n  reset *List\n  reset -E .*List\n")
public class ResetCommand
extends AnnotatedCommand {
    private String classPattern;
    private boolean isRegEx = false;

    @Argument(index=0, argName="class-pattern", required=false)
    @Description(value="Path and classname of Pattern Matching")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        Instrumentation inst = process.session().getInstrumentation();
        Matcher<String> matcher = SearchUtils.classNameMatcher(this.classPattern, this.isRegEx);
        try {
            EnhancerAffect enhancerAffect = Enhancer.reset(inst, matcher);
            process.appendResult(new ResetModel(enhancerAffect));
        }
        catch (UnmodifiableClassException unmodifiableClassException) {
        }
        finally {
            process.end();
        }
    }
}

