/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.Option;
import com.taobao.arthas.core.command.model.ChangeResultVO;
import com.taobao.arthas.core.command.model.OptionVO;
import com.taobao.arthas.core.command.model.OptionsModel;
import com.taobao.arthas.core.command.model.StatusModel;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TokenUtils;
import com.taobao.arthas.core.util.matcher.EqualsMatcher;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.reflect.FieldUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Name(value="options")
@Summary(value="View and change various Arthas options")
@Description(value="\nEXAMPLES:\noptions       # list all options\noptions json-format true\noptions dump true\noptions unsafe true\n\nWIKI:\n  https://alibaba.github.io/arthas/options")
public class OptionsCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(OptionsCommand.class);
    private String optionName;
    private String optionValue;

    @Argument(index=0, argName="options-name", required=false)
    @Description(value="Option name")
    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    @Argument(index=1, argName="options-value", required=false)
    @Description(value="Option value")
    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    @Override
    public void process(CommandProcess process) {
        try {
            StatusModel statusModel = null;
            statusModel = this.isShow() ? this.processShow(process) : (this.isShowName() ? this.processShowName(process) : this.processChangeNameValue(process));
            if (statusModel != null) {
                process.end(statusModel.getStatusCode(), statusModel.getMessage());
            } else {
                process.end(-1, "command was not processed");
            }
        }
        catch (Throwable t) {
            logger.error("process options command error", t);
            process.end(-1, "process options command error");
        }
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        List<CliToken> lineTokens = completion.lineTokens();
        if (argumentIndex == 1) {
            String laseToken = TokenUtils.getLast(lineTokens).value().trim();
            String pattern = "^" + laseToken + ".*";
            Collection<String> optionNames = this.findOptionNames(new RegexMatcher(pattern));
            CompletionUtils.complete(completion, optionNames);
        } else {
            super.complete(completion);
        }
    }

    private StatusModel processShow(CommandProcess process) throws IllegalAccessException {
        Collection<Field> fields = this.findOptionFields(new RegexMatcher(".*"));
        process.appendResult(new OptionsModel(this.convertToOptionVOs(fields)));
        return StatusModel.success();
    }

    private StatusModel processShowName(CommandProcess process) throws IllegalAccessException {
        Collection<Field> fields = this.findOptionFields(new EqualsMatcher<String>(this.optionName));
        process.appendResult(new OptionsModel(this.convertToOptionVOs(fields)));
        return StatusModel.success();
    }

    private StatusModel processChangeNameValue(CommandProcess process) throws IllegalAccessException {
        Object afterValue;
        Object beforeValue;
        Option optionAnnotation;
        block11: {
            Collection<Field> fields = this.findOptionFields(new EqualsMatcher<String>(this.optionName));
            if (fields.isEmpty()) {
                return StatusModel.failure(-1, String.format("options[%s] not found.", this.optionName));
            }
            Field field = fields.iterator().next();
            optionAnnotation = field.getAnnotation(Option.class);
            Class<?> type = field.getType();
            beforeValue = FieldUtils.readStaticField(field);
            try {
                if (ArthasCheckUtils.isIn(type, Integer.TYPE, Integer.class)) {
                    afterValue = Integer.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Long.TYPE, Long.class)) {
                    afterValue = Long.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Boolean.TYPE, Boolean.class)) {
                    afterValue = Boolean.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Double.TYPE, Double.class)) {
                    afterValue = Double.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Float.TYPE, Float.class)) {
                    afterValue = Float.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Byte.TYPE, Byte.class)) {
                    afterValue = Byte.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Short.TYPE, Short.class)) {
                    afterValue = Short.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Short.TYPE, String.class)) {
                    afterValue = this.optionValue;
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                return StatusModel.failure(-1, String.format("Options[%s] type[%s] was unsupported.", this.optionName, type.getSimpleName()));
            }
            catch (Throwable t) {
                return StatusModel.failure(-1, String.format("Cannot cast option value[%s] to type[%s].", this.optionValue, type.getSimpleName()));
            }
        }
        ChangeResultVO changeResultVO = new ChangeResultVO(optionAnnotation.name(), beforeValue, afterValue);
        process.appendResult(new OptionsModel(changeResultVO));
        return StatusModel.success();
    }

    private boolean isShow() {
        return StringUtils.isBlank(this.optionName) && StringUtils.isBlank(this.optionValue);
    }

    private boolean isShowName() {
        return !StringUtils.isBlank(this.optionName) && StringUtils.isBlank(this.optionValue);
    }

    private Collection<Field> findOptionFields(Matcher<String> optionNameMatcher) {
        ArrayList<Field> matchFields = new ArrayList<Field>();
        for (Field optionField : FieldUtils.getAllFields(GlobalOptions.class)) {
            if (!this.isMatchOptionAnnotation(optionField, optionNameMatcher)) continue;
            matchFields.add(optionField);
        }
        return matchFields;
    }

    private Collection<String> findOptionNames(Matcher<String> optionNameMatcher) {
        ArrayList<String> matchOptionNames = new ArrayList<String>();
        for (Field optionField : FieldUtils.getAllFields(GlobalOptions.class)) {
            if (!this.isMatchOptionAnnotation(optionField, optionNameMatcher)) continue;
            Option optionAnnotation = optionField.getAnnotation(Option.class);
            matchOptionNames.add(optionAnnotation.name());
        }
        return matchOptionNames;
    }

    private boolean isMatchOptionAnnotation(Field optionField, Matcher<String> optionNameMatcher) {
        if (!optionField.isAnnotationPresent(Option.class)) {
            return false;
        }
        Option optionAnnotation = optionField.getAnnotation(Option.class);
        return optionAnnotation != null && optionNameMatcher.matching(optionAnnotation.name());
    }

    private List<OptionVO> convertToOptionVOs(Collection<Field> fields) throws IllegalAccessException {
        ArrayList<OptionVO> list = new ArrayList<OptionVO>();
        for (Field field : fields) {
            list.add(this.convertToOptionVO(field));
        }
        return list;
    }

    private OptionVO convertToOptionVO(Field optionField) throws IllegalAccessException {
        Option optionAnnotation = optionField.getAnnotation(Option.class);
        OptionVO optionVO = new OptionVO();
        optionVO.setLevel(optionAnnotation.level());
        optionVO.setName(optionAnnotation.name());
        optionVO.setSummary(optionAnnotation.summary());
        optionVO.setDescription(optionAnnotation.description());
        optionVO.setType(optionField.getType().getSimpleName());
        optionVO.setValue("" + optionField.get(null));
        return optionVO;
    }
}

