/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.command.model.SystemEnvModel;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;

@Name(value="sysenv")
@Summary(value="Display the system env.")
@Description(value="\nEXAMPLES:\n  sysenv\n  sysenv USER\n\nWIKI:\n  https://alibaba.github.io/arthas/sysenv")
public class SystemEnvCommand
extends AnnotatedCommand {
    private String envName;

    @Argument(index=0, argName="env-name", required=false)
    @Description(value="env name")
    public void setOptionName(String envName) {
        this.envName = envName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        try {
            SystemEnvModel result = new SystemEnvModel();
            if (StringUtils.isBlank(this.envName)) {
                result.putAll(System.getenv());
            } else {
                String value = System.getenv(this.envName);
                result.put(this.envName, value);
            }
            process.appendResult(result);
        }
        catch (Throwable t) {
            process.end(-1, "Error during setting system env: " + t.getMessage());
        }
        finally {
            process.end();
        }
    }

    @Override
    public void complete(Completion completion) {
        CompletionUtils.complete(completion, System.getenv().keySet());
    }
}

