/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.objectweb.asm.commons.Method;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TypeRenderUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.util.Set;

@Name(value="sm")
@Summary(value="Search the method of classes loaded by JVM")
@Description(value="\nEXAMPLES:\n  sm java.lang.String\n  sm -d org.apache.commons.lang.StringUtils\n  sm -d org/apache/commons/lang/StringUtils\n  sm *StringUtils *\n  sm -Ed org\\\\.apache\\\\.commons\\\\.lang\\.StringUtils .*\n\nWIKI:\n  https://alibaba.github.io/arthas/sm")
public class SearchMethodCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(SearchMethodCommand.class);
    private String classPattern;
    private String methodPattern;
    private String hashCode = null;
    private boolean isDetail = false;
    private boolean isRegEx = false;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(argName="method-pattern", index=1, required=false)
    @Description(value="Method name pattern")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="Display the details of method")
    public void setDetail(boolean detail) {
        this.isDetail = detail;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="c", longName="classloader")
    @Description(value="The hash code of the special class's classLoader")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        Matcher<String> methodNameMatcher = this.methodNameMatcher();
        Set<Class<?>> matchedClasses = SearchUtils.searchClass(inst, this.classPattern, this.isRegEx, this.hashCode);
        for (Class<?> clazz : matchedClasses) {
            try {
                String line;
                String methodNameWithDescriptor;
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    methodNameWithDescriptor = Method.getMethod(constructor).toString();
                    if (!methodNameMatcher.matching("<init>")) continue;
                    if (this.isDetail) {
                        process.write(RenderUtil.render((Element)this.renderConstructor(constructor, clazz), (int)process.width()) + "\n");
                    } else {
                        line = String.format("%s %s%n", clazz.getName(), methodNameWithDescriptor);
                        process.write(line);
                    }
                    affect.rCnt(1);
                }
                for (Executable executable : clazz.getDeclaredMethods()) {
                    methodNameWithDescriptor = Method.getMethod((java.lang.reflect.Method)executable).toString();
                    if (!methodNameMatcher.matching(((java.lang.reflect.Method)executable).getName())) continue;
                    if (this.isDetail) {
                        process.write(RenderUtil.render((Element)this.renderMethod((java.lang.reflect.Method)executable, clazz), (int)process.width()) + "\n");
                    } else {
                        line = String.format("%s %s%n", clazz.getName(), methodNameWithDescriptor);
                        process.write(line);
                    }
                    affect.rCnt(1);
                }
            }
            catch (Error e) {
                String msg = String.format("process class failed: %s, error: %s", clazz.getName(), e.toString());
                logger.error(msg, (Throwable)e);
                process.write(msg).write("\n");
                throw e;
            }
        }
        process.write(affect + "\n");
        process.end();
    }

    private Matcher<String> methodNameMatcher() {
        if (StringUtils.isBlank(this.methodPattern)) {
            this.methodPattern = this.isRegEx ? ".*" : "*";
        }
        return this.isRegEx ? new RegexMatcher(this.methodPattern) : new WildcardMatcher(this.methodPattern);
    }

    private Element renderMethod(java.lang.reflect.Method method, Class<?> clazz) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{Element.label((String)"declaring-class").style(Decoration.bold.bold()), Element.label((String)method.getDeclaringClass().getName())}).row(new Element[]{Element.label((String)"method-name").style(Decoration.bold.bold()), Element.label((String)method.getName()).style(Decoration.bold.bold())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)StringUtils.modifier(method.getModifiers(), ','))}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(method))}).row(new Element[]{Element.label((String)"parameters").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawParameters(method))}).row(new Element[]{Element.label((String)"return").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawReturn(method))}).row(new Element[]{Element.label((String)"exceptions").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawExceptions(method))}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)StringUtils.classLoaderHash(clazz))});
        return table;
    }

    private Element renderConstructor(Constructor<?> constructor, Class<?> clazz) {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(new Element[]{Element.label((String)"declaring-class").style(Decoration.bold.bold()), Element.label((String)constructor.getDeclaringClass().getName())}).row(new Element[]{Element.label((String)"constructor-name").style(Decoration.bold.bold()), Element.label((String)"<init>").style(Decoration.bold.bold())}).row(new Element[]{Element.label((String)"modifier").style(Decoration.bold.bold()), Element.label((String)StringUtils.modifier(constructor.getModifiers(), ','))}).row(new Element[]{Element.label((String)"annotation").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawAnnotation(constructor.getDeclaredAnnotations()))}).row(new Element[]{Element.label((String)"parameters").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawParameters(constructor))}).row(new Element[]{Element.label((String)"exceptions").style(Decoration.bold.bold()), Element.label((String)TypeRenderUtils.drawExceptions(constructor))}).row(new Element[]{Element.label((String)"classLoaderHash").style(Decoration.bold.bold()), Element.label((String)StringUtils.classLoaderHash(clazz))});
        return table;
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!CompletionUtils.completeClassName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!CompletionUtils.completeMethodName(completion)) {
                super.complete(completion);
            }
            return;
        }
        super.complete(completion);
    }
}

