/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.alibaba.arthas.deps.org.objectweb.asm.ClassReader;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Name(value="redefine")
@Summary(value="Redefine classes. @see Instrumentation#redefineClasses(ClassDefinition...)")
@Description(value="\nEXAMPLES:\n  redefine /tmp/Test.class\n  redefine -c 327a647b /tmp/Test.class /tmp/Test\\$Inner.class \n\nWIKI:\n  https://alibaba.github.io/arthas/redefine")
public class RedefineCommand
extends AnnotatedCommand {
    private static final Logger logger = LoggerFactory.getLogger(RedefineCommand.class);
    private static final int MAX_FILE_SIZE = 0xA00000;
    private String hashCode;
    private List<String> paths;

    @Option(shortName="c", longName="classloader")
    @Description(value="classLoader hashcode")
    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Argument(argName="classfilePaths", index=0)
    @Description(value=".class file paths")
    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(CommandProcess process) {
        Instrumentation inst = process.session().getInstrumentation();
        for (String string : this.paths) {
            File file = new File(string);
            if (!file.exists()) {
                process.write("file does not exist, path:" + string + "\n");
                process.end();
                return;
            }
            if (!file.isFile()) {
                process.write("not a normal file, path:" + string + "\n");
                process.end();
                return;
            }
            if (file.length() < 0xA00000L) continue;
            process.write("file size: " + file.length() + " >= " + 0xA00000 + ", path: " + string + "\n");
            process.end();
            return;
        }
        HashMap<String, byte[]> bytesMap = new HashMap<String, byte[]>();
        for (String string : this.paths) {
            RandomAccessFile f = null;
            try {
                f = new RandomAccessFile(string, "r");
                byte[] bytes = new byte[(int)f.length()];
                f.readFully(bytes);
                String clazzName = RedefineCommand.readClassName(bytes);
                bytesMap.put(clazzName, bytes);
            }
            catch (Exception e) {
                process.write("" + e + "\n");
            }
            finally {
                if (f == null) continue;
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bytesMap.size() != this.paths.size()) {
            process.write("paths may contains same class name!\n");
            process.end();
            return;
        }
        ArrayList<ClassDefinition> arrayList = new ArrayList<ClassDefinition>();
        for (Class clazz : inst.getAllLoadedClasses()) {
            ClassLoader classLoader;
            if (!bytesMap.containsKey(clazz.getName()) || (classLoader = clazz.getClassLoader()) != null && this.hashCode != null && !Integer.toHexString(classLoader.hashCode()).equals(this.hashCode)) continue;
            arrayList.add(new ClassDefinition(clazz, (byte[])bytesMap.get(clazz.getName())));
            logger.info("Try redefine class name: {}, ClassLoader: {}", (Object)clazz.getName(), (Object)clazz.getClassLoader());
        }
        try {
            if (arrayList.isEmpty()) {
                process.write("These classes are not found in the JVM and may not be loaded: " + bytesMap.keySet() + "\n");
                process.end();
                return;
            }
            inst.redefineClasses(arrayList.toArray(new ClassDefinition[0]));
            process.write("redefine success, size: " + arrayList.size() + "\n");
        }
        catch (Exception exception) {
            process.write("redefine error! " + exception + "\n");
        }
        process.end();
    }

    private static String readClassName(byte[] bytes) {
        return new ClassReader(bytes).getClassName().replace("/", ".");
    }

    @Override
    public void complete(Completion completion) {
        if (!CompletionUtils.completeFilePath(completion)) {
            super.complete(completion);
        }
    }
}

