/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.alibaba.arthas.tunnel.client.TunnelClient;
import com.taobao.arthas.core.server.ArthasBootstrap;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.UserStatUtil;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;

@Name(value="session")
@Summary(value="Display current session information")
public class SessionCommand
extends AnnotatedCommand {
    @Override
    public void process(CommandProcess process) {
        process.write(RenderUtil.render((Element)this.sessionTable(process.session()), (int)process.width())).end();
    }

    private Element sessionTable(Session session) {
        String statUrl;
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"Name").style(Decoration.bold.bold()), Element.label((String)"Value").style(Decoration.bold.bold())});
        table.row(new String[]{"JAVA_PID", "" + session.getPid()}).row(new String[]{"SESSION_ID", "" + session.getSessionId()});
        TunnelClient tunnelClient = ArthasBootstrap.getInstance().getTunnelClient();
        if (tunnelClient != null) {
            String id = tunnelClient.getId();
            if (id != null) {
                table.row(new String[]{"AGENT_ID", "" + id});
            }
            table.row(new String[]{"TUNNEL_SERVER", "" + tunnelClient.getTunnelServerUrl()});
        }
        if ((statUrl = UserStatUtil.getStatUrl()) != null) {
            table.row(new String[]{"STAT_URL", statUrl});
        }
        return table;
    }
}

