/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.core.shell.term.impl.http.DirectoryBrowser;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.middleware.logger.Logger;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.util.Logging;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LogUtil.getArthasLogger();
    private final String wsUri;
    private File dir;

    public HttpRequestHandler(String wsUri, File dir) {
        this.wsUri = wsUri;
        this.dir = dir;
        dir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        if (this.wsUri.equalsIgnoreCase(request.uri())) {
            ctx.fireChannelRead((Object)request.retain());
        } else {
            if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                HttpRequestHandler.send100Continue(ctx);
            }
            DefaultHttpResponse response = new DefaultHttpResponse(request.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String path = new URI(request.uri()).getPath();
            if ("/".equals(path)) {
                path = "/index.html";
            }
            InputStream in = null;
            try {
                DefaultFullHttpResponse fileViewResult = DirectoryBrowser.view(this.dir, path, request.protocolVersion());
                if (fileViewResult != null) {
                    response = fileViewResult;
                } else {
                    URL res = HttpTtyConnection.class.getResource("/com/taobao/arthas/core/http" + path);
                    if (res != null) {
                        String ext;
                        String contentType;
                        DefaultFullHttpResponse fullResp = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK);
                        in = res.openStream();
                        byte[] tmp = new byte[256];
                        int l = 0;
                        while (l != -1) {
                            fullResp.content().writeBytes(tmp, 0, l);
                            l = in.read(tmp);
                        }
                        int li = path.lastIndexOf(46);
                        if (li != -1 && li != path.length() - 1 && (contentType = "html".equals(ext = path.substring(li + 1, path.length())) ? "text/html" : ("js".equals(ext) ? "application/javascript" : ("css".equals(ext) ? "text/css" : null))) != null) {
                            fullResp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
                        }
                        response = fullResp;
                    } else {
                        response.setStatus(HttpResponseStatus.NOT_FOUND);
                    }
                }
            }
            catch (Throwable e) {
                logger.error("arthas", "arthas process http request error: " + request.uri(), e);
            }
            finally {
                ctx.write((Object)response);
                ChannelFuture future = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                IOUtils.close(in);
            }
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Logging.logReportedIoError((Throwable)cause);
        ctx.close();
    }
}

