/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl;

import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.TermServer;
import com.taobao.arthas.core.shell.term.impl.Helper;
import com.taobao.arthas.core.shell.term.impl.TermImpl;
import com.taobao.arthas.core.shell.term.impl.http.NettyWebsocketTtyBootstrap;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.middleware.logger.Logger;
import io.termd.core.function.Consumer;
import io.termd.core.tty.TtyConnection;
import java.util.concurrent.TimeUnit;

public class HttpTermServer
extends TermServer {
    private static Logger logger = LogUtil.getArthasLogger();
    private Handler<Term> termHandler;
    private NettyWebsocketTtyBootstrap bootstrap;
    private String hostIp;
    private int port;
    private long connectionTimeout;

    public HttpTermServer(String hostIp, int port, long connectionTimeout) {
        this.hostIp = hostIp;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public TermServer termHandler(Handler<Term> handler) {
        this.termHandler = handler;
        return this;
    }

    @Override
    public TermServer listen(Handler<Future<TermServer>> listenHandler) {
        this.bootstrap = new NettyWebsocketTtyBootstrap().setHost(this.hostIp).setPort(this.port);
        try {
            this.bootstrap.start(new Consumer<TtyConnection>(){

                public void accept(TtyConnection conn) {
                    HttpTermServer.this.termHandler.handle(new TermImpl(Helper.loadKeymap(), conn));
                }
            }).get(this.connectionTimeout, TimeUnit.MILLISECONDS);
            listenHandler.handle(Future.succeededFuture());
        }
        catch (Throwable t) {
            logger.error(null, "Error listening to port " + this.port, t);
            listenHandler.handle(Future.failedFuture(t));
        }
        return this;
    }

    @Override
    public int actualPort() {
        return this.bootstrap.getPort();
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Handler<Future<Void>> completionHandler) {
        if (this.bootstrap != null) {
            this.bootstrap.stop();
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
        } else if (completionHandler != null) {
            completionHandler.handle(Future.failedFuture("telnet term server not started"));
        }
    }
}

