/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ArthasMethod {
    private final int type;
    private final Constructor<?> constructor;
    private final Method method;
    private static final int TYPE_INIT = 2;
    private static final int TYPE_METHOD = 4;

    public boolean isInit() {
        return (2 & this.type) == 2;
    }

    public boolean isMethod() {
        return (4 & this.type) == 4;
    }

    public String getName() {
        return this.isInit() ? "<init>" : this.method.getName();
    }

    public String toString() {
        return this.isInit() ? this.constructor.toString() : this.method.toString();
    }

    public boolean isAccessible() {
        return this.isInit() ? this.constructor.isAccessible() : this.method.isAccessible();
    }

    public void setAccessible(boolean accessFlag) {
        if (this.isInit()) {
            this.constructor.setAccessible(accessFlag);
        } else {
            this.method.setAccessible(accessFlag);
        }
    }

    public Object invoke(Object target, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.isInit() ? this.constructor.newInstance(args) : this.method.invoke(target, args);
    }

    private ArthasMethod(int type, Constructor<?> constructor, Method method) {
        this.type = type;
        this.constructor = constructor;
        this.method = method;
    }

    public static ArthasMethod newInit(Constructor<?> constructor) {
        return new ArthasMethod(2, constructor, null);
    }

    public static ArthasMethod newMethod(Method method) {
        return new ArthasMethod(4, null, method);
    }
}

