/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl;

import com.taobao.arthas.core.shell.term.TermServer;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.middleware.logger.Logger;
import io.termd.core.readline.Keymap;
import java.io.FileInputStream;
import java.io.InputStream;

public class Helper {
    private static Logger logger = LogUtil.getArthasLogger();

    public static Keymap loadKeymap() {
        return new Keymap(Helper.loadInputRcFile());
    }

    public static InputStream loadInputRcFile() {
        try {
            String customInputrc = System.getProperty("user.home") + "/.arthas/conf/inputrc";
            FileInputStream inputrc = new FileInputStream(customInputrc);
            logger.info("Loaded custom keymap file from " + customInputrc);
            return inputrc;
        }
        catch (Throwable throwable) {
            InputStream inputrc = TermServer.class.getClassLoader().getResourceAsStream("com/taobao/arthas/core/shell/term/readline/inputrc");
            if (inputrc != null) {
                logger.info("Loaded arthas keymap file from com/taobao/arthas/core/shell/term/readline/inputrc");
                return inputrc;
            }
            inputrc = Keymap.class.getResourceAsStream("inputrc");
            if (inputrc != null) {
                return inputrc;
            }
            throw new IllegalStateException("Could not load inputrc file.");
        }
    }
}

