/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.advisor.ReflectAdviceListenerAdapter;
import com.taobao.arthas.core.command.monitor200.WatchCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.DateUtils;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.ThreadLocalWatch;
import com.taobao.arthas.core.view.ObjectView;
import com.taobao.middleware.logger.Logger;

class WatchAdviceListener
extends ReflectAdviceListenerAdapter {
    private static final Logger logger = LogUtil.getArthasLogger();
    private final ThreadLocalWatch threadLocalWatch = new ThreadLocalWatch();
    private WatchCommand command;
    private CommandProcess process;

    public WatchAdviceListener(WatchCommand command, CommandProcess process) {
        this.command = command;
        this.process = process;
    }

    private boolean isFinish() {
        return this.command.isFinish() || !this.command.isBefore() && !this.command.isException() && !this.command.isSuccess();
    }

    @Override
    public void before(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args) throws Throwable {
        this.threadLocalWatch.start();
        if (this.command.isBefore()) {
            this.watching(Advice.newForBefore(loader, clazz, method, target, args));
        }
    }

    @Override
    public void afterReturning(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Object returnObject) throws Throwable {
        Advice advice = Advice.newForAfterRetuning(loader, clazz, method, target, args, returnObject);
        if (this.command.isSuccess()) {
            this.watching(advice);
        }
        this.finishing(advice);
    }

    @Override
    public void afterThrowing(ClassLoader loader, Class<?> clazz, ArthasMethod method, Object target, Object[] args, Throwable throwable) {
        Advice advice = Advice.newForAfterThrowing(loader, clazz, method, target, args, throwable);
        if (this.command.isException()) {
            this.watching(advice);
        }
        this.finishing(advice);
    }

    private void finishing(Advice advice) {
        if (this.isFinish()) {
            this.watching(advice);
        }
    }

    private boolean isNeedExpand() {
        Integer expand = this.command.getExpand();
        return null != expand && expand >= 0;
    }

    private void watching(Advice advice) {
        try {
            double cost = this.threadLocalWatch.costInMillis();
            if (this.isConditionMet(this.command.getConditionExpress(), advice, cost)) {
                Object value = this.getExpressionResult(this.command.getExpress(), advice, cost);
                String result = StringUtils.objectToString(this.isNeedExpand() ? new ObjectView(value, this.command.getExpand(), this.command.getSizeLimit()).draw() : value);
                this.process.write("ts=" + DateUtils.getCurrentDate() + "; [cost=" + cost + "ms] result=" + result + "\n");
                this.process.times().incrementAndGet();
                if (this.isLimitExceeded(this.command.getNumberOfLimit(), this.process.times().get())) {
                    this.abortProcess(this.process, this.command.getNumberOfLimit());
                }
            }
        }
        catch (Exception e) {
            logger.warn("watch failed.", (Throwable)e);
            this.process.write("watch failed, condition is: " + this.command.getConditionExpress() + ", express is: " + this.command.getExpress() + ", " + e.getMessage() + ", visit " + LogUtil.LOGGER_FILE + " for more details.\n");
            this.process.end();
        }
    }
}

