/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.handlers.command.CommandInterruptHandler;
import com.taobao.arthas.core.shell.handlers.shell.QExitHandler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TokenUtils;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.matcher.WildcardMatcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.Descriptor;
import javax.management.DescriptorRead;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

@Name(value="mbean")
@Summary(value="Display the mbean information")
@Description(value="\nExamples:\n  mbean\n  mbean -m java.lang:type=Threading\n  mbean java.lang:type=Threading\n  mbean java.lang:type=Threading *Count\n  mbean -E java.lang:type=Threading PeakThreadCount|ThreadCount|DaemonThreadCount\n  mbean -i 1000 java.lang:type=Threading *Count\n\nWIKI:\n  https://alibaba.github.io/arthas/mbean")
public class MBeanCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    private String name;
    private String attribute;
    private boolean isRegEx = false;
    private long interval = 0L;
    private boolean metaData;
    private int numOfExecutions = 100;
    private Timer timer;
    private long count = 0L;

    @Argument(argName="name-pattern", index=0, required=false)
    @Description(value="ObjectName pattern, see javax.management.ObjectName for more detail.")
    public void setNamePattern(String name) {
        this.name = name;
    }

    @Argument(argName="attribute-pattern", index=1, required=false)
    @Description(value="Attribute name pattern.")
    public void setAttributePattern(String attribute) {
        this.attribute = attribute;
    }

    @Option(shortName="i", longName="interval")
    @Description(value="The interval (in ms) between two executions.")
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match attribute name (wildcard matching by default).")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="m", longName="metadata", flag=false)
    @Description(value="Show metadata of mbean.")
    public void setMetaData(boolean metaData) {
        this.metaData = metaData;
    }

    @Option(shortName="n", longName="number-of-execution")
    @Description(value="The number of times this command will be executed.")
    public void setNumOfExecutions(int numOfExecutions) {
        this.numOfExecutions = numOfExecutions;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public boolean isMetaData() {
        return this.metaData;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getNumOfExecutions() {
        return this.numOfExecutions;
    }

    @Override
    public void process(CommandProcess process) {
        if (StringUtils.isEmpty(this.getName())) {
            this.listMBean(process);
        } else if (this.isMetaData()) {
            this.listMetaData(process);
        } else {
            this.listAttribute(process);
        }
    }

    private void listMBean(CommandProcess process) {
        Set<ObjectName> objectNames = this.queryObjectNames();
        for (ObjectName objectName : objectNames) {
            process.write(objectName.toString());
            process.write("\n");
        }
        process.end();
    }

    private void listAttribute(final CommandProcess process) {
        Session session = process.session();
        this.timer = new Timer("Timer-for-arthas-mbean-" + session.getSessionId(), true);
        process.interruptHandler(new MBeanInterruptHandler(process, this.timer));
        Handler<Void> stopHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                MBeanCommand.this.stop();
            }
        };
        Handler<Void> restartHandler = new Handler<Void>(){

            @Override
            public void handle(Void event) {
                MBeanCommand.this.restart(process);
            }
        };
        process.suspendHandler(stopHandler);
        process.resumeHandler(restartHandler);
        process.endHandler(stopHandler);
        process.stdinHandler(new QExitHandler(process));
        if (this.getInterval() > 0L) {
            this.timer.scheduleAtFixedRate((TimerTask)new MBeanTimerTask(process), 0L, this.getInterval());
        } else {
            this.timer.schedule((TimerTask)new MBeanTimerTask(process), 0L);
        }
    }

    public synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public synchronized void restart(CommandProcess process) {
        if (this.timer == null) {
            Session session = process.session();
            this.timer = new Timer("Timer-for-arthas-mbean-" + session.getSessionId(), true);
            this.timer.scheduleAtFixedRate((TimerTask)new MBeanTimerTask(process), 0L, this.getInterval());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listMetaData(CommandProcess process) {
        Set<ObjectName> objectNames = this.queryObjectNames();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            TableElement table = MBeanCommand.createTable();
            for (ObjectName objectName : objectNames) {
                MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
                this.drawMetaInfo(mBeanInfo, objectName, table);
                this.drawAttributeInfo(mBeanInfo.getAttributes(), table);
                this.drawOperationInfo(mBeanInfo.getOperations(), table);
                this.drawNotificationInfo(mBeanInfo.getNotifications(), table);
            }
            process.write(RenderUtil.render((Element)table, (int)process.width()));
        }
        catch (Throwable e) {
            logger.warn("listMetaData error", e);
        }
        finally {
            process.end();
        }
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        if (argumentIndex == 1) {
            if (!this.completeBeanName(completion)) {
                super.complete(completion);
            }
            return;
        }
        if (argumentIndex == 2) {
            if (!this.completeAttributeName(completion)) {
                super.complete(completion);
            }
            return;
        }
        super.complete(completion);
    }

    private boolean completeBeanName(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String lastToken = TokenUtils.getLast(tokens).value();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        if (lastToken.startsWith("-") || lastToken.startsWith("--")) {
            return false;
        }
        Set<ObjectName> objectNames = this.queryObjectNames();
        HashSet<String> names = new HashSet<String>();
        if (objectNames == null) {
            return false;
        }
        for (ObjectName objectName : objectNames) {
            String name = objectName.toString();
            if (!name.startsWith(lastToken)) continue;
            int index = name.indexOf(46, lastToken.length());
            if (index > 0) {
                names.add(name.substring(0, index + 1));
                continue;
            }
            index = name.indexOf(58, lastToken.length());
            if (index > 0) {
                names.add(name.substring(0, index + 1));
                continue;
            }
            names.add(name);
        }
        String next = (String)names.iterator().next();
        if (names.size() == 1 && (next.endsWith(".") || next.endsWith(":"))) {
            completion.complete(next.substring(lastToken.length()), false);
            return true;
        }
        return CompletionUtils.complete(completion, names);
    }

    private boolean completeAttributeName(Completion completion) {
        List<CliToken> tokens = completion.lineTokens();
        String lastToken = TokenUtils.getLast(tokens).value();
        if (StringUtils.isBlank(lastToken)) {
            lastToken = "";
        }
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        String beanName = TokenUtils.retrievePreviousArg(tokens, lastToken);
        Set<ObjectName> objectNames = null;
        try {
            objectNames = platformMBeanServer.queryNames(new ObjectName(beanName), null);
        }
        catch (MalformedObjectNameException e) {
            logger.warn("queryNames error", (Throwable)e);
        }
        if (objectNames == null || objectNames.size() == 0) {
            return false;
        }
        try {
            MBeanAttributeInfo[] attributes;
            MBeanInfo mBeanInfo = platformMBeanServer.getMBeanInfo(objectNames.iterator().next());
            ArrayList<String> attributeNames = new ArrayList<String>();
            for (MBeanAttributeInfo attribute : attributes = mBeanInfo.getAttributes()) {
                if (StringUtils.isBlank(lastToken)) {
                    attributeNames.add(attribute.getName());
                    continue;
                }
                if (!attribute.getName().startsWith(lastToken)) continue;
                attributeNames.add(attribute.getName());
            }
            return CompletionUtils.complete(completion, attributeNames);
        }
        catch (Throwable e) {
            logger.warn("getMBeanInfo error", e);
            return false;
        }
    }

    private Set<ObjectName> queryObjectNames() {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = new HashSet<ObjectName>();
        try {
            if (StringUtils.isEmpty(this.name)) {
                this.name = "*:*";
            }
            objectNames = platformMBeanServer.queryNames(new ObjectName(this.name), null);
        }
        catch (MalformedObjectNameException e) {
            logger.warn("queryObjectNames error", (Throwable)e);
        }
        return objectNames;
    }

    private Matcher<String> getAttributeMatcher() {
        if (StringUtils.isEmpty(this.attribute)) {
            this.attribute = this.isRegEx ? ".*" : "*";
        }
        return this.isRegEx ? new RegexMatcher(this.attribute) : new WildcardMatcher(this.attribute);
    }

    private void drawMetaInfo(MBeanInfo mBeanInfo, ObjectName objectName, TableElement table) {
        table.row(new Element[]{new LabelElement("MBeanInfo").style(Decoration.bold.fg(Color.red))});
        table.row(new Element[]{new LabelElement("Info:").style(Decoration.bold.fg(Color.yellow))});
        table.row(new String[]{"ObjectName", objectName.toString()});
        table.row(new String[]{"ClassName", mBeanInfo.getClassName()});
        table.row(new String[]{"Description", mBeanInfo.getDescription()});
        this.drawDescriptorInfo("Info Descriptor:", mBeanInfo, table);
        MBeanConstructorInfo[] constructors = mBeanInfo.getConstructors();
        if (constructors.length > 0) {
            for (int i = 0; i < constructors.length; ++i) {
                table.row(new Element[]{new LabelElement("Constructor-" + i).style(Decoration.bold.fg(Color.yellow))});
                table.row(new String[]{"Name", constructors[i].getName()});
                table.row(new String[]{"Description", constructors[i].getDescription()});
            }
        }
    }

    private void drawAttributeInfo(MBeanAttributeInfo[] attributes, TableElement table) {
        for (MBeanAttributeInfo attribute : attributes) {
            table.row(new Element[]{new LabelElement("MBeanAttributeInfo").style(Decoration.bold.fg(Color.red))});
            table.row(new Element[]{new LabelElement("Attribute:").style(Decoration.bold.fg(Color.yellow))});
            table.row(new String[]{"Name", attribute.getName()});
            table.row(new String[]{"Description", attribute.getDescription()});
            table.row(new String[]{"Readable", String.valueOf(attribute.isReadable())});
            table.row(new String[]{"Writable", String.valueOf(attribute.isWritable())});
            table.row(new String[]{"Is", String.valueOf(attribute.isIs())});
            table.row(new String[]{"Type", attribute.getType()});
            this.drawDescriptorInfo("Attribute Descriptor:", attribute, table);
        }
    }

    private void drawOperationInfo(MBeanOperationInfo[] operations, TableElement table) {
        for (MBeanOperationInfo operation : operations) {
            table.row(new Element[]{new LabelElement("MBeanOperationInfo").style(Decoration.bold.fg(Color.red))});
            table.row(new Element[]{new LabelElement("Operation:").style(Decoration.bold.fg(Color.yellow))});
            table.row(new String[]{"Name", operation.getName()});
            table.row(new String[]{"Description", operation.getDescription()});
            String impact = "";
            switch (operation.getImpact()) {
                case 1: {
                    impact = "action";
                    break;
                }
                case 2: {
                    impact = "action/info";
                    break;
                }
                case 0: {
                    impact = "info";
                    break;
                }
                case 3: {
                    impact = "unknown";
                }
            }
            table.row(new String[]{"Impact", impact});
            table.row(new String[]{"ReturnType", operation.getReturnType()});
            MBeanParameterInfo[] signature = operation.getSignature();
            if (signature.length > 0) {
                for (int i = 0; i < signature.length; ++i) {
                    table.row(new Element[]{new LabelElement("Parameter-" + i).style(Decoration.bold.fg(Color.yellow))});
                    table.row(new String[]{"Name", signature[i].getName()});
                    table.row(new String[]{"Type", signature[i].getType()});
                    table.row(new String[]{"Description", signature[i].getDescription()});
                }
            }
            this.drawDescriptorInfo("Operation Descriptor:", operation, table);
        }
    }

    private void drawNotificationInfo(MBeanNotificationInfo[] notificationInfos, TableElement table) {
        for (MBeanNotificationInfo notificationInfo : notificationInfos) {
            table.row(new Element[]{new LabelElement("MBeanNotificationInfo").style(Decoration.bold.fg(Color.red))});
            table.row(new Element[]{new LabelElement("Notification:").style(Decoration.bold.fg(Color.yellow))});
            table.row(new String[]{"Name", notificationInfo.getName()});
            table.row(new String[]{"Description", notificationInfo.getDescription()});
            table.row(new String[]{"NotifTypes", Arrays.toString(notificationInfo.getNotifTypes())});
            this.drawDescriptorInfo("Notification Descriptor:", notificationInfo, table);
        }
    }

    private void drawDescriptorInfo(String title, DescriptorRead descriptorRead, TableElement table) {
        Descriptor descriptor = descriptorRead.getDescriptor();
        String[] fieldNames = descriptor.getFieldNames();
        if (fieldNames.length > 0) {
            table.row(new Element[]{new LabelElement(title).style(Decoration.bold.fg(Color.yellow))});
            for (String fieldName : fieldNames) {
                Object fieldValue = descriptor.getFieldValue(fieldName);
                table.row(new String[]{fieldName, fieldValue.toString()});
            }
        }
    }

    private static TableElement createTable() {
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"NAME").style(Decoration.bold.bold()), Element.label((String)"VALUE").style(Decoration.bold.bold())});
        return table;
    }

    private class MBeanTimerTask
    extends TimerTask {
        private CommandProcess process;

        public MBeanTimerTask(CommandProcess process) {
            this.process = process;
        }

        @Override
        public void run() {
            if (MBeanCommand.this.count >= (long)MBeanCommand.this.getNumOfExecutions()) {
                MBeanCommand.this.timer.cancel();
                MBeanCommand.this.timer.purge();
                this.process.write("Process ends after " + MBeanCommand.this.getNumOfExecutions() + " time(s).\n");
                this.process.end();
                return;
            }
            try {
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                Set objectNames = MBeanCommand.this.queryObjectNames();
                TableElement table = MBeanCommand.createTable();
                for (ObjectName objectName : objectNames) {
                    MBeanAttributeInfo[] attributes;
                    MBeanInfo mBeanInfo = platformMBeanServer.getMBeanInfo(objectName);
                    for (MBeanAttributeInfo attribute : attributes = mBeanInfo.getAttributes()) {
                        String value;
                        String attributeName = attribute.getName();
                        if (!MBeanCommand.this.getAttributeMatcher().matching(attributeName)) continue;
                        if (!attribute.isReadable()) {
                            value = RenderUtil.render((Element)new LabelElement("Unavailable").style(Decoration.bold_off.fg(Color.red)));
                        } else {
                            Object attributeObj = platformMBeanServer.getAttribute(objectName, attributeName);
                            value = String.valueOf(attributeObj);
                        }
                        table.row(new String[]{attributeName, value});
                    }
                    this.process.write(RenderUtil.render((Element)table, (int)this.process.width()));
                    this.process.write("\n");
                }
            }
            catch (Throwable e) {
                logger.warn("mbean error", e);
            }
            MBeanCommand.this.count++;
            this.process.times().incrementAndGet();
            if (MBeanCommand.this.getInterval() <= 0L) {
                MBeanCommand.this.stop();
                this.process.end();
            }
        }
    }

    public class MBeanInterruptHandler
    extends CommandInterruptHandler {
        private volatile Timer timer;

        public MBeanInterruptHandler(CommandProcess process, Timer timer) {
            super(process);
            this.timer = timer;
        }

        @Override
        public void handle(Void event) {
            this.timer.cancel();
            super.handle(event);
        }
    }
}

