/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.hidden;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.Option;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ArthasCheckUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.TokenUtils;
import com.taobao.arthas.core.util.matcher.EqualsMatcher;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.arthas.core.util.matcher.RegexMatcher;
import com.taobao.arthas.core.util.reflect.FieldUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Name(value="options")
@Summary(value="View and change various Arthas options")
@Description(value="\nEXAMPLES:\noptions       # list all options\noptions json-format true\noptions dump true\noptions unsafe true\n\nWIKI:\n  https://alibaba.github.io/arthas/options")
public class OptionsCommand
extends AnnotatedCommand {
    private String optionName;
    private String optionValue;

    @Argument(index=0, argName="options-name", required=false)
    @Description(value="Option name")
    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    @Argument(index=1, argName="options-value", required=false)
    @Description(value="Option value")
    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    @Override
    public void process(CommandProcess process) {
        try {
            if (this.isShow()) {
                this.processShow(process);
            } else if (this.isShowName()) {
                this.processShowName(process);
            } else {
                this.processChangeNameValue(process);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            process.end();
        }
    }

    @Override
    public void complete(Completion completion) {
        int argumentIndex = CompletionUtils.detectArgumentIndex(completion);
        List<CliToken> lineTokens = completion.lineTokens();
        if (argumentIndex == 1) {
            String laseToken = TokenUtils.getLast(lineTokens).value().trim();
            String pattern = "^" + laseToken + ".*";
            Collection<String> optionNames = this.findOptionNames(new RegexMatcher(pattern));
            CompletionUtils.complete(completion, optionNames);
        } else {
            super.complete(completion);
        }
    }

    private void processShow(CommandProcess process) throws IllegalAccessException {
        Collection<Field> fields = this.findOptionFields(new RegexMatcher(".*"));
        process.write(RenderUtil.render((Element)this.drawShowTable(fields), (int)process.width()));
    }

    private void processShowName(CommandProcess process) throws IllegalAccessException {
        Collection<Field> fields = this.findOptionFields(new EqualsMatcher<String>(this.optionName));
        process.write(RenderUtil.render((Element)this.drawShowTable(fields), (int)process.width()));
    }

    private void processChangeNameValue(CommandProcess process) throws IllegalAccessException {
        Object afterValue;
        Object beforeValue;
        Option optionAnnotation;
        block11: {
            Collection<Field> fields = this.findOptionFields(new EqualsMatcher<String>(this.optionName));
            if (fields.isEmpty()) {
                process.write(String.format("options[%s] not found.\n", this.optionName));
                return;
            }
            Field field = fields.iterator().next();
            optionAnnotation = field.getAnnotation(Option.class);
            Class<?> type = field.getType();
            beforeValue = FieldUtils.readStaticField(field);
            try {
                if (ArthasCheckUtils.isIn(type, Integer.TYPE, Integer.class)) {
                    afterValue = Integer.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Long.TYPE, Long.class)) {
                    afterValue = Long.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Boolean.TYPE, Boolean.class)) {
                    afterValue = Boolean.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Double.TYPE, Double.class)) {
                    afterValue = Double.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Float.TYPE, Float.class)) {
                    afterValue = Float.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Byte.TYPE, Byte.class)) {
                    afterValue = Byte.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Short.TYPE, Short.class)) {
                    afterValue = Short.valueOf(this.optionValue);
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                if (ArthasCheckUtils.isIn(type, Short.TYPE, String.class)) {
                    afterValue = this.optionValue;
                    FieldUtils.writeStaticField(field, afterValue);
                    break block11;
                }
                process.write(String.format("Options[%s] type[%s] desupported.\n", this.optionName, type.getSimpleName()));
                return;
            }
            catch (Throwable t) {
                process.write(String.format("Cannot cast option value[%s] to type[%s].\n", this.optionValue, type.getSimpleName()));
                return;
            }
        }
        TableElement table = new TableElement().leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"NAME").style(Decoration.bold.bold()), Element.label((String)"BEFORE-VALUE").style(Decoration.bold.bold()), Element.label((String)"AFTER-VALUE").style(Decoration.bold.bold())});
        table.row(new String[]{optionAnnotation.name(), StringUtils.objectToString(beforeValue), StringUtils.objectToString(afterValue)});
        process.write(RenderUtil.render((Element)table, (int)process.width()));
    }

    private boolean isShow() {
        return StringUtils.isBlank(this.optionName) && StringUtils.isBlank(this.optionValue);
    }

    private boolean isShowName() {
        return !StringUtils.isBlank(this.optionName) && StringUtils.isBlank(this.optionValue);
    }

    private Collection<Field> findOptionFields(Matcher<String> optionNameMatcher) {
        ArrayList<Field> matchFields = new ArrayList<Field>();
        for (Field optionField : FieldUtils.getAllFields(GlobalOptions.class)) {
            if (!this.isMatchOptionAnnotation(optionField, optionNameMatcher)) continue;
            matchFields.add(optionField);
        }
        return matchFields;
    }

    private Collection<String> findOptionNames(Matcher<String> optionNameMatcher) {
        ArrayList<String> matchOptionNames = new ArrayList<String>();
        for (Field optionField : FieldUtils.getAllFields(GlobalOptions.class)) {
            if (!this.isMatchOptionAnnotation(optionField, optionNameMatcher)) continue;
            Option optionAnnotation = optionField.getAnnotation(Option.class);
            matchOptionNames.add(optionAnnotation.name());
        }
        return matchOptionNames;
    }

    private boolean isMatchOptionAnnotation(Field optionField, Matcher<String> optionNameMatcher) {
        if (!optionField.isAnnotationPresent(Option.class)) {
            return false;
        }
        Option optionAnnotation = optionField.getAnnotation(Option.class);
        return optionAnnotation != null && optionNameMatcher.matching(optionAnnotation.name());
    }

    private Element drawShowTable(Collection<Field> optionFields) throws IllegalAccessException {
        TableElement table = new TableElement(new int[]{1, 1, 2, 1, 3, 6}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"LEVEL").style(Decoration.bold.bold()), Element.label((String)"TYPE").style(Decoration.bold.bold()), Element.label((String)"NAME").style(Decoration.bold.bold()), Element.label((String)"VALUE").style(Decoration.bold.bold()), Element.label((String)"SUMMARY").style(Decoration.bold.bold()), Element.label((String)"DESCRIPTION").style(Decoration.bold.bold())});
        for (Field optionField : optionFields) {
            Option optionAnnotation = optionField.getAnnotation(Option.class);
            table.row(new String[]{"" + optionAnnotation.level(), optionField.getType().getSimpleName(), optionAnnotation.name(), "" + optionField.get(null), optionAnnotation.summary(), optionAnnotation.description()});
        }
        return table;
    }
}

