/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.JavaVersionUtils;
import com.taobao.arthas.core.config.Configure;
import com.taobao.middleware.cli.CLI;
import com.taobao.middleware.cli.CLIs;
import com.taobao.middleware.cli.CommandLine;
import com.taobao.middleware.cli.Option;
import com.taobao.middleware.cli.TypedOption;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Properties;

public class Arthas {
    private static final String DEFAULT_TELNET_PORT = "3658";
    private static final String DEFAULT_HTTP_PORT = "8563";

    private Arthas(String[] args) throws Exception {
        this.attachAgent(this.parse(args));
    }

    private Configure parse(String[] args) {
        TypedOption pid = new TypedOption().setType(Integer.class).setShortName("pid").setRequired(true);
        TypedOption core = new TypedOption().setType(String.class).setShortName("core").setRequired(true);
        TypedOption agent = new TypedOption().setType(String.class).setShortName("agent").setRequired(true);
        TypedOption target = new TypedOption().setType(String.class).setShortName("target-ip");
        TypedOption telnetPort = new TypedOption().setType(Integer.class).setShortName("telnet-port").setDefaultValue(DEFAULT_TELNET_PORT);
        TypedOption httpPort = new TypedOption().setType(Integer.class).setShortName("http-port").setDefaultValue(DEFAULT_HTTP_PORT);
        TypedOption sessionTimeout = new TypedOption().setType(Integer.class).setShortName("session-timeout").setDefaultValue("1800");
        TypedOption tunnelServer = new TypedOption().setType(String.class).setShortName("tunnel-server");
        TypedOption agentId = new TypedOption().setType(String.class).setShortName("agent-id");
        TypedOption statUrl = new TypedOption().setType(String.class).setShortName("stat-url");
        CLI cli = CLIs.create((String)"arthas").addOption((Option)pid).addOption((Option)core).addOption((Option)agent).addOption((Option)target).addOption((Option)telnetPort).addOption((Option)httpPort).addOption((Option)sessionTimeout).addOption((Option)tunnelServer).addOption((Option)agentId).addOption((Option)statUrl);
        CommandLine commandLine = cli.parse(Arrays.asList(args));
        Configure configure = new Configure();
        configure.setJavaPid((Integer)commandLine.getOptionValue("pid"));
        configure.setArthasAgent((String)commandLine.getOptionValue("agent"));
        configure.setArthasCore((String)commandLine.getOptionValue("core"));
        configure.setSessionTimeout(((Integer)commandLine.getOptionValue("session-timeout")).intValue());
        if (commandLine.getOptionValue("target-ip") == null) {
            throw new IllegalStateException("as.sh is too old to support web console, please run the following command to upgrade to latest version:\ncurl -sLk https://alibaba.github.io/arthas/install.sh | sh");
        }
        configure.setIp((String)commandLine.getOptionValue("target-ip"));
        configure.setTelnetPort((Integer)commandLine.getOptionValue("telnet-port"));
        configure.setHttpPort((Integer)commandLine.getOptionValue("http-port"));
        configure.setTunnelServer((String)commandLine.getOptionValue("tunnel-server"));
        configure.setAgentId((String)commandLine.getOptionValue("agent-id"));
        configure.setStatUrl((String)commandLine.getOptionValue("stat-url"));
        return configure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachAgent(Configure configure) throws Exception {
        VirtualMachineDescriptor virtualMachineDescriptor = null;
        for (VirtualMachineDescriptor descriptor : VirtualMachine.list()) {
            String pid = descriptor.id();
            if (!pid.equals(Integer.toString(configure.getJavaPid()))) continue;
            virtualMachineDescriptor = descriptor;
        }
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = null == virtualMachineDescriptor ? VirtualMachine.attach("" + configure.getJavaPid()) : VirtualMachine.attach(virtualMachineDescriptor);
            Properties targetSystemProperties = virtualMachine.getSystemProperties();
            String targetJavaVersion = JavaVersionUtils.javaVersionStr((Properties)targetSystemProperties);
            String currentJavaVersion = JavaVersionUtils.javaVersionStr();
            if (targetJavaVersion != null && currentJavaVersion != null && !targetJavaVersion.equals(currentJavaVersion)) {
                AnsiLog.warn((String)"Current VM java version: {} do not match target VM java version: {}, attach may fail.", (Object[])new Object[]{currentJavaVersion, targetJavaVersion});
                AnsiLog.warn((String)"Target VM JAVA_HOME is {}, arthas-boot JAVA_HOME is {}, try to set the same JAVA_HOME.", (Object[])new Object[]{targetSystemProperties.getProperty("java.home"), System.getProperty("java.home")});
            }
            String arthasAgentPath = configure.getArthasAgent();
            configure.setArthasAgent(Arthas.encodeArg(arthasAgentPath));
            configure.setArthasCore(Arthas.encodeArg(configure.getArthasCore()));
            virtualMachine.loadAgent(arthasAgentPath, configure.getArthasCore() + ";" + configure.toString());
        }
        finally {
            if (null != virtualMachine) {
                virtualMachine.detach();
            }
        }
    }

    private static String encodeArg(String arg) {
        try {
            return URLEncoder.encode(arg, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return arg;
        }
    }

    public static void main(String[] args) {
        try {
            new Arthas(args);
        }
        catch (Throwable t) {
            AnsiLog.error((String)"Start arthas failed, exception stack trace: ");
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

