/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.server;

import com.alibaba.arthas.tunnel.client.TunnelClient;
import com.taobao.arthas.core.command.BuiltinCommandPack;
import com.taobao.arthas.core.config.Configure;
import com.taobao.arthas.core.shell.ShellServer;
import com.taobao.arthas.core.shell.ShellServerOptions;
import com.taobao.arthas.core.shell.command.CommandResolver;
import com.taobao.arthas.core.shell.handlers.BindHandler;
import com.taobao.arthas.core.shell.impl.ShellServerImpl;
import com.taobao.arthas.core.shell.term.impl.HttpTermServer;
import com.taobao.arthas.core.shell.term.impl.TelnetTermServer;
import com.taobao.arthas.core.util.ArthasBanner;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.UserStatUtil;
import com.taobao.middleware.logger.Logger;
import io.netty.channel.ChannelFuture;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArthasBootstrap {
    private static Logger logger = LogUtil.getArthasLogger();
    private static ArthasBootstrap arthasBootstrap;
    private AtomicBoolean isBindRef = new AtomicBoolean(false);
    private int pid;
    private Instrumentation instrumentation;
    private Thread shutdown;
    private ShellServer shellServer;
    private ExecutorService executorService;
    private TunnelClient tunnelClient;

    private ArthasBootstrap(int pid, Instrumentation instrumentation) {
        this.pid = pid;
        this.instrumentation = instrumentation;
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "as-command-execute-daemon");
                t.setDaemon(true);
                return t;
            }
        });
        this.shutdown = new Thread("as-shutdown-hooker"){

            @Override
            public void run() {
                ArthasBootstrap.this.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdown);
    }

    public void bind(Configure configure) throws Throwable {
        long start = System.currentTimeMillis();
        if (!this.isBindRef.compareAndSet(false, true)) {
            throw new IllegalStateException("already bind");
        }
        String agentId = null;
        try {
            if (configure.getTunnelServer() != null && configure.getHttpPort() > 0) {
                this.tunnelClient = new TunnelClient();
                this.tunnelClient.setId(configure.getAgentId());
                this.tunnelClient.setTunnelServerUrl(configure.getTunnelServer());
                String host = "127.0.0.1";
                if (configure.getIp() != null) {
                    host = configure.getIp();
                }
                URI uri = new URI("ws", null, host, configure.getHttpPort(), "/ws", null, null);
                this.tunnelClient.setLocalServerUrl(uri.toString());
                ChannelFuture channelFuture = this.tunnelClient.start();
                channelFuture.await(10L, TimeUnit.SECONDS);
                if (channelFuture.isSuccess()) {
                    agentId = this.tunnelClient.getId();
                }
            }
        }
        catch (Throwable t) {
            logger.error("arthas", "start tunnel client error", t);
        }
        try {
            ShellServerOptions options = new ShellServerOptions().setInstrumentation(this.instrumentation).setPid(this.pid).setSessionTimeout(configure.getSessionTimeout() * 1000L);
            if (agentId != null) {
                HashMap<String, String> welcomeInfos = new HashMap<String, String>();
                welcomeInfos.put("id", agentId);
                options.setWelcomeMessage(ArthasBanner.welcome(welcomeInfos));
            }
            this.shellServer = new ShellServerImpl(options, this);
            BuiltinCommandPack builtinCommands = new BuiltinCommandPack();
            ArrayList<BuiltinCommandPack> resolvers = new ArrayList<BuiltinCommandPack>();
            resolvers.add(builtinCommands);
            if (configure.getTelnetPort() > 0) {
                this.shellServer.registerTermServer(new TelnetTermServer(configure.getIp(), configure.getTelnetPort(), options.getConnectionTimeout()));
            } else {
                logger.info("telnet port is {}, skip bind telnet server.", new Object[]{configure.getTelnetPort()});
            }
            if (configure.getHttpPort() > 0) {
                this.shellServer.registerTermServer(new HttpTermServer(configure.getIp(), configure.getHttpPort(), options.getConnectionTimeout()));
            } else {
                logger.info("http port is {}, skip bind http server.", new Object[]{configure.getHttpPort()});
            }
            for (CommandResolver commandResolver : resolvers) {
                this.shellServer.registerCommandResolver(commandResolver);
            }
            this.shellServer.listen(new BindHandler(this.isBindRef));
            logger.info("as-server listening on network={};telnet={};http={};timeout={};", configure.getIp(), new Object[]{configure.getTelnetPort(), configure.getHttpPort(), options.getConnectionTimeout()});
            if (configure.getStatUrl() != null) {
                logger.info("arthas stat url: {}", configure.getStatUrl());
            }
            UserStatUtil.setStatUrl(configure.getStatUrl());
            UserStatUtil.arthasStart();
            logger.info("as-server started in {} ms", new Object[]{System.currentTimeMillis() - start});
        }
        catch (Throwable e) {
            logger.error(null, "Error during bind to port " + configure.getTelnetPort(), e);
            if (this.shellServer != null) {
                this.shellServer.close();
            }
            throw e;
        }
    }

    public boolean isBind() {
        return this.isBindRef.get();
    }

    public void destroy() {
        if (this.tunnelClient != null) {
            try {
                this.tunnelClient.stop();
            }
            catch (Throwable e) {
                logger.error("arthas", "stop tunnel client error", e);
            }
        }
        this.executorService.shutdownNow();
        UserStatUtil.destroy();
        this.cleanUpSpyReference();
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        logger.info("as-server destroy completed.");
        LogUtil.closeResultLogger();
    }

    public static synchronized ArthasBootstrap getInstance(int javaPid, Instrumentation instrumentation) {
        if (arthasBootstrap == null) {
            arthasBootstrap = new ArthasBootstrap(javaPid, instrumentation);
        }
        return arthasBootstrap;
    }

    public static ArthasBootstrap getInstance() {
        if (arthasBootstrap == null) {
            throw new IllegalStateException("ArthasBootstrap must be initialized before!");
        }
        return arthasBootstrap;
    }

    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    private void cleanUpSpyReference() {
        try {
            Class<?> spyClass = this.getClass().getClassLoader().loadClass("java.arthas.Spy");
            Method agentDestroyMethod = spyClass.getMethod("destroy", new Class[0]);
            agentDestroyMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            logger.error(null, "Spy load failed from ArthasClassLoader, which should not happen", (Throwable)e);
        }
        catch (Exception e) {
            logger.error(null, "Spy destroy failed: ", (Throwable)e);
        }
    }

    public TunnelClient getTunnelClient() {
        return this.tunnelClient;
    }
}

