/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.middleware.logger.Logger;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Name(value="vmoption")
@Summary(value="Display, and update the vm diagnostic options.")
@Description(value="\nExamples:\n  vmoption\n  vmoption PrintGCDetails\n  vmoption PrintGCDetails true\n\nWIKI:\n  https://alibaba.github.io/arthas/vmoption")
public class VMOptionCommand
extends AnnotatedCommand {
    private static final Logger logger = LogUtil.getArthasLogger();
    private String name;
    private String value;

    @Argument(index=0, argName="name", required=false)
    @Description(value="VMOption name")
    public void setOptionName(String name) {
        this.name = name;
    }

    @Argument(index=1, argName="value", required=false)
    @Description(value="VMOption value")
    public void setOptionValue(String value) {
        this.value = value;
    }

    @Override
    public void process(CommandProcess process) {
        VMOptionCommand.run(process, this.name, this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(CommandProcess process, String name, String value) {
        try {
            HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
            if (StringUtils.isBlank(name) && StringUtils.isBlank(value)) {
                process.write(VMOptionCommand.renderVMOptions(hotSpotDiagnosticMXBean.getDiagnosticOptions(), process.width()));
            } else if (StringUtils.isBlank(value)) {
                VMOption option = hotSpotDiagnosticMXBean.getVMOption(name);
                if (option == null) {
                    process.write("In order to change the system properties, you must specify the property value.\n");
                } else {
                    process.write(VMOptionCommand.renderVMOptions(Arrays.asList(option), process.width()));
                }
            } else {
                hotSpotDiagnosticMXBean.setVMOption(name, value);
                process.write("Successfully updated the vm option.\n");
                process.write(name + "=" + hotSpotDiagnosticMXBean.getVMOption(name).getValue() + "\n");
            }
        }
        catch (Throwable t) {
            process.write("Error during setting vm option: " + t.getMessage() + "\n");
            logger.error("arthas", "Error during setting vm option", t);
        }
        finally {
            process.end();
        }
    }

    private static String renderVMOptions(List<VMOption> diagnosticOptions, int width) {
        TableElement table = new TableElement(new int[]{1, 1, 1, 1}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"KEY").style(Decoration.bold.bold()), Element.label((String)"VALUE").style(Decoration.bold.bold()), Element.label((String)"ORIGIN").style(Decoration.bold.bold()), Element.label((String)"WRITEABLE").style(Decoration.bold.bold())});
        for (VMOption option : diagnosticOptions) {
            table.row(new String[]{option.getName(), option.getValue(), "" + (Object)((Object)option.getOrigin()), "" + option.isWriteable()});
        }
        return RenderUtil.render((Element)table, (int)width);
    }

    @Override
    public void complete(Completion completion) {
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(HotSpotDiagnosticMXBean.class);
        List<VMOption> diagnosticOptions = hotSpotDiagnosticMXBean.getDiagnosticOptions();
        ArrayList<String> names = new ArrayList<String>(diagnosticOptions.size());
        for (VMOption option : diagnosticOptions) {
            names.add(option.getName());
        }
        CompletionUtils.complete(completion, names);
    }
}

