/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.basic1000;

import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.util.Map;

@Name(value="sysenv")
@Summary(value="Display the system env.")
@Description(value="\nEXAMPLES:\n  sysenv\n  sysenv USER\n\nWIKI:\n  https://alibaba.github.io/arthas/sysenv")
public class SystemEnvCommand
extends AnnotatedCommand {
    private String envName;

    @Argument(index=0, argName="env-name", required=false)
    @Description(value="env name")
    public void setOptionName(String envName) {
        this.envName = envName;
    }

    @Override
    public void process(CommandProcess process) {
        try {
            if (StringUtils.isBlank(this.envName)) {
                process.write(this.renderEnv(System.getenv(), process.width()));
            } else {
                String value = System.getenv(this.envName);
                process.write(this.envName + "=" + value + "\n");
            }
        }
        finally {
            process.end();
        }
    }

    @Override
    public void complete(Completion completion) {
        CompletionUtils.complete(completion, System.getenv().keySet());
    }

    private String renderEnv(Map<String, String> envMap, int width) {
        TableElement table = new TableElement(new int[]{1, 4}).leftCellPadding(1).rightCellPadding(1);
        table.row(true, new Element[]{Element.label((String)"KEY").style(Decoration.bold.bold()), Element.label((String)"VALUE").style(Decoration.bold.bold())});
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            table.row(new String[]{entry.getKey(), entry.getValue()});
        }
        return RenderUtil.render((Element)table, (int)width);
    }
}

