/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.klass100;

import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.AnnotatedCommand;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.ClassUtils;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.StringUtils;
import com.taobao.arthas.core.util.affect.RowAffect;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import com.taobao.text.ui.Element;
import com.taobao.text.util.RenderUtil;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@Name(value="sc")
@Summary(value="Search all the classes loaded by JVM")
@Description(value="\nEXAMPLES:\n  sc -d org.apache.commons.lang.StringUtils\n  sc -d org/apache/commons/lang/StringUtils\n  sc -d *StringUtils\n  sc -d -f org.apache.commons.lang.StringUtils\n  sc -E org\\\\.apache\\\\.commons\\\\.lang\\\\.StringUtils\n\nWIKI:\n  https://alibaba.github.io/arthas/sc")
public class SearchClassCommand
extends AnnotatedCommand {
    private String classPattern;
    private boolean isDetail = false;
    private boolean isField = false;
    private boolean isRegEx = false;
    private Integer expand;

    @Argument(argName="class-pattern", index=0)
    @Description(value="Class name pattern, use either '.' or '/' as separator")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Option(shortName="d", longName="details", flag=true)
    @Description(value="Display the details of class")
    public void setDetail(boolean detail) {
        this.isDetail = detail;
    }

    @Option(shortName="f", longName="field", flag=true)
    @Description(value="Display all the member variables")
    public void setField(boolean field) {
        this.isField = field;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (0 by default)")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    @Override
    public void process(CommandProcess process) {
        RowAffect affect = new RowAffect();
        Instrumentation inst = process.session().getInstrumentation();
        ArrayList matchedClasses = new ArrayList(SearchUtils.searchClass(inst, this.classPattern, this.isRegEx));
        Collections.sort(matchedClasses, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return StringUtils.classname(c1).compareTo(StringUtils.classname(c2));
            }
        });
        for (Class clazz : matchedClasses) {
            this.processClass(process, clazz);
        }
        affect.rCnt(matchedClasses.size());
        process.write(affect + "\n");
        process.end();
    }

    private void processClass(CommandProcess process, Class<?> clazz) {
        if (this.isDetail) {
            process.write(RenderUtil.render((Element)ClassUtils.renderClassInfo(clazz, this.isField, this.expand), (int)process.width()) + "\n");
        } else {
            process.write(clazz.getName() + "\n");
        }
    }

    @Override
    public void complete(Completion completion) {
        if (!CompletionUtils.completeClassName(completion)) {
            super.complete(completion);
        }
    }
}

